/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.management.j2ee.servlet.DistributedSessionServerInfoImpl;
import jeus.management.j2ee.servlet.SessionContainerCentralStatsImpl;
import jeus.management.j2ee.servlet.SessionContainerStatsImpl;
import jeus.management.j2ee.servlet.SessionRouterMo;
import jeus.management.j2ee.servlet.SessionRouterStatsImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.net.SocketStream;
import jeus.servlet.common.SessionInfo;
import jeus.servlet.common.SessionInfo3;
import jeus.servlet.deployment.StartingException;
import jeus.sessionmanager.AbstractSessionManager;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.ManagerConfig;
import jeus.sessionmanager.Router;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.SessionFactory;
import jeus.sessionmanager.distributed.BackupManager;
import jeus.sessionmanager.distributed.BackupStore;
import jeus.sessionmanager.distributed.DistributedJkRouter;
import jeus.sessionmanager.distributed.DistributedManagerConfig;
import jeus.sessionmanager.distributed.DistributedRouter;
import jeus.sessionmanager.distributed.DistributedSessionMonitoring;
import jeus.sessionmanager.distributed.DistributedSessionServerInfo;
import jeus.sessionmanager.distributed.SCRemoteContainer;
import jeus.sessionmanager.distributed.network.SCAddress;
import jeus.sessionmanager.distributed.network.SCPacket;
import jeus.sessionmanager.distributed.network.SCTransceiver;
import jeus.sessionmanager.distributed.network.SCTransceiverFactory;
import jeus.sessionmanager.session.ByteArraySession;
import jeus.sessionmanager.session.DistributableSession;
import jeus.sessionmanager.session.Session;
import jeus.sessionmanager.util.SessionByteArrayOutputStream;
import jeus.util.message.JeusMessage_Session3;
import jeus.util.message.JeusMessage_Session4;

public class DistributedSessionManager
extends AbstractSessionManager
implements DistributedSessionMonitoring {
    private DistributedManagerConfig distManagerConfig;
    private final SCAddress localId;
    private SCRemoteContainer remoteContainer;
    private BackupManager backupManager;
    private BackupStore backupStore;
    private SCTransceiver transceiver;

    public DistributedSessionManager(SessionFactory sessionFactory, SessionConfig config, DistributedManagerConfig distManagerConfig) {
        super(sessionFactory, config);
        this.distManagerConfig = distManagerConfig;
        this.localId = new SCAddress(distManagerConfig);
        this.setName(this.localId.getEngineId());
        if (logger.isLoggable(JeusMessage_Session3._37056_LEVEL)) {
            logger.log(JeusMessage_Session3._37056_LEVEL, JeusMessage_Session3._37056, (Object[])new String[]{this.getInfo(), this.localId.getSessionRoutingId(), this.localId.toString()});
        }
    }

    public void doStart() throws Exception {
        super.doStart();
        Router router = this.getRouter();
        DistributedRouter distRouter = null;
        if (!(router instanceof DistributedRouter)) {
            throw new StartingException(router + " is not supported");
        }
        distRouter = (DistributedRouter)router;
        String primary = this.localId.getEngineId();
        String backup = null;
        SCAddress backupAddr = this.localId.getBackupAddress();
        if (backupAddr != null) {
            backup = backupAddr.getEngineId();
        }
        distRouter.setRouterInfo(primary, backup);
        if (distRouter.getPrimary() == null) {
            throw new StartingException(router + " set primary");
        }
        boolean needBackupThread = false;
        if (this.backupManager == null) {
            this.backupManager = new BackupManager(this.localId, this.distManagerConfig);
            this.backupManager.recover();
            if (this.distManagerConfig.getBackupName() != null) {
                needBackupThread = true;
            }
        }
        if (this.backupStore == null) {
            this.backupStore = new BackupStore(this.localId, this.distManagerConfig);
            this.backupStore.recover();
        }
        if (this.transceiver == null) {
            this.transceiver = SCTransceiverFactory.createSCTransceiver(this.distManagerConfig.getNetworkScope(), this.distManagerConfig);
            try {
                this.transceiver.start();
            }
            catch (Throwable t) {
                throw new StartingException(t);
            }
            this.transceiver.registerSessionManager(this);
        }
        if (this.remoteContainer == null) {
            this.remoteContainer = new SCRemoteContainer(this, this.transceiver);
        }
        if (needBackupThread) {
            this.backupManager.startBackupThread(this.remoteContainer);
        }
    }

    public void doStop() throws Exception {
        if (this.distManagerConfig.isStopWithPassivation()) {
            try {
                this.passivate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.backupManager != null) {
            this.backupManager.destroy();
            this.backupManager = null;
        }
        if (this.backupStore != null) {
            this.backupStore.destroy();
            this.backupStore = null;
        }
        if (this.remoteContainer != null) {
            this.remoteContainer.destroy();
            this.remoteContainer = null;
        }
        if (this.transceiver != null) {
            this.transceiver.unregisterSessionManager(this);
            SCTransceiverFactory.destroySCTransceiver(this.distManagerConfig.getNetworkScope());
            this.transceiver = null;
        }
        super.doStop();
    }

    public Session createSession(String sessionId, Object param) {
        Session session = super.createSession(sessionId, param);
        if (!(session instanceof DistributableSession)) {
            if (logger.isLoggable(JeusMessage_Session3._39301_LEVEL)) {
                logger.log(JeusMessage_Session3._39301_LEVEL, JeusMessage_Session3._39301, new Object[]{this.getInfo(), this.localId, session});
            }
            return null;
        }
        this.sessions.put(session.getInternalId(), session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Session session) {
        if (session == null) {
            return;
        }
        String internalId = session.getInternalId();
        ConcurrentHashMap concurrentHashMap = this.sessions;
        synchronized (concurrentHashMap) {
            this.sessions.remove(internalId);
            if (this.isStarted()) {
                this.backupManager.removeSession(internalId);
            }
        }
        this.destroyFromServer(this.localId.getBackupAddress(), internalId);
        if (logger.isLoggable(JeusMessage_Session3._37090_LEVEL)) {
            logger.log(JeusMessage_Session3._37090_LEVEL, JeusMessage_Session3._37090, (Object[])new String[]{this.getInfo(), session.getId()});
        }
        super.destroy(session);
    }

    public Session getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        if (logger.isLoggable(JeusMessage_Session3._37060_LEVEL)) {
            logger.log(JeusMessage_Session3._37060_LEVEL, JeusMessage_Session3._37060, (Object[])new String[]{this.getInfo(), sessionId});
        }
        DistributedRouter distRouter = (DistributedRouter)this.getRouter();
        String internalId = distRouter.strip(sessionId);
        String primary = distRouter.getPrimaryFromId(sessionId);
        if (primary == null) {
            if (logger.isLoggable(JeusMessage_Session3._39302_LEVEL)) {
                logger.log(JeusMessage_Session3._39302_LEVEL, JeusMessage_Session3._39302, (Object[])new String[]{this.getInfo(), this.localId.toString(), sessionId});
            }
            primary = distRouter.getPrimary();
        }
        String backup = distRouter.getBackupFromPrimary(primary);
        DistributableSession session = null;
        SCAddress remoteDest = null;
        boolean activation = false;
        if (distRouter.getPrimary().equals(primary)) {
            session = this.getLocalSession(internalId, false);
            if (session != null) {
                try {
                    activation = session.activateSession();
                }
                catch (Exception e) {
                    this.destroy(session);
                    return null;
                }
                if (activation) {
                    this.notifySessionActivation(session);
                    if (logger.isLoggable(JeusMessage_Session4._49005_LEVEL)) {
                        logger.log(JeusMessage_Session4._49005_LEVEL, JeusMessage_Session4._49005, (Object[])new String[]{this.getInfo(), session.getId()});
                    }
                }
                if (this.validate(session)) {
                    if (logger.isLoggable(JeusMessage_Session3._37062_LEVEL)) {
                        logger.log(JeusMessage_Session3._37062_LEVEL, JeusMessage_Session3._37062, (Object[])new String[]{this.getInfo(), sessionId});
                    }
                    return session;
                }
                if (logger.isLoggable(JeusMessage_Session3._37063_LEVEL)) {
                    logger.log(JeusMessage_Session3._37063_LEVEL, JeusMessage_Session3._37063, (Object[])new String[]{this.getInfo(), sessionId});
                }
                return null;
            }
            if (backup != null) {
                try {
                    remoteDest = new SCAddress(backup, DistributedJkRouter.getOnlyRouterExtraInfo(this.localId.getEngineId()));
                    remoteDest.setBackup(true);
                }
                catch (IllegalArgumentException e) {
                    remoteDest = null;
                }
            }
        } else {
            try {
                remoteDest = new SCAddress(primary, backup, DistributedJkRouter.getOnlyRouterExtraInfo(this.localId.getEngineId()));
            }
            catch (IllegalArgumentException e) {
                remoteDest = null;
            }
        }
        if (remoteDest == null) {
            return null;
        }
        session = this.getSessionFromServer(remoteDest, internalId);
        if (session == null) {
            return null;
        }
        try {
            activation = session.activateSession();
        }
        catch (Exception e) {
            this.destroy(session);
            return null;
        }
        this.sessions.put(internalId, session);
        if (activation && !remoteDest.isBackupAddress()) {
            this.notifySessionActivation(session);
            if (logger.isLoggable(JeusMessage_Session4._49005_LEVEL)) {
                logger.log(JeusMessage_Session4._49005_LEVEL, JeusMessage_Session4._49005, (Object[])new String[]{this.getInfo(), session.getId()});
            }
        }
        return session;
    }

    public void updateSession(Session session, boolean synchronousSending) throws Exception {
        if (!this.isStarted()) {
            return;
        }
        if (!(session instanceof DistributableSession)) {
            return;
        }
        if (session.isExpired()) {
            return;
        }
        DistributableSession distSession = (DistributableSession)session;
        switch (this.distManagerConfig.getCheckLevelInt()) {
            case 3: {
                distSession.setNeedUpdate(true);
                break;
            }
            case 2: {
                if (!distSession.getAccess()) break;
                distSession.setNeedUpdate(true);
                break;
            }
            case 1: {
                break;
            }
        }
        if (session.isNeedUpdate()) {
            this.backupManager.backupToRemote(distSession, synchronousSending);
            distSession.setNeedUpdate(false);
            distSession.setGetAccess(false);
            return;
        }
    }

    public void passivate() {
        this.passivateLocal(true);
        this.passivateBackup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scavenge(long timeStamp) {
        if (!this.scavengeFlag.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.scavengeTimeStamp == timeStamp) {
                return;
            }
            if (logger.isLoggable(JeusMessage_Session3._37731_LEVEL)) {
                logger.log(JeusMessage_Session3._37731_LEVEL, JeusMessage_Session3._37731, (Object)this.getInfo());
            }
            this.scavengeLocal();
            this.scavengeBackup();
            this.passivateLocal(false);
            this.passivateBackup(false);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.scavengeTimeStamp = timeStamp;
            this.scavengeFlag.compareAndSet(true, false);
        }
    }

    public ManagerConfig getManagerConfig() {
        return this.distManagerConfig;
    }

    public SessionInfo getSessionInfo() {
        SessionInfo3 info = new SessionInfo3();
        info.setVersion(3);
        info.setLocalSessionSize(this.sessions.size());
        if (!this.isStarted()) {
            info.setFileDBSessionCount(this.backupManager.getPassivatedSessionsCount());
            info.setFileDBSize(this.backupManager.getPassivatedSessionsFileSize());
            info.setBackupFileDBSessionCount(this.backupStore.getPassivatedSessionsCount());
            info.setBackupFileDBSize(this.backupStore.getPassivatedSessionsFileSize());
            info.setConnectionStatus(this.transceiver.getConnectionStatus());
        }
        return info;
    }

    public int getAllSessionsSize() {
        return this.sessions.size();
    }

    public int getActiveSessionsSize() {
        return this.getAllSessionsSize();
    }

    public int getPassivateSessionsSize() {
        if (!this.isStarted()) {
            return -1;
        }
        return this.backupManager.getPassivatedSessionsCount();
    }

    public int getLocalSessionsSize() {
        return this.getAllSessionsSize();
    }

    public void createMBean(ObjectName parent, String exportName) {
        block3: {
            if (this.sessionManagedObject == null) {
                try {
                    this.sessionManagedObject = SessionRouterMo.createMBean("Distributed_Session_Server-" + this.distManagerConfig.getServerName(), parent, this);
                }
                catch (InstanceAlreadyExistsException e) {
                    if (!logger.isLoggable(JeusMessage_Session3._37804_LEVEL)) break block3;
                    logger.log(JeusMessage_Session3._37804_LEVEL, JeusMessage_Session3._37804, (Object[])new String[]{this.getInfo(), exportName}, (Throwable)e);
                }
            }
        }
    }

    public Stats updateStats(SessionContainerStatsImpl stats) {
        if (!(stats instanceof SessionRouterStatsImpl)) {
            return new SessionContainerCentralStatsImpl();
        }
        SessionRouterStatsImpl distributedStats = (SessionRouterStatsImpl)stats;
        int active_size = this.sessions.size();
        ((CountStatisticImpl)distributedStats.getLocalSessionCount()).setValue((long)active_size);
        if (this.isStarted()) {
            int passivated_size = this.backupManager.getPassivatedSessionsCount();
            ((CountStatisticImpl)distributedStats.getPassivatedSessionCount()).setValue((long)passivated_size);
            ((CountStatisticImpl)distributedStats.getLocalFileDbSize()).setValue(this.backupManager.getPassivatedSessionsFileSize());
            ((CountStatisticImpl)distributedStats.getBackupSessionCount()).setValue((long)this.backupStore.getInMemorySessionsCount());
            ((CountStatisticImpl)distributedStats.getPassivatedBackupSessionCount()).setValue((long)this.backupStore.getPassivatedSessionsCount());
            ((CountStatisticImpl)distributedStats.getBackupFileDbSize()).setValue(this.backupStore.getPassivatedSessionsFileSize());
            ((CountStatisticImpl)distributedStats.getConnectionCount()).setValue((long)this.transceiver.getConnectionCount());
        }
        return stats;
    }

    public boolean isExist(String key) {
        if (key == null) {
            return false;
        }
        Router router = this.config.getRouter();
        String internalSessionID = router.strip(key);
        DistributableSession session = this.getLocalSession(internalSessionID, false);
        return session != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getLocalSessionKeys() {
        HashSet keySet = new HashSet();
        ConcurrentHashMap concurrentHashMap = this.sessions;
        synchronized (concurrentHashMap) {
            keySet.addAll(this.sessions.keySet());
            keySet.addAll(this.backupManager.getLocalStorageSessionKeys());
        }
        return new ArrayList(keySet);
    }

    public boolean invalidateSession(String id) {
        if (id == null) {
            return false;
        }
        DistributableSession session = this.getLocalSession(id, false);
        if (session != null) {
            this.destroy(session);
            return true;
        }
        return false;
    }

    public Hashtable getConnectionStatus() {
        if (this.isStarted()) {
            return this.transceiver.getConnectionStatus();
        }
        return Constants.EMPTY_HASHTABLE;
    }

    public DistributedSessionServerInfo getServerInfo() {
        DistributedSessionServerInfoImpl info = new DistributedSessionServerInfoImpl();
        info.setServerName(this.distManagerConfig.getServerName());
        info.setBackupName(this.distManagerConfig.getBackupName());
        return info;
    }

    public void passivate(Session session) {
        if (session == null) {
            return;
        }
        super.passivate(session);
        this.sessions.remove(session.getInternalId());
    }

    public String toString() {
        return "D-SessionManager@" + Integer.toHexString(this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCPacket migrate(String internalId, SCPacket pkt, boolean fromBackup) {
        if (!this.isStarted()) {
            pkt.header.setOpcode(131328);
            pkt.header.setErrorCode(0);
            pkt.header.setBodyLength(0);
            return pkt;
        }
        DistributableSession session = null;
        if (fromBackup) {
            session = this.getBackupSession(internalId, true);
        } else {
            session = this.getLocalSession(internalId, true);
            if (!this.validate(session)) {
                session = null;
            }
        }
        if (session == null) {
            pkt.header.setOpcode(65792);
            pkt.header.setBodyLength(0);
            return pkt;
        }
        if (!fromBackup) {
            if (logger.isLoggable(JeusMessage_Session3._39303_LEVEL)) {
                logger.log(JeusMessage_Session3._39303_LEVEL, JeusMessage_Session3._39303, (Object[])new String[]{this.getInfo(), this.localId.toString(), internalId});
            }
            ConcurrentHashMap concurrentHashMap = this.sessions;
            synchronized (concurrentHashMap) {
                this.passivate(session);
                this.backupManager.removeSession(internalId);
            }
        }
        SessionByteArrayOutputStream sbaos = (SessionByteArrayOutputStream)Constants.SESSION_OUTPUT_STREAM.get();
        sbaos.reset();
        session.getWriteLock().lock();
        try {
            session.writeSession(sbaos);
        }
        catch (Exception e) {
        }
        finally {
            session.getWriteLock().unlock();
        }
        pkt.header.setOpcode(65792);
        pkt.setBody(sbaos.getByteArray(), 0, sbaos.getCount());
        return pkt;
    }

    public void dumpBackup() {
        if (!this.isStarted()) {
            return;
        }
        this.backupManager.dumpBackup(this.sessions);
    }

    public void addBackupSession(int count, byte[] robj, SocketStream sockStream) {
        if (!this.isStarted()) {
            return;
        }
        this.backupStore.backup(count, robj, sockStream);
    }

    public DistributableSession createDistributableSessionType() {
        Session session = this.sessionFactory.createSession(this.config, null);
        if (!(session instanceof DistributableSession)) {
            return null;
        }
        return (DistributableSession)session;
    }

    public SCAddress getLocalId() {
        return this.localId;
    }

    public DistributableSession getBackupSession(String internalId, boolean migrate) {
        if (!this.isStarted()) {
            return null;
        }
        DistributableSession session = null;
        ByteArraySession byteSession = this.backupStore.getSession(internalId, migrate);
        if (byteSession == null) {
            return null;
        }
        session = this.createDistributableSessionType();
        if (session == null) {
            return null;
        }
        session.setByteSession(byteSession);
        session.setNewStatus(false);
        return session;
    }

    public void removeBackupSession(String internalId) {
        if (!this.isStarted()) {
            return;
        }
        this.backupStore.destroy(internalId);
    }

    public SCTransceiver getTransceiver() {
        return this.transceiver;
    }

    protected DistributableSession getSessionFromServer(SCAddress destination, String internalId) {
        DistributableSession session;
        if (!this.isStarted()) {
            return null;
        }
        if (logger.isLoggable(JeusMessage_Session3._37061_LEVEL)) {
            logger.log(JeusMessage_Session3._37061_LEVEL, JeusMessage_Session3._37061, (Object[])new String[]{this.getInfo(), internalId, destination == null ? "none" : destination.toString()});
        }
        if ((session = this.remoteContainer.getRemoteSession(destination, internalId)) == null) {
            if (logger.isLoggable(JeusMessage_Session3._37065_LEVEL)) {
                logger.log(JeusMessage_Session3._37065_LEVEL, JeusMessage_Session3._37065, (Object[])new String[]{this.getInfo(), internalId, destination == null ? "none" : destination.toString()});
            }
            return null;
        }
        return session;
    }

    protected void destroyFromServer(SCAddress destination, String internalId) {
        if (!this.isStarted()) {
            return;
        }
        if (logger.isLoggable(JeusMessage_Session3._39304_LEVEL)) {
            logger.log(JeusMessage_Session3._39304_LEVEL, JeusMessage_Session3._39304, (Object[])new String[]{this.getInfo(), this.localId.toString(), internalId, destination == null ? "none" : destination.toString()});
        }
        this.remoteContainer.removeSession(destination, internalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DistributableSession getLocalSession(String internalId, boolean migrate) {
        if (!this.isStarted()) {
            return null;
        }
        DistributableSession session = null;
        ConcurrentHashMap concurrentHashMap = this.sessions;
        synchronized (concurrentHashMap) {
            Object obj = this.sessions.get(internalId);
            if (obj instanceof DistributableSession) {
                return (DistributableSession)obj;
            }
            ByteArraySession byteSession = this.backupManager.getLocalStorageSession(internalId, migrate);
            if (byteSession != null) {
                session = this.createDistributableSessionType();
                if (session == null) {
                    return null;
                }
                session.setByteSession(byteSession);
                session.setNewStatus(false);
                this.sessions.put(internalId, session);
                return session;
            }
        }
        return null;
    }

    private void scavengeLocal() {
        this.scavenge();
    }

    private void scavengeBackup() {
        if (!this.isStarted()) {
            return;
        }
        this.backupStore.scavenge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passivateLocal(boolean all) {
        if (!this.isStarted() && !this.isStopping()) {
            return;
        }
        if (this.sessions.size() <= 0) {
            return;
        }
        long passivationTo = this.distManagerConfig.getFilePassivationTo();
        if (!all && passivationTo <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        HashMap<String, DistributableSession> passivationSessions = new HashMap<String, DistributableSession>();
        ConcurrentHashMap concurrentHashMap = this.sessions;
        synchronized (concurrentHashMap) {
            for (Object obj : this.sessions.values()) {
                if (!(obj instanceof DistributableSession)) continue;
                DistributableSession session = (DistributableSession)obj;
                if (all) {
                    this.passivate(session);
                    passivationSessions.put(session.getInternalId(), session);
                    continue;
                }
                if (!session.checkPassivation(currentTime, passivationTo)) continue;
                this.passivate(session);
                passivationSessions.put(session.getInternalId(), session);
            }
            this.backupManager.storeSessions(passivationSessions);
        }
        passivationSessions.clear();
    }

    private void passivateBackup(boolean all) {
        if (!this.isStarted() && !this.isStopping()) {
            return;
        }
        this.backupStore.passivate(all, this.distManagerConfig.getFilePassivationTo());
    }
}

