/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed;

import java.io.IOException;
import jeus.net.SocketStreamResurrectListener;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.distributed.DistributedJkRouter;
import jeus.sessionmanager.distributed.DistributedRouter;
import jeus.sessionmanager.distributed.DistributedSessionManager;
import jeus.sessionmanager.distributed.network.SCAddress;
import jeus.sessionmanager.distributed.network.SCBackupPacket;
import jeus.sessionmanager.distributed.network.SCConstants;
import jeus.sessionmanager.distributed.network.SCPacket;
import jeus.sessionmanager.distributed.network.SCSimplePacket;
import jeus.sessionmanager.distributed.network.SCTransceiver;
import jeus.sessionmanager.session.DistributableSession;
import jeus.sessionmanager.util.SessionByteArrayOutputStream;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session3;

public class SCRemoteContainer
implements SCConstants {
    private static final JeusLogger logger = Constants.DISTRIBUTED_SESSION_LOGGER;
    private DistributedSessionManager manager;
    private SCAddress localId;
    private SCTransceiver transceiver;

    public SCRemoteContainer(DistributedSessionManager manager, SCTransceiver transceiver) {
        this.manager = manager;
        this.localId = manager.getLocalId();
        this.transceiver = transceiver;
    }

    public void destroy() {
        this.manager = null;
        this.localId = null;
        this.transceiver = null;
    }

    public DistributableSession getRemoteSession(SCAddress dest, String internalId) {
        if (dest == null) {
            return null;
        }
        if (dest.isBackupAddress() && this.isLocal(dest)) {
            return this.manager.getBackupSession(internalId, false);
        }
        DistributableSession session = null;
        SCSimplePacket sndpkt = new SCSimplePacket();
        sndpkt.setName(dest.getEngineId());
        sndpkt.header.setOpcode(256);
        if (dest.isBackupAddress()) {
            sndpkt.header.setFlag(4);
        }
        ((SCPacket)sndpkt).addBody(internalId.getBytes());
        try {
            SCPacket rcvpkt = this.transceive(dest, sndpkt);
            if (rcvpkt == null) {
                if (logger.isLoggable(JeusMessage_Session3._37040_LEVEL)) {
                    logger.log(JeusMessage_Session3._37040_LEVEL, JeusMessage_Session3._37040, (Object[])new String[]{this.localId.toString(), dest.toString(), internalId});
                }
                return this.getRemoteSession(dest.getBackupAddress(), internalId);
            }
            byte[] result = rcvpkt.getBody();
            if (result == null) {
                return null;
            }
            session = this.manager.createDistributableSessionType();
            if (session == null) {
                return null;
            }
            session.initialize(internalId);
            try {
                session.readSession(result);
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_Session3._39201_LEVEL)) {
                    logger.log(JeusMessage_Session3._39201_LEVEL, JeusMessage_Session3._39201, (Object[])new String[]{this.localId.toString(), internalId, dest.toString()});
                }
                return null;
            }
            return session;
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session3._37040_LEVEL)) {
                logger.log(JeusMessage_Session3._37040_LEVEL, JeusMessage_Session3._37040, (Object[])new String[]{this.localId.toString(), dest.toString(), internalId}, (Throwable)ioe);
            }
            return this.getRemoteSession(dest.getBackupAddress(), internalId);
        }
    }

    public boolean removeSession(SCAddress addr, String internalId) {
        if (addr == null) {
            return false;
        }
        SCSimplePacket sndpkt = new SCSimplePacket();
        sndpkt.setName(addr.getEngineId());
        sndpkt.header.setOpcode(258);
        if (addr.isBackupAddress()) {
            sndpkt.header.setFlag(4);
        }
        ((SCPacket)sndpkt).addBody(internalId.getBytes());
        try {
            if (logger.isLoggable(JeusMessage_Session3._37091_LEVEL)) {
                logger.log(JeusMessage_Session3._37091_LEVEL, JeusMessage_Session3._37091, new Object[]{addr.toString(), internalId});
            }
            SCPacket rcvpkt = this.transceive(addr, sndpkt);
            if (logger.isLoggable(JeusMessage_Session3._37088_LEVEL)) {
                logger.log(JeusMessage_Session3._37088_LEVEL, JeusMessage_Session3._37088, new Object[]{addr.toString(), internalId});
            }
            return rcvpkt != null;
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session3._37043_LEVEL)) {
                logger.log(JeusMessage_Session3._37043_LEVEL, JeusMessage_Session3._37043, (Object[])new String[]{this.localId.toString(), addr.toString(), internalId}, (Throwable)ioe);
            }
            return false;
        }
    }

    public boolean backupSession(SCAddress backupServer, int sessionCount, SessionByteArrayOutputStream backupSbaos) {
        try {
            SCBackupPacket sndpkt = new SCBackupPacket(sessionCount, backupSbaos);
            sndpkt.setName(backupServer.getEngineId());
            SCPacket rcvpkt = null;
            rcvpkt = this.transceive(backupServer, sndpkt);
            if (rcvpkt == null) {
                if (logger.isLoggable(JeusMessage_Session3._37044_LEVEL)) {
                    logger.log(JeusMessage_Session3._37044_LEVEL, JeusMessage_Session3._37044, (Object[])new String[]{this.localId.toString(), backupServer.toString()});
                }
                return false;
            }
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session3._37044_LEVEL)) {
                logger.log(JeusMessage_Session3._37044_LEVEL, JeusMessage_Session3._37044, (Object[])new String[]{this.localId.toString(), backupServer.toString()}, (Throwable)ioe);
            }
            return false;
        }
        return true;
    }

    public boolean isAlive(SCAddress addr) {
        return addr != null && this.transceiver != null && this.transceiver.isAlive(addr.getSocketId());
    }

    public void registerServerForChecking(SCAddress addr, SocketStreamResurrectListener listener, long period) {
        if (addr == null || this.transceiver == null || listener == null) {
            return;
        }
        this.transceiver.registerServerForChecking(addr.getSocketId(), listener, period);
    }

    public void unregisterServerForChecking(SCAddress addr) {
        if (addr == null || this.transceiver == null) {
            return;
        }
        this.transceiver.unregisterServerForChecking(addr.getSocketId());
    }

    private SCPacket transceive(SCAddress destid, SCPacket sndpkt) throws IOException {
        if (destid == null || this.transceiver == null) {
            throw new IOException("SCRemoteContainer is already destroyed");
        }
        return this.transceiver.transceive(sndpkt, destid.getSocketId());
    }

    private boolean isLocal(SCAddress addr) {
        if (addr == null) {
            return false;
        }
        DistributedRouter router = (DistributedRouter)this.manager.getRouter();
        return router.getPrimary().equals(DistributedJkRouter.getOnlyRouterInfo(addr.getEngineId()));
    }
}

