/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed.network;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.net.SocketStream;
import jeus.net.impl.SocketStream14;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.distributed.DistributedSessionManager;
import jeus.sessionmanager.distributed.network.SCConstants;
import jeus.sessionmanager.distributed.network.SCPacket;
import jeus.sessionmanager.distributed.network.SCPacketHeader;
import jeus.sessionmanager.distributed.network.SCTransceiver;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session3;

final class MessageHandler
implements SCConstants {
    private static final JeusLogger logger = Constants.DISTRIBUTED_SESSION_LOGGER;
    private ConcurrentHashMap managerMap;
    private SCTransceiver transceiver;
    private AtomicBoolean destroyed = new AtomicBoolean();

    public MessageHandler(ConcurrentHashMap managerMap, SCTransceiver transceiver) {
        this.managerMap = managerMap;
        this.transceiver = transceiver;
        this.destroyed.set(false);
    }

    public void destroy() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        this.managerMap = null;
        this.transceiver = null;
    }

    public void handleMessage(byte[] message, SocketStream14 sockStream) {
        SCPacket rcvpkt;
        try {
            rcvpkt = SCPacket.recv(message);
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_Session3._37110_LEVEL)) {
                logger.log(JeusMessage_Session3._37110_LEVEL, JeusMessage_Session3._37110, (Object)sockStream.getSocketID().toString(), (Throwable)e);
            }
            this.disconnect((SocketStream)sockStream);
            return;
        }
        try {
            this.handleRequest(rcvpkt, sockStream);
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Session3._37110_LEVEL)) {
                logger.log(JeusMessage_Session3._37110_LEVEL, JeusMessage_Session3._37110, (Object)sockStream.getSocketID().toString(), (Throwable)e);
            }
            this.disconnect((SocketStream)sockStream);
        }
    }

    private void disconnect(SocketStream sockStream) {
        if (sockStream != null) {
            sockStream.destroy();
        }
    }

    private void handleRequest(SCPacket rcvpkt, SocketStream14 sockStream) {
        if (this.destroyed.get()) {
            return;
        }
        SCPacket reply = null;
        int opcode = rcvpkt.header.getOpcode();
        try {
            switch (opcode) {
                case 5: {
                    reply = this.handlePingSession(rcvpkt, (SocketStream)sockStream);
                    break;
                }
                case 256: {
                    reply = this.handleMigrateSession(rcvpkt, (SocketStream)sockStream);
                    break;
                }
                case 259: {
                    reply = this.handleBackupSession(rcvpkt, (SocketStream)sockStream);
                    break;
                }
                case 258: {
                    reply = this.handleRemoveSession(rcvpkt, (SocketStream)sockStream);
                    break;
                }
                default: {
                    if (logger.isLoggable(JeusMessage_Session3._37011_LEVEL)) {
                        logger.log(JeusMessage_Session3._37011_LEVEL, JeusMessage_Session3._37011, (Object[])new String[]{sockStream.toString(), Integer.toHexString(opcode), rcvpkt.getName()});
                    }
                    reply = this.setErrorPacket(rcvpkt, opcode, 1);
                    break;
                }
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Session3._37017_LEVEL)) {
                logger.log(JeusMessage_Session3._37017_LEVEL, JeusMessage_Session3._37017, (Object[])new String[]{sockStream.toString(), Integer.toHexString(opcode), rcvpkt.getName()}, (Throwable)e);
            }
            reply = this.setErrorPacket(rcvpkt, opcode, 5);
        }
        if (reply != null && this.transceiver != null && !this.destroyed.get()) {
            this.transceiver.reply(reply, sockStream);
        }
    }

    private SCPacket handlePingSession(SCPacket rcvpkt, SocketStream sockStream) {
        if (this.destroyed.get()) {
            if (logger.isLoggable(JeusMessage_Session3._37018_LEVEL)) {
                logger.log(JeusMessage_Session3._37018_LEVEL, JeusMessage_Session3._37018, (Object[])new String[]{sockStream.toString(), Integer.toHexString(5), rcvpkt.getName()});
            }
            return this.setErrorPacket(rcvpkt, 5, 4);
        }
        rcvpkt.header.setOpcode(65541);
        rcvpkt.header.setBodyLength(0);
        return rcvpkt;
    }

    private SCPacket handleMigrateSession(SCPacket rcvpkt, SocketStream sockStream) {
        boolean fromBackup;
        if (this.destroyed.get()) {
            if (logger.isLoggable(JeusMessage_Session3._37018_LEVEL)) {
                logger.log(JeusMessage_Session3._37018_LEVEL, JeusMessage_Session3._37018, (Object[])new String[]{sockStream.toString(), Integer.toHexString(256), rcvpkt.getName()});
            }
            return this.setErrorPacket(rcvpkt, 256, 4);
        }
        DistributedSessionManager manager = this.findManagerFromPacket(rcvpkt);
        if (manager == null) {
            if (logger.isLoggable(JeusMessage_Session3._37019_LEVEL)) {
                logger.log(JeusMessage_Session3._37019_LEVEL, JeusMessage_Session3._37019, (Object[])new String[]{sockStream.toString(), Integer.toHexString(256), rcvpkt.getName()});
            }
            return this.setErrorPacket(rcvpkt, 256, 3);
        }
        int len = rcvpkt.header.getBodyLength();
        boolean bl = fromBackup = (rcvpkt.header.getFlag() & 4) != 0;
        if (len <= 0) {
            return this.setErrorPacket(rcvpkt, 256, 1);
        }
        String sessionid = new String(rcvpkt.getBody(len));
        return manager.migrate(sessionid, rcvpkt, fromBackup);
    }

    private SCPacket handleBackupSession(SCPacket rcvpkt, SocketStream sockStream) {
        if (this.destroyed.get()) {
            if (logger.isLoggable(JeusMessage_Session3._37018_LEVEL)) {
                logger.log(JeusMessage_Session3._37018_LEVEL, JeusMessage_Session3._37018, (Object[])new String[]{sockStream.toString(), Integer.toHexString(259), rcvpkt.getName()});
            }
            return this.setErrorPacket(rcvpkt, 259, 4);
        }
        DistributedSessionManager manager = this.findManagerFromPacket(rcvpkt);
        if (manager == null) {
            if (logger.isLoggable(JeusMessage_Session3._37019_LEVEL)) {
                logger.log(JeusMessage_Session3._37019_LEVEL, JeusMessage_Session3._37019, (Object[])new String[]{sockStream.toString(), Integer.toHexString(259), rcvpkt.getName()});
            }
            return this.setErrorPacket(rcvpkt, 259, 3);
        }
        SCPacketHeader header = rcvpkt.header;
        int sessionCount = header.getFlag();
        if (sessionCount <= 0) {
            rcvpkt.header.setOpcode(65795);
            rcvpkt.header.setBodyLength(0);
            return rcvpkt;
        }
        byte[] robj = rcvpkt.getBody();
        manager.addBackupSession(sessionCount, robj, sockStream);
        rcvpkt.header.setOpcode(65795);
        rcvpkt.header.setBodyLength(0);
        return rcvpkt;
    }

    private SCPacket handleRemoveSession(SCPacket rcvpkt, SocketStream sockStream) {
        boolean fromBackup;
        if (this.destroyed.get()) {
            if (logger.isLoggable(JeusMessage_Session3._37018_LEVEL)) {
                logger.log(JeusMessage_Session3._37018_LEVEL, JeusMessage_Session3._37018, (Object[])new String[]{sockStream.toString(), Integer.toHexString(258), rcvpkt.getName()});
            }
            return this.setErrorPacket(rcvpkt, 258, 4);
        }
        DistributedSessionManager manager = this.findManagerFromPacket(rcvpkt);
        if (manager == null) {
            if (logger.isLoggable(JeusMessage_Session3._37019_LEVEL)) {
                logger.log(JeusMessage_Session3._37019_LEVEL, JeusMessage_Session3._37019, (Object[])new String[]{sockStream.toString(), Integer.toHexString(258), rcvpkt.getName()});
            }
            return this.setErrorPacket(rcvpkt, 258, 3);
        }
        int len = rcvpkt.header.getBodyLength();
        boolean bl = fromBackup = (rcvpkt.header.getFlag() & 4) != 0;
        if (fromBackup && len > 0) {
            String internalId = new String(rcvpkt.getBody(len));
            if (logger.isLoggable(JeusMessage_Session3._37089_LEVEL)) {
                logger.log(JeusMessage_Session3._37089_LEVEL, JeusMessage_Session3._37089, (Object[])new String[]{sockStream.toString(), internalId});
            }
            manager.removeBackupSession(internalId);
        }
        rcvpkt.header.setOpcode(65794);
        rcvpkt.header.setBodyLength(0);
        return rcvpkt;
    }

    private SCPacket setErrorPacket(SCPacket rcvpkt, int opcode, int errorcode) {
        rcvpkt.header.setOpcode(opcode + 131072);
        rcvpkt.header.setErrorCode(errorcode);
        rcvpkt.header.setBodyLength(0);
        return rcvpkt;
    }

    private DistributedSessionManager findManagerFromPacket(SCPacket rcvpkt) {
        if (rcvpkt == null) {
            return null;
        }
        return (DistributedSessionManager)this.managerMap.get(rcvpkt.getName());
    }
}

