/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed.network;

import java.io.IOException;
import java.io.Serializable;
import javax.xml.bind.JAXBException;
import jeus.descriptor.sessionmanager.DistributedSessionManagerDescriptor;
import jeus.net.SocketID;
import jeus.net.impl.NodeInfo;
import jeus.sessionmanager.distributed.DistributedJkRouter;
import jeus.sessionmanager.distributed.DistributedManagerConfig;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_Session3;

public class SCAddress
implements Serializable {
    private String id;
    private String host;
    private int port;
    private String engineId;
    private SCAddress backupAddress;
    private boolean backup;
    private SocketID socketId;

    public SCAddress(DistributedManagerConfig distManagerConfig) {
        String primaryHostInfo = distManagerConfig.getServerName();
        String backupHostInfo = distManagerConfig.getBackupName();
        if (primaryHostInfo == null) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37035, (Object)primaryHostInfo));
        }
        int pos = primaryHostInfo.indexOf(":");
        if (pos <= 0) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37035, (Object)primaryHostInfo));
        }
        this.engineId = primaryHostInfo.substring(0, pos);
        int pos2 = primaryHostInfo.indexOf(":", pos + 1);
        if (pos2 < 0) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37035, (Object)primaryHostInfo));
        }
        this.host = primaryHostInfo.substring(pos + 1, pos2);
        try {
            this.port = Integer.parseInt(primaryHostInfo.substring(pos2 + 1));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37035, (Object)primaryHostInfo));
        }
        this.id = this.engineId + ":" + this.host + ":" + this.port;
        this.socketId = new NodeInfo(this.host, this.port, String.valueOf(this.port + 13));
        this.setBackup(false);
        if (backupHostInfo != null) {
            int pos3 = backupHostInfo.indexOf(":");
            if (pos3 > 0) {
                String bEngineId = backupHostInfo.substring(0, pos3);
                this.backupAddress = new SCAddress(DistributedJkRouter.getOnlyRouterInfo(bEngineId), DistributedJkRouter.getOnlyRouterExtraInfo(bEngineId));
                this.backupAddress.setBackup(true);
            } else {
                this.backupAddress = null;
            }
        } else {
            this.backupAddress = null;
        }
    }

    public SCAddress(String sroutingId, String info) {
        this(sroutingId, null, info);
    }

    public SCAddress(String primarySroutid, String backupSroutid, String info) {
        if (primarySroutid == null) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37035, (Object)primarySroutid));
        }
        this.engineId = info == null ? primarySroutid : primarySroutid + '-' + info;
        String hostInfo = null;
        try {
            hostInfo = DistributedSessionManagerDescriptor.getHostInfoFromFullEngineName(primarySroutid);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37035, (Object)primarySroutid));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37035, (Object)primarySroutid));
        }
        int pos = hostInfo.indexOf(":");
        if (pos <= 0) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37035, (Object)primarySroutid));
        }
        this.host = hostInfo.substring(0, pos);
        try {
            this.port = Integer.parseInt(hostInfo.substring(pos + 1));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37035, (Object)primarySroutid));
        }
        this.id = this.engineId + ":" + hostInfo;
        this.socketId = new NodeInfo(this.host, this.port, String.valueOf(this.port + 13));
        this.setBackup(false);
        if (backupSroutid != null) {
            this.backupAddress = new SCAddress(backupSroutid, info);
            this.backupAddress.setBackup(true);
        } else {
            this.backupAddress = null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public String getId() {
        return this.id;
    }

    public SocketID getSocketId() {
        return this.socketId;
    }

    public boolean isBackupAddress() {
        return this.backup;
    }

    public SCAddress getBackupAddress() {
        return this.backupAddress;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getId();
    }

    public String getSessionRoutingId() {
        return DistributedJkRouter.getOnlyRouterInfo(this.getEngineId());
    }

    public boolean equals(Object obj) {
        SocketID socketId;
        if (obj instanceof SCAddress) {
            return this == obj || this.id.equals(obj.toString());
        }
        return obj instanceof SocketID && this.port == (socketId = (SocketID)obj).getBasePort() && this.host.equals(socketId.getHost());
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }
}

