/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed.network;

import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.io.protocol.message.ContentHandlerCreator;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.ConnectorException;
import jeus.net.Endpoint;
import jeus.net.JeusSSLConfiguration;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.SocketStreamResurrectListener;
import jeus.net.helper.MsgSync;
import jeus.net.impl.NodeInfo;
import jeus.net.impl.SocketStream14;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.LifeCycleSupport;
import jeus.sessionmanager.distributed.DistributedSessionManager;
import jeus.sessionmanager.distributed.network.MessageHandler;
import jeus.sessionmanager.distributed.network.SCConstants;
import jeus.sessionmanager.distributed.network.SCPacket;
import jeus.sessionmanager.distributed.network.SCSimplePacket;
import jeus.sessionmanager.distributed.network.SessionManagerAcceptorConnectionListener;
import jeus.sessionmanager.util.SessionManagerUtil;
import jeus.util.PooledExecutorFactory;
import jeus.util.WaitTimeoutException;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.concurrent50.concurrent.ThreadPoolExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session3;
import jeus.util.properties.JeusManagerPropertyValues;

public final class SCTransceiver
extends LifeCycleSupport
implements SCConstants,
ConnectionListenerFactory {
    private static final transient JeusLogger logger = Constants.DISTRIBUTED_SESSION_LOGGER;
    private static final String THREAD_NAME_PREFIX = "DistributedSessionServerAcceptor";
    private static final int NETWORK_WRITE_LIMIT = 0xA00000;
    private static final int NETWORK_WRITE_RESTART_LIMIT = 0x300000;
    private static final int sendRetries = 1;
    private static final Object[] connectPiggybackData = new Object[0];
    private static ThreadPoolExecutor pooledExecutor;
    private Endpoint endpoint;
    private String hostname;
    private int virtualPort;
    private int threadPoolMinSize;
    private int threadPoolMaxSize;
    private long threadPoolResizePeriod;
    private int connectionTimeout;
    private int replyWaitTimeout;
    private boolean isNonBlocking;
    private int seqnoGenerator = 0;
    private NodeInfo nodeInfo = null;
    private boolean isSSL = false;
    private ConcurrentHashMap managerMap = new ConcurrentHashMap();

    public SCTransceiver(String hostname, int virtualPort, int threadPoolMinSize, int threadPoolMaxSize, long threadPoolResizePeriod, long connectionTimeout, long replyWaitTimeout, boolean isNio) {
        this.hostname = hostname;
        this.virtualPort = virtualPort;
        this.threadPoolMinSize = threadPoolMinSize;
        this.threadPoolMaxSize = threadPoolMaxSize;
        this.threadPoolResizePeriod = threadPoolResizePeriod;
        this.connectionTimeout = SessionManagerUtil.safeCasting(connectionTimeout);
        this.replyWaitTimeout = SessionManagerUtil.safeCasting(replyWaitTimeout);
        this.isNonBlocking = isNio;
    }

    protected void doStart() throws Exception {
        if (this.hostname == null) {
            throw new IOException("failed to start a session server acceptor. Host name is null");
        }
        String virtualID = String.valueOf(this.virtualPort);
        if (logger.isLoggable(JeusMessage_Session3._37080_LEVEL)) {
            logger.log(JeusMessage_Session3._37080_LEVEL, JeusMessage_Session3._37080, (Object)virtualID);
        }
        pooledExecutor = (ThreadPoolExecutor)PooledExecutorFactory.createPooledExecutor((String)THREAD_NAME_PREFIX, (int)this.threadPoolMaxSize, (int)this.threadPoolMinSize, (long)this.threadPoolResizePeriod);
        String name = "DistributedSessionRouterAcceptor";
        this.nodeInfo = this.isSSL ? new NodeInfo(this.hostname, this.virtualPort) : new NodeInfo(this.hostname, JeusManagerPropertyValues.getBasePort(), virtualID);
        try {
            this.endpoint = new Endpoint(name, this.isNonBlocking ? JeusIOComponentCreator.createNIOCreator((String)("IO-" + name), (int)0xA00000, (int)0x300000) : JeusIOComponentCreator.createBlockingCreator((String)("IO-" + name), (int)0), (SocketID)this.nodeInfo, (StreamContentHandlerCreator)new ContentHandlerCreator(), (ConnectionListenerFactory)this, (Object)(this.isSSL ? JeusSSLConfiguration.sslContext : null));
            this.endpoint.setConnectTimeout(this.connectionTimeout);
            this.endpoint.export();
        }
        catch (Exception e) {
            if (this.endpoint != null) {
                this.endpoint.unexport();
                this.endpoint = null;
            }
            throw e;
        }
    }

    protected void doStop() throws Exception {
        if (this.endpoint != null) {
            this.nodeInfo = null;
            this.endpoint.unexport();
            this.endpoint = null;
        }
        if (pooledExecutor != null) {
            pooledExecutor.shutdownNow();
            pooledExecutor = null;
        }
        this.managerMap.clear();
        this.nodeInfo = null;
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return new SessionManagerAcceptorConnectionListener(new MessageHandler(this.managerMap, this), this.managerMap, (Executor)pooledExecutor);
    }

    public void registerSessionManager(DistributedSessionManager manager) {
        if (manager == null) {
            return;
        }
        this.managerMap.put(manager.getName(), manager);
    }

    public void unregisterSessionManager(DistributedSessionManager manager) {
        if (manager == null) {
            return;
        }
        this.unregisterSessionManager(manager.getName());
    }

    public void unregisterSessionManager(String managerName) {
        if (managerName == null) {
            return;
        }
        this.managerMap.remove(managerName);
    }

    public SCPacket transceive(SCPacket pkt, SocketID remoteId) {
        if (pkt == null || remoteId == null) {
            return null;
        }
        SocketStream14 sockStream = null;
        try {
            sockStream = (SocketStream14)this.endpoint.getSocketStream(remoteId, 1, (Object)connectPiggybackData, this.connectionTimeout, this.replyWaitTimeout);
            if (sockStream == null || sockStream.isClosed()) {
                return null;
            }
        }
        catch (ConnectorException e) {
            if (logger.isLoggable(JeusMessage_Session3._37116_LEVEL)) {
                logger.log(JeusMessage_Session3._37116_LEVEL, JeusMessage_Session3._37116, (Object)remoteId.toString(), (Throwable)e);
            }
            this.close((SocketStream)sockStream);
            return null;
        }
        return this.transceive(pkt, sockStream);
    }

    public final boolean reply(SCPacket pkt, SocketStream14 sockStream) {
        return this.sendPacket(pkt, sockStream, null);
    }

    public boolean isAlive(SocketID id) {
        if (id == null) {
            return false;
        }
        return this.ping(id);
    }

    public int getConnectionCount() {
        SocketStream[] socketStreams = this.endpoint.getSocketStreams();
        if (socketStreams != null) {
            return socketStreams.length;
        }
        return 0;
    }

    public Hashtable getConnectionStatus() {
        Hashtable<String, Boolean> result = new Hashtable<String, Boolean>();
        SocketStream[] socketStreams = this.endpoint.getSocketStreams();
        for (int i = 0; i < socketStreams.length; ++i) {
            if (socketStreams[i] == null) continue;
            result.put(socketStreams[i].getSocketID().toString(), new Boolean(!socketStreams[i].isClosed()));
        }
        return result;
    }

    public boolean registerServerForChecking(SocketID socketID, SocketStreamResurrectListener listener, long period) {
        if (socketID == null || this.endpoint == null || listener == null) {
            return false;
        }
        this.endpoint.registerWatchSocketStream(socketID, listener, period, null, this.connectionTimeout, this.replyWaitTimeout);
        return true;
    }

    public boolean unregisterServerForChecking(SocketID socketID) {
        if (socketID == null || this.endpoint == null) {
            return false;
        }
        this.endpoint.cancelWatchSocketStream(socketID);
        return true;
    }

    private SCPacket transceive(SCPacket pkt, SocketStream14 sockStream) {
        if (pkt == null || sockStream == null) {
            return null;
        }
        pkt.header.setSeqno(this.getSeqno());
        MsgSync reply = new MsgSync((long)this.replyWaitTimeout);
        if (!this.sendPacket(pkt, sockStream, reply)) {
            return null;
        }
        return this.getReply(pkt, (SocketStream)sockStream, reply);
    }

    private SCPacket getReply(SCPacket sndpkt, SocketStream remote, MsgSync reply) {
        SCPacket rcvpkt;
        Object obj = null;
        try {
            obj = reply.waitReply();
        }
        catch (WaitTimeoutException wte) {
            this.logTimeoutError(sndpkt, remote, (Exception)((Object)wte));
            return null;
        }
        catch (IOException ie) {
            if (logger.isLoggable(JeusMessage_Session3._37109_LEVEL)) {
                logger.log(JeusMessage_Session3._37109_LEVEL, JeusMessage_Session3._37109, (Object)remote.getSocketID().toString(), (Throwable)ie);
            }
            this.close(remote);
            return null;
        }
        if (!(obj instanceof byte[])) {
            if (logger.isLoggable(JeusMessage_Session3._37108_LEVEL)) {
                logger.log(JeusMessage_Session3._37108_LEVEL, JeusMessage_Session3._37108, (Object)remote.getSocketID().toString());
            }
            this.close(remote);
            return null;
        }
        try {
            rcvpkt = SCPacket.recv((byte[])obj);
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_Session3._37110_LEVEL)) {
                logger.log(JeusMessage_Session3._37110_LEVEL, JeusMessage_Session3._37110, (Object)remote.getSocketID().toString(), (Throwable)e);
            }
            this.close(remote);
            return null;
        }
        return this.checkResponseError(sndpkt, rcvpkt, remote);
    }

    private SCPacket checkResponseError(SCPacket sndpkt, SCPacket rcvpkt, SocketStream remote) {
        int opcode = sndpkt.header.getOpcode();
        int r_opcode = rcvpkt.header.getOpcode();
        int errcode = rcvpkt.header.getErrorCode();
        if (r_opcode != opcode + 65536 || errcode != 0) {
            if (logger.isLoggable(JeusMessage_Session3._37022_LEVEL)) {
                logger.log(JeusMessage_Session3._37022_LEVEL, JeusMessage_Session3._37022, new Object[]{this.nodeInfo, Integer.toHexString(opcode), Integer.toHexString(r_opcode), SCPacket.getErrorMessage(errcode)});
            }
            if (errcode != 0) {
                this.close(remote);
            }
            return null;
        }
        return rcvpkt;
    }

    private void logTimeoutError(SCPacket sndpkt, SocketStream remote, Exception exception) {
        String opcode = "";
        String seqno = "";
        if (sndpkt != null) {
            try {
                opcode = "0x" + Integer.toHexString(sndpkt.header.getOpcode());
                seqno = "" + sndpkt.header.getSeqno();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (logger.isLoggable(JeusMessage_Session3._37021_LEVEL)) {
            logger.log(JeusMessage_Session3._37021_LEVEL, JeusMessage_Session3._37021, new Object[]{"(" + this.nodeInfo + " <--> " + remote.getSocketID() + ")", opcode, seqno}, (Throwable)exception);
        }
    }

    private boolean sendPacket(SCPacket pkt, SocketStream14 sockStream, MsgSync reply) {
        if (sockStream == null || pkt == null) {
            return false;
        }
        try {
            pkt.send(sockStream, reply);
        }
        catch (ConnectorException e) {
            if (logger.isLoggable(JeusMessage_Session3._37111_LEVEL)) {
                logger.log(JeusMessage_Session3._37111_LEVEL, JeusMessage_Session3._37111, (Object)sockStream.getSocketID().toString(), (Throwable)e);
            }
            this.close((SocketStream)sockStream);
            return false;
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_Session3._37111_LEVEL)) {
                logger.log(JeusMessage_Session3._37111_LEVEL, JeusMessage_Session3._37111, (Object)sockStream.getSocketID().toString(), (Throwable)e);
            }
            this.close((SocketStream)sockStream);
            return false;
        }
        return true;
    }

    private boolean ping(SocketID id) {
        if (id == null) {
            return false;
        }
        SocketStream14 sockStream = null;
        try {
            sockStream = (SocketStream14)this.endpoint.getSocketStream(id, 1, (Object)connectPiggybackData, 500, 500);
            if (sockStream == null || sockStream.isClosed()) {
                return false;
            }
        }
        catch (ConnectorException e) {
            if (logger.isLoggable(JeusMessage_Session3._37112_LEVEL)) {
                logger.log(JeusMessage_Session3._37112_LEVEL, JeusMessage_Session3._37112, (Object)id.toString(), (Throwable)e);
            }
            this.close((SocketStream)sockStream);
            return false;
        }
        return this.ping(sockStream);
    }

    private boolean ping(SocketStream14 sockStream) {
        SCSimplePacket sndpkt = new SCSimplePacket();
        sndpkt.header.setOpcode(5);
        SCPacket rcvpkt = this.transceive((SCPacket)sndpkt, sockStream);
        if (rcvpkt == null) {
            return false;
        }
        int opcode = rcvpkt.header.getOpcode();
        return opcode == 65541;
    }

    private void close(SocketStream sockStream) {
        if (sockStream != null && !sockStream.isClosed()) {
            sockStream.destroy();
        }
    }

    private synchronized int getSeqno() {
        if (this.seqnoGenerator > 65535) {
            this.seqnoGenerator = 0;
        }
        return this.seqnoGenerator++;
    }
}

