/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import jeus.sessionmanager.session.Evictable;

public abstract class AbstractEvictableSession
implements Evictable,
Serializable {
    private long creationTime;
    private long lastAccessedTime;
    private long thisAccessedTime;
    private int maxInactiveInterval;

    public void initialize(long creationTime, long lastAccessedTime, long thisAccessedTime, int secondsInterval) {
        this.creationTime = creationTime;
        this.lastAccessedTime = lastAccessedTime;
        this.thisAccessedTime = thisAccessedTime;
        this.maxInactiveInterval = secondsInterval;
    }

    public void destroy() {
        this.creationTime = 0L;
        this.lastAccessedTime = 0L;
        this.thisAccessedTime = 0L;
        this.maxInactiveInterval = 0;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public long getThisAccessedTime() {
        return this.thisAccessedTime;
    }

    public void setThisAccessedTime(long thisAccessedTime) {
        this.thisAccessedTime = thisAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int secondsInterval) {
        this.maxInactiveInterval = secondsInterval;
    }

    public int readSessionTimes(DataInputStream dataInputStream) throws Exception {
        int count = 0;
        try {
            this.lastAccessedTime = dataInputStream.readLong();
            count += 8;
            this.thisAccessedTime = dataInputStream.readLong();
            count += 8;
            this.creationTime = dataInputStream.readLong();
            count += 8;
            this.maxInactiveInterval = dataInputStream.readInt();
        }
        catch (Exception e) {
            count = 0;
            throw e;
        }
        return count += 4;
    }

    public void writeSessionTimes(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeLong(this.lastAccessedTime);
        dataOutputStream.writeLong(this.thisAccessedTime);
        dataOutputStream.writeLong(this.creationTime);
        dataOutputStream.writeInt(this.maxInactiveInterval);
    }
}

