/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.SessionActivationListener;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.SessionListener;
import jeus.sessionmanager.session.AbstractEvictableSession;
import jeus.sessionmanager.session.Session;
import jeus.sessionmanager.util.SessionManagerUtil;
import jeus.util.logging.JeusLogger;

public abstract class AbstractSession
extends AbstractEvictableSession
implements Session,
Serializable {
    protected static final transient JeusLogger logger = Constants.SESSION_LOGGER;
    private final transient AtomicInteger accessCount;
    private final transient AtomicBoolean needUpdate;
    private final AtomicBoolean expired;
    private String internalId;
    private String externalId;
    private transient SessionListener postCreationListenerSupport;
    private transient SessionListener preDestructionListenerSupport;
    private transient SessionActivationListener postActivationListenerSupport;
    private transient SessionActivationListener prePassivationListenerSupport;
    private final transient AtomicBoolean isNew;
    private final transient ReentrantReadWriteLock rRWlock = new ReentrantReadWriteLock(true);
    protected final transient SessionConfig config;

    public AbstractSession() {
        this(Constants.DUMMY_SESSION_CONFIG);
    }

    public AbstractSession(SessionConfig config) {
        this.config = config;
        this.accessCount = new AtomicInteger(0);
        this.needUpdate = new AtomicBoolean(false);
        this.expired = new AtomicBoolean(false);
        this.isNew = new AtomicBoolean(false);
    }

    public void initialize(String id) {
        this.internalId = id;
        this.externalId = null;
        this.isNew.set(true);
    }

    public void setNewStatus(boolean isNew) {
        this.isNew.set(isNew);
    }

    public void destroy() {
        if (!this.expired.compareAndSet(false, true)) {
            return;
        }
        this.accessCount.set(0);
        this.needUpdate.set(false);
        this.isNew.set(false);
        this.postCreationListenerSupport = null;
        this.preDestructionListenerSupport = null;
        this.postActivationListenerSupport = null;
        this.prePassivationListenerSupport = null;
        super.destroy();
    }

    public void setMaxInactiveInterval(int secondsInterval) {
        super.setMaxInactiveInterval(secondsInterval);
        this.needUpdate.set(true);
    }

    public boolean validate() {
        long intervalInSec;
        int thisInterval;
        if (this.expired.get()) {
            return false;
        }
        if (this.getConcurrentAccessCount() > 0) {
            return true;
        }
        int maxInactiveInterval = this.getMaxInactiveInterval();
        return maxInactiveInterval <= 0 || (thisInterval = SessionManagerUtil.safeCasting(intervalInSec = (System.currentTimeMillis() - this.getThisAccessedTime()) / 1000L)) <= maxInactiveInterval;
    }

    public void access() {
        this.getReadLock().lock();
        this.setLastAccessedTime(this.getThisAccessedTime());
        this.setThisAccessedTime(System.currentTimeMillis());
        this.accessCount.incrementAndGet();
    }

    public void endAccess() {
        this.isNew.set(false);
        this.accessCount.decrementAndGet();
        this.getReadLock().unlock();
    }

    public Lock getReadLock() {
        return this.rRWlock.readLock();
    }

    public Lock getWriteLock() {
        return this.rRWlock.writeLock();
    }

    public int getConcurrentAccessCount() {
        return this.accessCount.get();
    }

    public String getId() {
        if (this.externalId == null) {
            this.externalId = this.config.getRouter().augment(this.internalId);
        }
        return this.externalId;
    }

    public void setId(String id) {
        this.internalId = id;
        this.externalId = this.config.getRouter().augment(this.internalId);
    }

    public String getInternalId() {
        return this.internalId;
    }

    public boolean isExpired() {
        return this.expired.get();
    }

    public boolean isNew() {
        return this.isNew.get();
    }

    public boolean isNeedUpdate() {
        return this.needUpdate.get();
    }

    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate.set(needUpdate);
    }

    public int readSession(byte[] inputBytes) throws Exception {
        this.isNew.set(false);
        return this.readSession(inputBytes, 0, inputBytes.length);
    }

    public SessionListener getPostCreationListenerSupport() {
        return this.postCreationListenerSupport;
    }

    public void setPostCreationListenerSupport(SessionListener listenerSupport) {
        this.postCreationListenerSupport = listenerSupport;
    }

    public SessionListener getPreDestructionListenerSupport() {
        return this.preDestructionListenerSupport;
    }

    public void setPreDestructionListenerSupport(SessionListener listenerSupport) {
        this.preDestructionListenerSupport = listenerSupport;
    }

    public SessionActivationListener getPostActivationListenerSupport() {
        return this.postActivationListenerSupport;
    }

    public void setPostActivationListenerSupport(SessionActivationListener listenerSupport) {
        this.postActivationListenerSupport = listenerSupport;
    }

    public SessionActivationListener getPrePassivationListenerSupport() {
        return this.prePassivationListenerSupport;
    }

    public void setPrePassivationListenerSupport(SessionActivationListener listenerSupport) {
        this.prePassivationListenerSupport = listenerSupport;
    }
}

