/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.central.CentralSessionManager;
import jeus.sessionmanager.session.AbstractObjectSession;
import jeus.sessionmanager.session.CentralSession;
import jeus.sessionmanager.util.DebuggingObjectOutputStream;
import jeus.sessionmanager.util.Deserializer;
import jeus.sessionmanager.util.SessionByteArrayInputStream;
import jeus.sessionmanager.util.SessionByteArrayOutputStream;
import jeus.util.message.JeusMessage_Session4;

public class CentralObjectSession
extends AbstractObjectSession
implements CentralSession {
    private transient byte[] storedBytes = null;
    private transient boolean uniqueCreation = false;
    private transient boolean checkModified = false;

    public CentralObjectSession(SessionConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readSession(byte[] inputBytes, int offset, int length) throws Exception {
        int end;
        int start;
        int count = 0;
        try {
            this.storedBytes = inputBytes;
            SessionByteArrayInputStream pbis = new SessionByteArrayInputStream(inputBytes, offset, length);
            DataInputStream dataInputStream = new DataInputStream(pbis);
            if ((count += this.readSessionTimes(dataInputStream)) >= length - offset) {
                return count;
            }
            Deserializer ois = null;
            try {
                ois = new Deserializer(pbis);
                start = pbis.getPos();
                this.object = ois.readObject();
                end = pbis.getPos();
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        catch (Exception e) {
            this.object = null;
            if (logger.isLoggable(JeusMessage_Session4._47653_LEVEL)) {
                logger.log(JeusMessage_Session4._47653_LEVEL, JeusMessage_Session4._47653, (Throwable)e);
            }
            throw e;
        }
        return count += end - start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSession(OutputStream outputStream) throws Exception {
        SessionByteArrayOutputStream sbaos;
        block20: {
            if (!(outputStream instanceof SessionByteArrayOutputStream)) {
                throw new Exception(outputStream + " is not supported in CentralObjectSession");
            }
            sbaos = (SessionByteArrayOutputStream)outputStream;
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(sbaos);
                this.writeSessionTimes(dataOutputStream);
                if (this.object == null) break block20;
                if (!(this.object instanceof Serializable)) {
                    throw new Exception(this.object + " is not serializable");
                }
                DebuggingObjectOutputStream oos = null;
                try {
                    oos = new DebuggingObjectOutputStream(sbaos);
                    Object object = this.object;
                    synchronized (object) {
                        oos.writeObject(this.object);
                    }
                    oos.flush();
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(JeusMessage_Session4._47651_LEVEL)) {
                        logger.log(JeusMessage_Session4._47651_LEVEL, JeusMessage_Session4._47651, oos.getStack(), (Throwable)ioe);
                    }
                    throw ioe;
                }
                finally {
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_Session4._47652_LEVEL)) {
                    logger.log(JeusMessage_Session4._47652_LEVEL, JeusMessage_Session4._47652, (Throwable)e);
                }
                throw e;
            }
        }
        this.checkModified(sbaos);
        this.storedBytes = sbaos.getByteArray();
        if (logger.isLoggable(JeusMessage_Session4._48000_LEVEL)) {
            logger.log(JeusMessage_Session4._48000_LEVEL, JeusMessage_Session4._48000, new Object[]{this, this.getId(), sbaos.getByteArray(), sbaos.getByteArray() == null ? "null" : String.valueOf(sbaos.getByteArray().length), new Integer(sbaos.getCount())});
        }
    }

    public boolean isUniqueCreation() {
        return this.uniqueCreation;
    }

    public void setUniqueCreation(boolean uniqueCreation) {
        this.uniqueCreation = uniqueCreation;
    }

    public boolean isCheckModified() {
        return this.checkModified;
    }

    public void setCheckModified(boolean checkModified) {
        this.checkModified = checkModified;
    }

    public void destroy() {
        this.storedBytes = null;
        this.uniqueCreation = false;
        super.destroy();
    }

    private void checkModified(SessionByteArrayOutputStream sbaos) {
        if (this.isNeedUpdate()) {
            return;
        }
        if (!this.checkModified) {
            return;
        }
        if (!CentralSessionManager.checkModified(sbaos, this.storedBytes)) {
            this.setNeedUpdate(true);
        }
    }
}

