/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.session.AbstractObjectSession;
import jeus.sessionmanager.session.ByteArraySession;
import jeus.sessionmanager.session.DistributableSession;
import jeus.sessionmanager.util.DebuggingObjectOutputStream;
import jeus.sessionmanager.util.Deserializer;
import jeus.sessionmanager.util.SessionByteArrayInputStream;
import jeus.sessionmanager.util.SessionByteArrayOutputStream;
import jeus.util.message.JeusMessage_Session4;

public class DistributableObjectSession
extends AbstractObjectSession
implements DistributableSession {
    private ByteArraySession byteSession = null;
    private boolean getAccess = false;

    public DistributableObjectSession(SessionConfig config) {
        super(config);
    }

    public Object getObject() {
        this.getAccess = true;
        return super.getObject();
    }

    public int readSession(byte[] inputBytes, int offset, int length) throws Exception {
        SessionByteArrayInputStream sbais;
        int count = 0;
        FilterInputStream dataInputStream = null;
        try {
            sbais = new SessionByteArrayInputStream(inputBytes, offset, length);
            dataInputStream = new DataInputStream(sbais);
            if ((count += this.readSessionTimes((DataInputStream)dataInputStream)) >= length - offset) {
                int n = count;
                return n;
            }
        }
        catch (Exception e) {
            this.object = null;
            if (logger.isLoggable(JeusMessage_Session4._47653_LEVEL)) {
                logger.log(JeusMessage_Session4._47653_LEVEL, JeusMessage_Session4._47653, (Throwable)e);
            }
            throw e;
        }
        finally {
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return count += this.internalReadContent(sbais);
    }

    public void writeSession(OutputStream outputStream) throws Exception {
        if (!(outputStream instanceof SessionByteArrayOutputStream)) {
            throw new Exception(outputStream + " is not supported in DistributableObjectSession");
        }
        SessionByteArrayOutputStream sbaos = (SessionByteArrayOutputStream)outputStream;
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(sbaos);
            this.writeSessionTimes(dataOutputStream);
            ByteArraySession byteSession = this.getByteSession();
            if (byteSession != null) {
                byte[] data = byteSession.getBytesData();
                if (data != null) {
                    dataOutputStream.write(data);
                }
            } else {
                this.internalWriteContent(sbaos);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Session4._47652_LEVEL)) {
                logger.log(JeusMessage_Session4._47652_LEVEL, JeusMessage_Session4._47652, (Throwable)e);
            }
            throw e;
        }
        finally {
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public ByteArraySession getByteSession() {
        return this.byteSession;
    }

    public void setByteSession(ByteArraySession byteSession) {
        this.byteSession = byteSession;
        if (byteSession != null) {
            this.initialize(byteSession.getInternalId());
            this.initialize(byteSession.getCreationTime(), byteSession.getLastAccessedTime(), byteSession.getThisAccessedTime(), byteSession.getMaxInactiveInterval());
        }
    }

    public boolean activateSession() throws Exception {
        if (this.byteSession != null) {
            byte[] bytesData = this.byteSession.getBytesData();
            if (bytesData != null) {
                try {
                    this.readContent(bytesData, 0, bytesData.length);
                }
                catch (Exception e) {
                    if (logger.isLoggable(JeusMessage_Session4._47655_LEVEL)) {
                        logger.log(JeusMessage_Session4._47655_LEVEL, JeusMessage_Session4._47655, (Throwable)e);
                    }
                    this.byteSession = null;
                    throw e;
                }
            }
            this.byteSession = null;
            return true;
        }
        return false;
    }

    public int readContent(byte[] inputBytes, int offset, int length) throws Exception {
        try {
            return this.internalReadContent(new SessionByteArrayInputStream(inputBytes, offset, length));
        }
        catch (Exception e) {
            this.object = null;
            if (logger.isLoggable(JeusMessage_Session4._47653_LEVEL)) {
                logger.log(JeusMessage_Session4._47653_LEVEL, JeusMessage_Session4._47653, (Throwable)e);
            }
            throw e;
        }
    }

    public void writeContent(OutputStream outputStream) throws Exception {
        try {
            this.internalWriteContent(outputStream);
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Session4._47652_LEVEL)) {
                logger.log(JeusMessage_Session4._47652_LEVEL, JeusMessage_Session4._47652, (Throwable)e);
            }
            throw e;
        }
    }

    public boolean getAccess() {
        return this.getAccess;
    }

    public void setGetAccess(boolean getAccess) {
        this.getAccess = getAccess;
    }

    public boolean checkPassivation(long currentTime, long passivationTo) {
        long thisInterval;
        if (this.isExpired()) {
            return false;
        }
        return passivationTo > 0L && (thisInterval = currentTime - this.getThisAccessedTime()) > passivationTo;
    }

    public void destroy() {
        this.byteSession = null;
        this.getAccess = false;
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int internalReadContent(SessionByteArrayInputStream sbais) throws Exception {
        int end;
        int start;
        int count = 0;
        Deserializer ois = null;
        try {
            ois = new Deserializer(sbais);
            start = sbais.getPos();
            this.object = ois.readObject();
            end = sbais.getPos();
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
        return count += end - start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalWriteContent(OutputStream outputStream) throws Exception {
        if (this.object == null) {
            return;
        }
        if (!(this.object instanceof Serializable)) {
            throw new Exception(this.object + " is not serializable");
        }
        DebuggingObjectOutputStream oos = null;
        try {
            oos = new DebuggingObjectOutputStream(outputStream);
            Object object = this.object;
            synchronized (object) {
                oos.writeObject(this.object);
            }
            oos.flush();
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Session4._47651_LEVEL)) {
                logger.log(JeusMessage_Session4._47651_LEVEL, JeusMessage_Session4._47651, oos.getStack(), (Throwable)ioe);
            }
            throw ioe;
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

