/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.util.DebuggingObjectOutputStream;
import jeus.sessionmanager.util.Deserializer;
import jeus.sessionmanager.util.SerializationException;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session4;

public class SerializedObjectTable {
    private static final JeusLogger logger = Constants.SESSION_LOGGER;
    private Map serValues = new Hashtable();
    private boolean enable;

    public static SerializedObjectTable getSerializedObjectTable(boolean enable) {
        return new SerializedObjectTable(enable);
    }

    private SerializedObjectTable(boolean enable) {
        this.enable = enable;
    }

    public List serialize(Map values) {
        if (!this.enable) {
            return new CopyOnWriteArrayList(values.keySet());
        }
        if (values == null || values.size() <= 0) {
            return Constants.EMPTY_COPY_ON_WRITE_ARRAY_LIST;
        }
        CopyOnWriteArrayList<String> notSerializedNames = new CopyOnWriteArrayList<String>();
        for (String name : values.keySet()) {
            Object obj = values.get(name);
            if (obj instanceof String) continue;
            try {
                byte[] ser = this.object2bytes(obj);
                if (ser == null) continue;
                this.serValues.put(name, ser);
            }
            catch (SerializationException e) {
                Object notser = values.remove(name);
                if (notser == null) continue;
                notSerializedNames.add(name);
                if (!logger.isLoggable(JeusMessage_Session4._48847_LEVEL)) continue;
                logger.log(JeusMessage_Session4._48847_LEVEL, JeusMessage_Session4._48847, (Object)notser.toString(), (Throwable)e);
            }
        }
        Iterator i = this.serValues.keySet().iterator();
        while (i.hasNext()) {
            values.remove((String)i.next());
        }
        return notSerializedNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] object2bytes(Object obj) throws SerializationException {
        if (!(obj instanceof Serializable)) {
            throw new SerializationException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session4._48848, (Object)obj));
        }
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new DebuggingObjectOutputStream(bos);
            Object object = obj;
            synchronized (object) {
                oos.writeObject(obj);
            }
            oos.flush();
            object = bos.toByteArray();
            return object;
        }
        catch (Exception e) {
            throw new SerializationException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session4._48849, (Object[])new Object[]{obj, ((DebuggingObjectOutputStream)oos).getStack()}), e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void deserialize(Map values) {
        for (String name : this.serValues.keySet()) {
            Object obj = this.deserialize(name);
            if (obj == null) continue;
            values.put(name, obj);
        }
    }

    public Object deserialize(String name) {
        block6: {
            if (name == null) {
                return null;
            }
            Object obj = this.serValues.remove(name);
            if (obj == null) {
                return null;
            }
            try {
                return this.bytes2object((byte[])obj);
            }
            catch (ClassNotFoundException cnfe) {
                if (logger.isLoggable(JeusMessage_Session4._48850_LEVEL)) {
                    logger.log(JeusMessage_Session4._48850_LEVEL, JeusMessage_Session4._48850, new Object[]{obj, name}, (Throwable)cnfe);
                }
            }
            catch (SerializationException e) {
                if (!logger.isLoggable(JeusMessage_Session4._48850_LEVEL)) break block6;
                logger.log(JeusMessage_Session4._48850_LEVEL, JeusMessage_Session4._48850, new Object[]{obj, name}, (Throwable)e);
            }
        }
        return null;
    }

    private Object bytes2object(byte[] buf) throws SerializationException, ClassNotFoundException {
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(buf);
            ois = new Deserializer(bis);
            Object object = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException cnfe) {
            throw cnfe;
        }
        catch (Exception e) {
            throw new SerializationException("failed to read a object", e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int serialize(ByteArrayOutputStream out, Map values) throws SerializationException {
        int count = 0;
        String name2 = null;
        DebuggingObjectOutputStream oos = null;
        try {
            Object obj;
            oos = new DebuggingObjectOutputStream(out);
            if (values != null) {
                for (String name2 : values.keySet()) {
                    obj = values.get(name2);
                    if (obj instanceof Serializable) {
                        ++count;
                        oos.writeObject(name2);
                        Object v = obj;
                        synchronized (v) {
                            oos.writeObject(obj);
                            continue;
                        }
                    }
                    if (!logger.isLoggable(JeusMessage_Session4._48788_LEVEL)) continue;
                    logger.log(JeusMessage_Session4._48788_LEVEL, JeusMessage_Session4._48788, (Object[])new String[]{name2, obj.toString()});
                }
            }
            for (String name2 : this.serValues.keySet()) {
                obj = (byte[])this.serValues.get(name2);
                oos.writeObject(name2);
                oos.writeObject(this.bytes2object((byte[])obj));
                ++count;
            }
            oos.flush();
        }
        catch (Exception e) {
            throw new SerializationException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session4._48814, (Object[])new Object[]{name2, oos.getStack()}), e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {}
        }
        return count;
    }

    public void deserialize(ByteArrayInputStream in, int count, Map values) throws SerializationException {
        String name = null;
        Deserializer ois = null;
        try {
            ois = new Deserializer(in);
            Object obj = null;
            for (int i = 0; i < count; ++i) {
                name = (String)ois.readObject();
                obj = ois.readObject();
                values.put(name, obj);
            }
        }
        catch (ClassNotFoundException cnfe) {
            if (logger.isLoggable(JeusMessage_Session4._48815_LEVEL)) {
                logger.log(JeusMessage_Session4._48815_LEVEL, JeusMessage_Session4._48815, name, (Throwable)cnfe);
            }
        }
        catch (Exception e2) {
            throw new SerializationException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session4._48815, name), e2);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Enumeration keys() {
        return ((Hashtable)this.serValues).keys();
    }
}

