/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.inspector.mbean;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import jeus.tool.builder.inspector.mbean.MBeanInspector;

public abstract class BaseMBeanInspector
implements MBeanInspector {
    private String j2eeType;
    private String jeusType;
    private String name;
    protected ObjectName objectName;
    protected MBeanServerConnection msc;

    public BaseMBeanInspector(MBeanServerConnection msc, ObjectName objectName) {
        this.objectName = objectName;
        this.msc = msc;
        this.jeusType = objectName.getKeyProperty("jeusType");
        this.j2eeType = objectName.getKeyProperty("j2eeType");
        this.name = objectName.getKeyProperty("name");
    }

    public String getJ2eeType() {
        return this.j2eeType;
    }

    public String getJeusType() {
        return this.jeusType;
    }

    public String getName() {
        return this.name;
    }

    public boolean exists() {
        try {
            Set<ObjectName> result = this.msc.queryNames(this.objectName, null);
            return result.size() > 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public MBeanInspector[] getChildren() throws IOException, MalformedObjectNameException {
        if (this.msc == null) {
            return new MBeanInspector[0];
        }
        ObjectName[] queries = this.getChildQueries();
        ArrayList<MBeanInspector> result = new ArrayList<MBeanInspector>();
        for (int i = 0; i < queries.length; ++i) {
            Set<ObjectName> children = this.msc.queryNames(queries[i], null);
            Iterator<ObjectName> iter = children.iterator();
            while (iter.hasNext()) {
                MBeanInspector mi = this.createChildMBeanInspector(iter.next(), this.msc);
                result.add(mi);
            }
        }
        return result.toArray(new MBeanInspector[result.size()]);
    }

    protected String createQueryString(String myprops, boolean module) {
        Hashtable<String, String> props = new Hashtable<String, String>(this.objectName.getKeyPropertyList());
        props.remove("j2eeType");
        props.remove("jeusType");
        props.remove("name");
        props.remove("isTargetable");
        props.remove("JMXManager");
        if (module && !this.getJ2eeType().equals("J2EEApplication")) {
            props.put("J2EEApplication", "null");
        }
        if (this.getJeusType() != null) {
            props.put(this.getJeusType(), this.getName());
        } else {
            props.put(this.getJ2eeType(), this.getName());
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.objectName.getDomain() + ":");
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = props.get(key);
            buf.append(key + "=" + value + ",");
        }
        buf.append(myprops + ",*");
        return buf.toString();
    }

    protected String createQueryString(String myprops) {
        return this.createQueryString(myprops, false);
    }

    public String toString() {
        return this.getJ2eeType() + (this.getJeusType() != null ? ":" + this.getJeusType() : "") + ":" + this.getName();
    }

    public boolean equals(Object o) {
        if (o instanceof BaseMBeanInspector) {
            return ((BaseMBeanInspector)o).getObjectName().equals(this.objectName);
        }
        return false;
    }

    protected abstract ObjectName[] getChildQueries() throws MalformedObjectNameException;

    protected abstract MBeanInspector createChildMBeanInspector(ObjectName var1, MBeanServerConnection var2);
}

