/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.inspector.mbean;

import java.util.HashMap;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.tool.builder.inspector.mbean.BaseMBeanInspector;
import jeus.tool.builder.inspector.mbean.ModuleStateType;

public abstract class ModuleMBeanInspector
extends BaseMBeanInspector {
    private static HashMap moduleTypeMap = new HashMap();
    private ModuleType moduleType = (ModuleType)moduleTypeMap.get(this.getJ2eeType());
    private ModuleStateType state;

    public ModuleMBeanInspector(MBeanServerConnection msc, ObjectName objectName) {
        super(msc, objectName);
        this.updateState();
    }

    public void updateState() {
        try {
            Integer value = (Integer)this.msc.getAttribute(this.objectName, "state");
            this.state = new ModuleStateType(value);
        }
        catch (Exception e) {
            this.state = ModuleStateType.FAILED;
        }
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    public ModuleStateType getState() {
        return this.state;
    }

    public void setState(ModuleStateType state) {
        this.state = state;
    }

    public String toString() {
        return super.toString() + "[state=" + this.state.getState() + "]";
    }

    static {
        moduleTypeMap.put("J2EEApplication", ModuleType.EAR);
        moduleTypeMap.put("EJBModule", ModuleType.EJB);
        moduleTypeMap.put("WebModule", ModuleType.WAR);
        moduleTypeMap.put("ResourceAdapterModule", ModuleType.RAR);
        moduleTypeMap.put("AppClientModule", ModuleType.CAR);
    }
}

