/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.inspector.module;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.JarArchiveFactory;

public class EARInspector {
    AbstractArchive archive;
    Vector vEJB = new Vector();
    Vector vConnector = new Vector();
    Vector vWeb = new Vector();
    Vector vWebConextRoot = new Vector();
    Vector vJava = new Vector();

    public Vector getEJB() {
        return this.vEJB;
    }

    public Vector getConnector() {
        return this.vConnector;
    }

    public Vector getWeb() {
        return this.vWeb;
    }

    public Vector getWebConextRoot() {
        return this.vWebConextRoot;
    }

    public Vector getJava() {
        return this.vJava;
    }

    public EARInspector(AbstractArchive archive) {
        this.archive = archive;
        this.vEJB.add("");
        this.vConnector.add("");
        this.vWeb.add("");
        this.vWebConextRoot.add("");
        this.vJava.add("");
        this.doInspector();
    }

    private void doInspector() {
        Enumeration enum1 = this.archive.entries();
        ArrayList<String> list = new ArrayList<String>();
        while (enum1.hasMoreElements()) {
            String entry = (String)enum1.nextElement();
            if (entry.indexOf("APP-INF") >= 0 || entry.indexOf("META-INF") >= 0 || !entry.endsWith(".jar") && !entry.endsWith(".car") && !entry.endsWith(".rar") && !entry.endsWith(".war")) continue;
            list.add(entry);
        }
        try {
            for (int k = 0; k < list.size(); ++k) {
                String uri = (String)list.get(k);
                String path = this.archive.getArchiveUri() + File.separator + (String)list.get(k);
                AbstractArchive targetArchive = JarArchiveFactory.openArchiveStatic((String)path);
                ModuleType moduleType = JeusDeploymentManager.getModuleType(targetArchive);
                if (moduleType == null) continue;
                if (moduleType.equals(ModuleType.EJB)) {
                    this.vEJB.add(uri);
                    continue;
                }
                if (moduleType.equals(ModuleType.CAR)) {
                    this.vJava.add(uri);
                    continue;
                }
                if (moduleType.equals(ModuleType.RAR)) {
                    this.vConnector.add(uri);
                    continue;
                }
                if (!moduleType.equals(ModuleType.WAR)) continue;
                String contextRoot = null;
                int startIndex = uri.lastIndexOf(File.separatorChar);
                int endIndex = uri.lastIndexOf(46);
                contextRoot = startIndex > 0 ? uri.substring(startIndex + 1, endIndex) : uri.substring(0, endIndex);
                this.vWeb.add(uri);
                this.vWebConextRoot.add(contextRoot);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

