/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.inspector.module;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.tool.builder.Constants;

public class EJBInspector {
    public static final String BEAN_TYPE_SESSION = "javax.ejb.SessionBean";
    public static final String BEAN_TYPE_ENTITY = "javax.ejb.EntityBean";
    public static final String BEAN_TYPE_MESSAGE_DRIVEN = "javax.ejb.MessageDrivenBean";
    protected static final String SUPER_TYPE_REMOTE = "javax.ejb.EJBObject";
    protected static final String SUPER_TYPE_HOME = "javax.ejb.EJBHome";
    protected static final String SUPER_TYPE_LOCAL = "javax.ejb.EJBLocalObject";
    protected static final String SUPER_TYPE_LOCAL_HOME = "javax.ejb.EJBLocalHome";
    Vector vEjbClass = new Vector();
    Vector vHome = new Vector();
    Vector vRemote = new Vector();
    Vector vLocalHome = new Vector();
    Vector vLocal = new Vector();
    AbstractArchive archive = null;
    private String beanType;

    public EJBInspector(String beanType) {
        this(beanType, Constants.JEUS_ASSEMBLY_DIR);
    }

    public EJBInspector(String beanType, String classpath) {
        this.beanType = beanType;
        try {
            this.archive = FileArchiveFactory.openArchiveStatic((String)classpath);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.vEjbClass.add("");
        this.vHome.add("");
        this.vRemote.add("");
        this.vLocalHome.add("");
        this.vLocal.add("");
        this.doInspect();
    }

    public Vector getEjbClass() {
        return this.vEjbClass;
    }

    public Vector getHome() {
        return this.vHome;
    }

    public Vector getRemote() {
        return this.vRemote;
    }

    public Vector getLocalHome() {
        return this.vLocalHome;
    }

    public Vector getLocal() {
        return this.vLocal;
    }

    private void doInspect() {
        Enumeration entries = this.archive.entries();
        block2: while (entries.hasMoreElements()) {
            String className = (String)entries.nextElement();
            if (!className.endsWith(".class")) continue;
            className = className.replaceAll("/", ".");
            URL[] urlArray = new URL[]{this.archive.getArchiveUrl()};
            URLClassLoader ucl = new URLClassLoader(urlArray);
            Class<?> targetClass = null;
            try {
                targetClass = ucl.loadClass(className.substring(0, className.length() - 6));
                Class<?>[] classes = targetClass.getInterfaces();
                for (int k = 0; k < classes.length; ++k) {
                    if (classes[k].getName().equals(this.beanType)) {
                        this.vEjbClass.add(targetClass.getName());
                        continue block2;
                    }
                    if (classes[k].getName().equals(SUPER_TYPE_REMOTE)) {
                        this.vRemote.add(targetClass.getName());
                        continue block2;
                    }
                    if (classes[k].getName().equals(SUPER_TYPE_HOME)) {
                        this.vHome.add(targetClass.getName());
                        continue block2;
                    }
                    if (classes[k].getName().equals(SUPER_TYPE_LOCAL)) {
                        this.vLocal.add(targetClass.getName());
                        continue block2;
                    }
                    if (!classes[k].getName().equals(SUPER_TYPE_LOCAL_HOME)) continue;
                    this.vLocalHome.add(targetClass.getName());
                    continue block2;
                }
            }
            catch (Throwable e) {
            }
        }
    }
}

