/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.inspector.xml;

import javax.enterprise.deploy.shared.ModuleType;
import jeus.deploy.config.DConfigBeanRootSpecification;
import jeus.tool.builder.AdjustmentException;
import jeus.tool.builder.JEUSBuilder;
import jeus.tool.builder.deploy.IDeployUnit;
import jeus.tool.builder.inspector.xml.BaseXMLInspector;
import jeus.tool.builder.ui.MessagePanel;
import jeus.tool.builder.util.RuntimeDDAdjuster;
import org.w3c.dom.Element;

public abstract class ModuleXMLInspector
extends BaseXMLInspector {
    protected IDeployUnit deployUnit;
    protected String name;
    protected DConfigBeanRootSpecification dconfigspec;
    protected RuntimeDDAdjuster ddAdjuster;
    protected Element jeusElement;
    protected Element j2eeElement;

    public ModuleXMLInspector(IDeployUnit deployUnit, ModuleType moduleType, String filename) {
        this.deployUnit = deployUnit;
        this.name = deployUnit.getModuleName();
        try {
            this.dconfigspec = JEUSBuilder.dconfsource.getDConfigBeanRootSpecification(moduleType, filename);
            this.ddAdjuster = new RuntimeDDAdjuster(this.dconfigspec);
            this.j2eeElement = deployUnit.getStandardXMLTree();
            this.jeusElement = deployUnit.getJeusXMLTree();
        }
        catch (Exception e) {
            MessagePanel.showMessage("[ERROR]" + e.getMessage());
            e.printStackTrace();
        }
    }

    public IDeployUnit getDeployUnit() {
        return this.deployUnit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected ModuleType getModuleType() {
        return this.deployUnit.getModuleType();
    }

    public DConfigBeanRootSpecification getDConfigBeanRootSpecification() {
        return this.dconfigspec;
    }

    public void adjust() throws AdjustmentException {
        if (this.j2eeElement == null || this.jeusElement == null) {
            return;
        }
        this.ddAdjuster.adjust(this.j2eeElement, this.jeusElement);
    }

    public Element getJ2eeElement() {
        return this.j2eeElement;
    }

    public Element getJeusElement() {
        return this.jeusElement;
    }
}

