/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.inspector.xml;

import java.util.ArrayList;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.transform.TransformerException;
import jeus.tool.builder.deploy.IDeployUnit;
import jeus.tool.builder.inspector.xml.ModuleXMLInspector;
import jeus.tool.builder.inspector.xml.ServletXMLInsp;
import jeus.tool.builder.inspector.xml.XMLInspector;
import jeus.tool.xmlui.util.XMLUtil;
import jeus.xml.util.IXPathAPI;
import jeus.xml.util.XPathAPIFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebModuleXMLInsp
extends ModuleXMLInspector {
    public static final String SERVLET = "servlet";
    public static final String SERVLET_NAME = "servlet-name";

    public WebModuleXMLInsp(IDeployUnit deployUnit) {
        super(deployUnit, ModuleType.WAR, "WEB-INF/web.xml");
    }

    public String getJ2eeConfigPath() {
        return "/web-app";
    }

    public String getJ2eeConfigUIName() {
        return "web-app";
    }

    public String getJeusConfigPath() {
        return "/jeus-web-dd";
    }

    public String getJeusConfigUIName() {
        return "jeus-web-dd";
    }

    public XMLInspector[] getChildren() {
        if (!this.dirty && this.children != null) {
            return this.children;
        }
        if (this.j2eeElement == null) {
            return new XMLInspector[0];
        }
        ArrayList<ServletXMLInsp> result = new ArrayList<ServletXMLInsp>();
        String prefix = this.j2eeElement.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        String xpath = "./" + prefix + ":servlet";
        IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
        try {
            NodeList nodeList = xpathAPI.selectNodeList(this.j2eeElement, xpath);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element servlet = (Element)nodeList.item(i);
                String servletName = XMLUtil.getFirstElementValue(servlet, SERVLET_NAME);
                result.add(new ServletXMLInsp(this, "Servlet", servletName, new String[][]{{"web-app", "/web-app/servlet"}, {null, null}}));
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        this.children = result.toArray(new XMLInspector[result.size()]);
        this.dirty = false;
        return this.children;
    }

    public String getType() {
        return "WebModule";
    }

    public String getUniqueId() {
        return "<WebModule[name='" + this.getName() + "']>";
    }
}

