/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.module;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.deploy.shared.ModuleType;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.io.AppClientDeploymentDescriptorFile;
import jeus.deploy.io.ApplicationDeploymentDescriptorFile;
import jeus.deploy.io.ConnectorDeploymentDescriptorFile;
import jeus.deploy.io.EjbDeploymentDescriptorFile;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.deploy.io.WebservicesDeploymentDescriptorFile;
import jeus.deploy.io.runtime.AppClientRuntimeDDFile;
import jeus.deploy.io.runtime.ApplicationRuntimeDDFile;
import jeus.deploy.io.runtime.ConnectorRuntimeDDFile;
import jeus.deploy.io.runtime.EjbRuntimeDDFile;
import jeus.deploy.io.runtime.WebRuntimeDDFile;
import jeus.deploy.io.runtime.WebservicesRuntimeDDFile;
import jeus.service.descriptor.DescriptorFile;
import jeus.tool.builder.Constants;
import jeus.tool.builder.WIOParameters;
import jeus.tool.builder.deploy.IDeployUnit;
import jeus.tool.builder.module.EmptyDescriptor;
import jeus.tool.builder.module.ModuleUtil;
import jeus.tool.builder.ui.MessagePanel;
import jeus.tool.ddinit.EJBDDInit;
import jeus.tool.ddinit.WEBDDInit;
import jeus.util.JarExtractor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractModuleDescriptor
implements IDeployUnit {
    protected String plainXml = "jeus-application-dd.xml";
    private ModuleType moduleType;
    private String sourceUri;
    private String moduleName;
    String FS = Constants.FS;
    private String WORKING_DIR = WIOParameters.WORKING_DIR;
    protected DescriptorFile standardDescriptor;
    protected DescriptorFile jeusDescriptor;
    protected DescriptorFile standardWebserviceDescriptor;
    protected DescriptorFile jeusWebserviceDescriptor;
    private final int ARCHIVE_TYPE_FILE = 1;
    private final int ARCHIVE_TYPE_JAR = 2;
    private int archiveType = -1;
    private boolean isEmbedded = false;

    public AbstractModuleDescriptor(AbstractArchive archive) {
        this(archive, false);
    }

    public AbstractModuleDescriptor(AbstractArchive archive, boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
        this.sourceUri = archive.getArchiveUri();
        if (archive instanceof FileArchive) {
            this.archiveType = 1;
        } else if (archive instanceof InputJarArchive) {
            this.archiveType = 2;
        } else {
            throw new RuntimeException("unsupported archive type:" + archive.getArchiveUri());
        }
        try {
            this.moduleType = JeusDeploymentManager.getModuleType(archive);
            this.moduleName = ModuleUtil.getModuleName(archive);
            this.getJ2eeAndJeusDescriptor(archive);
            if (archive != null) {
                archive.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getJ2eeAndJeusDescriptor(AbstractArchive archive) {
        this.getJ2eeDescriptor(archive);
        this.getJeusDescriptor(archive);
    }

    private void getJ2eeDescriptor(AbstractArchive archive) {
        if (this.moduleType == ModuleType.EAR) {
            this.standardDescriptor = new ApplicationDeploymentDescriptorFile();
        } else if (this.moduleType == ModuleType.EJB) {
            this.standardDescriptor = new EjbDeploymentDescriptorFile();
            this.standardWebserviceDescriptor = new WebservicesDeploymentDescriptorFile(archive.getArchiveUri());
        } else if (this.moduleType == ModuleType.WAR) {
            this.standardDescriptor = new WebDeploymentDescriptorFile();
            this.standardWebserviceDescriptor = new WebservicesDeploymentDescriptorFile(archive.getArchiveUri());
        } else if (this.moduleType == ModuleType.CAR) {
            this.standardDescriptor = new AppClientDeploymentDescriptorFile();
        } else if (this.moduleType == ModuleType.RAR) {
            this.standardDescriptor = new ConnectorDeploymentDescriptorFile();
        }
    }

    private void getJeusDescriptor(AbstractArchive archive) {
        if (this.moduleType == ModuleType.EAR) {
            this.jeusDescriptor = new ApplicationRuntimeDDFile();
        } else if (this.moduleType == ModuleType.EJB) {
            this.jeusDescriptor = new EjbRuntimeDDFile();
            this.jeusWebserviceDescriptor = new WebservicesRuntimeDDFile(archive.getArchiveUri());
        } else if (this.moduleType == ModuleType.WAR) {
            this.jeusDescriptor = new WebRuntimeDDFile(archive.getArchiveUri());
            this.jeusWebserviceDescriptor = new WebservicesRuntimeDDFile(archive.getArchiveUri());
        } else if (this.moduleType == ModuleType.CAR) {
            this.jeusDescriptor = new AppClientRuntimeDDFile();
        } else if (this.moduleType == ModuleType.RAR) {
            this.jeusDescriptor = new ConnectorRuntimeDDFile();
        }
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public abstract Element getStandardXMLTree() throws Exception;

    public Object getStandardDescriptorFile() {
        return this.standardDescriptor;
    }

    public Object getJeusDescriptorFile() {
        return this.jeusDescriptor;
    }

    public Object getStandardWebserviceDescriptorFile() {
        return this.standardWebserviceDescriptor;
    }

    public Object getJeusWebserviceDescriptorFile() {
        return this.jeusWebserviceDescriptor;
    }

    public abstract Element getJeusXMLTree() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element getXmlElement(String xmlPath) {
        InputStream is = null;
        AbstractArchive archive = null;
        try {
            archive = this.getSourceArchive();
            is = archive.getEntry(xmlPath);
            if (is == null) {
                this.createDDWhenNoExist(archive, xmlPath);
                if (archive != null) {
                    archive.close();
                    archive = null;
                }
                archive = this.getSourceArchive();
                is = archive.getEntry(xmlPath);
                MessagePanel.showMessage(archive.getArchiveUri() + Constants.FS + xmlPath + " does not exist and created...");
            }
            if (xmlPath.indexOf("jeus") < 0) {
                is = this.standardDescriptor.getSchemaBasedStream(is);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = null;
            try {
                document = builder.parse(is);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                int answer = JOptionPane.showConfirmDialog(null, "Validation Error:" + this.moduleName + "\\" + xmlPath + "\nDo you want to overwrite DD file?", "Confirm", 0);
                if (answer == 0) {
                    File ddfile;
                    if (is != null) {
                        is.close();
                    }
                    if ((ddfile = new File(archive.getArchiveUri() + this.FS + xmlPath)).exists()) {
                        ddfile.delete();
                    }
                    this.createDDWhenNoExist(archive, xmlPath);
                    if (archive != null) {
                        archive.close();
                        archive = null;
                    }
                    archive = this.getSourceArchive();
                    is = archive.getEntry(xmlPath);
                    document = builder.parse(is);
                }
                Element element = null;
                try {
                    if (is != null) {
                        is.close();
                        is = null;
                    }
                    if (archive != null) {
                        archive.close();
                        archive = null;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return element;
            }
            Element element = document.getDocumentElement();
            return element;
        }
        catch (Exception ex) {
            MessagePanel.showMessage(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (archive != null) {
                    archive.close();
                    archive = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object getPlanDescriptorFile() {
        return null;
    }

    protected boolean isEmbedded() {
        return this.isEmbedded;
    }

    protected void setEmbeddedEnabl(boolean b) {
        this.isEmbedded = b;
    }

    private void createDDWhenNoExist(AbstractArchive archive, String xmlPath) throws Exception {
        if (this.archiveType == 2 && this.isEmbedded) {
            int index = Constants.JEUS_ASSEMBLY_EAR_DIR.length();
            String archiveName = archive.getArchiveUri().substring(index + 1);
            AbstractArchive assemblyArchive = FileArchiveFactory.openArchiveStatic((String)(Constants.JEUS_ASSEMBLY_DIR + this.FS + archiveName));
            this.createDDFile(assemblyArchive, xmlPath);
            new JarExtractor().makeJar2(assemblyArchive.getArchiveUri(), archive.getArchiveUri());
            if (assemblyArchive != null) {
                assemblyArchive.close();
            }
        } else {
            this.createDDFile(archive, xmlPath);
        }
    }

    private void createDDFile(AbstractArchive archive, String xmlPath) {
        if (this.moduleType.equals(ModuleType.EJB)) {
            if (this.isEmbedded) {
                EJBDDInit.main(new String[]{"-filearchive", archive.getArchiveUri()});
            } else {
                EJBDDInit.main(new String[]{archive.getArchiveUri()});
            }
        } else if (this.moduleType.equals(ModuleType.WAR)) {
            if (this.isEmbedded) {
                WEBDDInit.main(new String[]{"-webcontext", this.moduleName, "-filearchive", archive.getArchiveUri()});
            } else {
                WEBDDInit.main(new String[]{"-webcontext", this.moduleName, archive.getArchiveUri()});
            }
        } else if (xmlPath.indexOf("jeus") > 0) {
            EmptyDescriptor.makeJeusDescriptor(archive, this.moduleType);
            this.getJeusDescriptor(archive);
        } else {
            EmptyDescriptor.makeJ2eeDescriptor(archive, this.moduleType);
            this.getJ2eeDescriptor(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getPlanXMLTree() {
        String path = null;
        Element element = null;
        path = this.moduleType.equals(ModuleType.WAR) ? "WEB-INF" + Constants.FS + this.plainXml : "META-INF" + Constants.FS + this.plainXml;
        InputStream is = null;
        AbstractArchive archive = null;
        try {
            archive = this.getSourceArchive();
            is = archive.getEntry(path);
            if (is == null) {
                Element element2 = null;
                return element2;
            }
            element = this.getXmlElement(path);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (archive != null) {
                    archive.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return element;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String s) {
        this.moduleName = s;
    }

    public AbstractArchive getModuleArchive() throws IOException {
        String prefix = this.sourceUri.substring(this.sourceUri.lastIndexOf(this.FS) + 1);
        String suffix = ".tmp";
        File tempDir = new File(this.WORKING_DIR);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        File workingFile = File.createTempFile(prefix, suffix, tempDir);
        workingFile.delete();
        workingFile.mkdirs();
        return new FileArchive(workingFile.getPath());
    }

    public IDeployUnit getEmbeddedModuleDescriptor(String path) throws IOException {
        return null;
    }

    public AbstractArchive getSourceArchive() throws IOException {
        if (this.sourceUri != null) {
            if (this.archiveType == 1) {
                return FileArchiveFactory.openArchiveStatic((String)this.sourceUri);
            }
            if (this.archiveType == 2) {
                return JarArchiveFactory.openArchiveStatic((String)this.sourceUri);
            }
        }
        return null;
    }
}

