/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.tree;

import java.awt.Color;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jeus.tool.builder.inspector.mbean.MBeanInspector;
import jeus.tool.builder.inspector.mbean.ModuleMBeanInspector;
import jeus.tool.builder.resource.ImgRscManager;
import jeus.tool.builder.tree.JEUSTreeNode;

public class JEUSTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static Hashtable iconMap = new Hashtable();
    private static final String RUNNING = "_running";
    private static final String STOPPED = "_stopped";
    private static final String FAILED = "_failed";
    private static String[][] iconPairs = new String[][]{{"JeusManager", "/jeus/tool/resource/image/mbean/node_running.gif"}, {"J2EEServer", "/jeus/tool/resource/image/mbean/container_running.gif"}, {"J2EEApplication_running", "/jeus/tool/resource/image/mbean/ear_running.gif"}, {"EJBModule_running", "/jeus/tool/resource/image/mbean/ejb_module_running.gif"}, {"WebModule_running", "/jeus/tool/resource/image/mbean/web_module_running.gif"}, {"ResourceAdapterModule_running", "/jeus/tool/resource/image/mbean/ra_module_running.gif"}, {"AppClientModule_running", "/jeus/tool/resource/image/mbean/ca_module_running.gif"}, {"StatelessSessionBean_running", "/jeus/tool/resource/image/mbean/ejb_stateless_running.gif"}, {"StatefulSessionBean_running", "/jeus/tool/resource/image/mbean/ejb_stateful_running.gif"}, {"EntityBean_running", "/jeus/tool/resource/image/mbean/ejb_entity_running.gif"}, {"MessageDrivenBean_running", "/jeus/tool/resource/image/mbean/ejb_message_running.gif"}, {"Servlet_running", "/jeus/tool/resource/image/mbean/servlet_running.gif"}, {"J2EEApplication_stopped", "/jeus/tool/resource/image/mbean/ear_stopped.gif"}, {"EJBModule_stopped", "/jeus/tool/resource/image/mbean/ejb_module_stopped.gif"}, {"WebModule_stopped", "/jeus/tool/resource/image/mbean/web_module_stopped.gif"}, {"ResourceAdapterModule_stopped", "/jeus/tool/resource/image/mbean/ra_module_stopped.gif"}, {"AppClientModule_stopped", "/jeus/tool/resource/image/mbean/ca_module_stopped.gif"}, {"StatelessSessionBean_stopped", "/jeus/tool/resource/image/mbean/ejb_stateless_stopped.gif"}, {"StatefulSessionBean_stopped", "/jeus/tool/resource/image/mbean/ejb_stateful_stopped.gif"}, {"EntityBean_stopped", "/jeus/tool/resource/image/mbean/ejb_entity_stopped.gif"}, {"MessageDrivenBean_stopped", "/jeus/tool/resource/image/mbean/ejb_message_stopped.gif"}, {"Servlet_stopped", "/jeus/tool/resource/image/mbean/servlet_stopped.gif"}, {"J2EEApplication_failed", "/jeus/tool/resource/image/mbean/ear_failed.gif"}, {"EJBModule_failed", "/jeus/tool/resource/image/mbean/ejb_module_failed.gif"}, {"WebModule_failed", "/jeus/tool/resource/image/mbean/web_module_failed.gif"}, {"ResourceAdapterModule_failed", "/jeus/tool/resource/image/mbean/ra_module_failed.gif"}, {"AppClientModule_failed", "/jeus/tool/resource/image/mbean/ca_module_failed.gif"}, {"StatelessSessionBean_failed", "/jeus/tool/resource/image/mbean/ejb_stateless_failed.gif"}, {"StatefulSessionBean_failed", "/jeus/tool/resource/image/mbean/ejb_stateful_failed.gif"}, {"EntityBean_failed", "/jeus/tool/resource/image/mbean/ejb_entity_failed.gif"}, {"MessageDrivenBean_failed", "/jeus/tool/resource/image/mbean/ejb_message_failed.gif"}, {"Servlet_failed", "/jeus/tool/resource/image/mbean/servlet_failed.gif"}};

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof JEUSTreeNode) {
            Icon icon;
            ModuleMBeanInspector minsp;
            JEUSTreeNode node = (JEUSTreeNode)value;
            MBeanInspector insp = node.getMBeanInspector();
            String iconKey = insp.getJ2eeType();
            if (insp.getJeusType() != null) {
                iconKey = insp.getJeusType();
            }
            if ((minsp = this.findModuleMBeanInspector(node)) != null) {
                switch (minsp.getState().getState()) {
                    case 1: {
                        iconKey = iconKey + RUNNING;
                        break;
                    }
                    case 3: {
                        iconKey = iconKey + STOPPED;
                        break;
                    }
                    default: {
                        iconKey = iconKey + FAILED;
                    }
                }
            }
            if ((icon = (Icon)iconMap.get(iconKey)) != null) {
                label.setIcon(icon);
            }
            label.setText(insp.getName());
        }
        return label;
    }

    private ModuleMBeanInspector findModuleMBeanInspector(JEUSTreeNode node) {
        if (node.getMBeanInspector() instanceof ModuleMBeanInspector) {
            return (ModuleMBeanInspector)node.getMBeanInspector();
        }
        JEUSTreeNode parent = (JEUSTreeNode)node.getParent();
        if (parent == null) {
            return null;
        }
        return this.findModuleMBeanInspector(parent);
    }

    public Color getTextSelectionColor() {
        return Color.WHITE;
    }

    public Color getBorderSelectionColor() {
        return Color.decode("#597FBF").darker().darker();
    }

    public Color getBackgroundSelectionColor() {
        return Color.decode("#597FBF");
    }

    static {
        for (int i = 0; i < iconPairs.length; ++i) {
            try {
                Icon icon = ImgRscManager.getImageIcon(iconPairs[i][1]);
                iconMap.put(iconPairs[i][0], icon);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

