/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.SoftBevelBorder;
import jeus.tool.builder.util.DebugOutputStream;
import jeus.tool.builder.util.NullOutputStream;

public class MessagePanel
extends JPanel {
    private static final int BORDER_ROWS = 7;
    private static final int BORDER_COLUMNS = 50;
    public static JTextArea taMsgBoard;
    public JPanel statusPanel;
    public JLabel labelDisplay = new JLabel("Welcome to JEUS Builder");
    JPopupMenu popupMenu;
    private static boolean debug;
    private static boolean systemOut;
    private static PrintStream debugStream;
    private static PrintStream consoleErr;
    private static StringBuffer sb;

    public MessagePanel() {
        this.createUI();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        MessagePanel.debug = debug;
    }

    public static boolean isSystemOut() {
        return systemOut;
    }

    public static void setSystemOut(boolean systemOut) {
        MessagePanel.systemOut = systemOut;
        if (!systemOut) {
            System.setErr(debugStream);
        } else {
            System.setErr(consoleErr);
        }
    }

    public static boolean debug(String msg) {
        if (MessagePanel.isDebug()) {
            System.err.println("[DEBUG] " + msg);
        }
        return MessagePanel.isDebug();
    }

    public static PrintStream getDebugPrintStream() {
        return System.err;
    }

    public static OutputStream getDebugOutputStream() {
        if (MessagePanel.isDebug()) {
            return System.err;
        }
        return new NullOutputStream();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        taMsgBoard = new JTextArea(7, 50);
        taMsgBoard.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(taMsgBoard);
        taMsgBoard.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    MessagePanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        JMenuItem clearMenuItem = new JMenuItem("clear");
        clearMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagePanel.clearMessage();
            }
        });
        this.popupMenu.add(clearMenuItem);
        this.statusPanel = new JPanel();
        this.statusPanel.setBorder(new SoftBevelBorder(1));
        this.statusPanel.setLayout(new FlowLayout(0));
        this.statusPanel.add(this.labelDisplay);
        this.add((Component)jScrollPane, "Center");
    }

    public static void showMessage(String msg) {
        sb.append(msg + '\n');
        taMsgBoard.setText(sb.toString());
    }

    public static void clearMessage() {
        sb = new StringBuffer();
        taMsgBoard.setText("");
    }

    static {
        debug = false;
        systemOut = true;
        debugStream = new PrintStream(new DebugOutputStream(), true);
        consoleErr = System.err;
        sb = new StringBuffer();
    }
}

