/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.ui.custom;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jeus.tool.builder.inspector.module.EJBInspector;
import jeus.tool.xmlui.XMLUIConstants;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.tool.xmlui.engine.XMLUISession;
import jeus.tool.xmlui.util.MessageUtil;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Element;

public class SessionBeanGeneralPanel
extends XMLUIPanel {
    public JTextField tfEjbName = new JTextField();
    public JComboBox cbEjbClass = new JComboBox();
    public JComboBox cbHome = new JComboBox();
    public JComboBox cbRemote = new JComboBox();
    public JComboBox cbLocalHome = new JComboBox();
    public JComboBox cbLocal = new JComboBox();
    public JTextField tfSvcEndpoint = new JTextField();
    public JComboBox cbSessionType = new JComboBox<String>(new String[]{"", "Stateless", "Stateful"});
    public JComboBox cbTxType = new JComboBox<String>(new String[]{"", "Bean", "Container"});
    public JButton btnOptions = new JButton("Options..");
    private EJBInspector ejbInspector;

    public SessionBeanGeneralPanel(XMLUISession session, Object descriptor) {
        super(session, descriptor);
        this.init();
    }

    public SessionBeanGeneralPanel(XMLUIEngine engine, Object descriptor) {
        super(engine, descriptor);
        this.init();
    }

    public SessionBeanGeneralPanel(Object descriptor) {
        super(descriptor);
        this.init();
    }

    public void init() {
        int k;
        this.createGuiAndShow();
        this.cbEjbClass.setEditable(true);
        this.cbHome.setEditable(true);
        this.cbRemote.setEditable(true);
        this.cbLocalHome.setEditable(true);
        this.cbLocal.setEditable(true);
        this.ejbInspector = new EJBInspector("javax.ejb.SessionBean");
        Vector v = this.ejbInspector.getEjbClass();
        for (k = 0; k < v.size(); ++k) {
            this.cbEjbClass.addItem(v.elementAt(k));
        }
        v = this.ejbInspector.getHome();
        for (k = 0; k < v.size(); ++k) {
            this.cbHome.addItem(v.elementAt(k));
        }
        v = this.ejbInspector.getRemote();
        for (k = 0; k < v.size(); ++k) {
            this.cbRemote.addItem(v.elementAt(k));
        }
        v = this.ejbInspector.getLocalHome();
        for (k = 0; k < v.size(); ++k) {
            this.cbLocalHome.addItem(v.elementAt(k));
        }
        v = this.ejbInspector.getLocal();
        for (k = 0; k < v.size(); ++k) {
            this.cbLocal.addItem(v.elementAt(k));
        }
    }

    private void createGuiAndShow() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.anchor = 17;
        constraints.fill = 1;
        JLabel ejbNameLabel = new JLabel();
        ejbNameLabel.setForeground(XMLUIConstants.REQUIRED_COLOR);
        this.add((Component)ejbNameLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        this.add((Component)this.tfEjbName, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        JLabel ejbClassLabel = new JLabel(MessageUtil.getMessage(this.getEngine(), "message:ejb-class", "ejb-class*"));
        ejbClassLabel.setForeground(XMLUIConstants.REQUIRED_COLOR);
        this.add((Component)ejbClassLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        this.add((Component)this.cbEjbClass, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        this.add((Component)new JLabel(MessageUtil.getMessage(this.getEngine(), "message:home", "home")), constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.cbHome, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        this.add((Component)new JLabel("remote"), constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        this.add((Component)this.cbRemote, constraints);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weightx = 0.0;
        this.add((Component)new JLabel("local-home"), constraints);
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        this.add((Component)this.cbLocalHome, constraints);
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 0.0;
        this.add((Component)new JLabel("local"), constraints);
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        this.add((Component)this.cbLocal, constraints);
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.weightx = 0.0;
        this.add((Component)new JLabel("service-endpoint"), constraints);
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.weightx = 1.0;
        this.add((Component)this.tfSvcEndpoint, constraints);
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.weightx = 0.0;
        JLabel sessionTypeLabel = new JLabel("session-type*");
        sessionTypeLabel.setForeground(XMLUIConstants.REQUIRED_COLOR);
        this.add((Component)sessionTypeLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 7;
        constraints.weightx = 1.0;
        this.add((Component)this.cbSessionType, constraints);
        constraints.gridx = 0;
        constraints.gridy = 8;
        constraints.weightx = 0.0;
        JLabel txTypeLabel = new JLabel("transaction-type*");
        txTypeLabel.setForeground(XMLUIConstants.REQUIRED_COLOR);
        this.add((Component)txTypeLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 8;
        constraints.weightx = 1.0;
        this.add((Component)this.cbTxType, constraints);
        JPanel optionPanel = new JPanel(new FlowLayout(4));
        optionPanel.add(this.btnOptions);
        constraints.gridx = 1;
        constraints.gridy = 9;
        constraints.weightx = 1.0;
        this.add((Component)optionPanel, constraints);
        this.btnOptions.setMnemonic('O');
        this.btnOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SessionBeanGeneralPanel.this.showOptionsDlg();
            }
        });
    }

    private void showOptionsDlg() {
    }

    public void resetValue() {
    }

    public void setValue(Object val) {
        if (val == null) {
            return;
        }
        Element sessionBean = (Element)val;
        String ejbName = XMLUtil.getFirstElementValue(sessionBean, "ejb-name");
        String ejbClass = XMLUtil.getFirstElementValue(sessionBean, "ejb-class");
        String home = XMLUtil.getFirstElementValue(sessionBean, "home");
        String remote = XMLUtil.getFirstElementValue(sessionBean, "remote");
        String localHome = XMLUtil.getFirstElementValue(sessionBean, "local-home");
        String local = XMLUtil.getFirstElementValue(sessionBean, "local");
        String svcEndPoint = XMLUtil.getFirstElementValue(sessionBean, "service-endpoint");
        String sessionType = XMLUtil.getFirstElementValue(sessionBean, "session-type");
        String txType = XMLUtil.getFirstElementValue(sessionBean, "transaction-type");
        this.tfEjbName.setText(ejbName);
        this.cbEjbClass.setSelectedItem(ejbClass);
        this.cbHome.setSelectedItem(home);
        this.cbRemote.setSelectedItem(remote);
    }

    public Object getValue() {
        return XMLUtil.createElement(this.getSession().getDocument(), this.getName());
    }
}

