/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.OutputStream;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.tool.builder.Constants;
import jeus.tool.builder.ui.wizard.ModuleClasspathData;
import jeus.tool.builder.ui.wizard.ModuleClasspathTableModel;
import jeus.tool.builder.util.ArchiveUtil;
import jeus.tool.builder.util.TableSorter;

public class ModuleClassPathDlg
extends JDialog {
    JTable table = new JTable();
    ModuleClasspathTableModel tableModel = new ModuleClasspathTableModel();
    JButton btnOk = new JButton("Ok");
    JButton btnCancel = new JButton("Cancel");

    public ModuleClassPathDlg() {
        super((Frame)null, true);
        this.createGuiAndShow();
    }

    private void createGuiAndShow() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        TableSorter sorter = new TableSorter(this.tableModel);
        this.table.setAutoCreateColumnsFromModel(false);
        sorter.setTableHeader(this.table.getTableHeader());
        this.table.setModel(sorter);
        this.table.setSelectionMode(2);
        for (int k = 0; k < this.tableModel.getColumnCount(); ++k) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            DefaultCellEditor editor = new DefaultCellEditor(new JTextField());
            if (renderer instanceof JLabel) {
                ((JLabel)renderer).setHorizontalAlignment(ModuleClasspathTableModel.columns[k].alignment);
            }
            editor.setClickCountToStart(1);
            TableColumn column = new TableColumn(k, ModuleClasspathTableModel.columns[k].width, renderer, editor);
            this.table.addColumn(column);
        }
        this.table.getTableHeader().setToolTipText("click to sort");
        JScrollPane tableScrollPane = new JScrollPane();
        tableScrollPane.getViewport().add(this.table);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModuleClassPathDlg.this.doCancel();
            }
        };
        this.getRootPane().registerKeyboardAction(listener, KeyStroke.getKeyStroke(27, 0), 0);
        this.btnOk.setMnemonic('O');
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ModuleClassPathDlg.this.doOkey();
            }
        });
        this.btnCancel.setMnemonic('C');
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ModuleClassPathDlg.this.doCancel();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(4));
        btnPanel.setBorder(new EtchedBorder(0));
        btnPanel.add(this.btnOk);
        btnPanel.add(this.btnCancel);
        mainPanel.add((Component)tableScrollPane, "Center");
        mainPanel.add((Component)btnPanel, "South");
        this.setTitle("Module Classpath");
        this.setBounds(450, 350, 400, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOkey() {
        Vector vData = this.tableModel.getData();
        AbstractArchive archive = null;
        Manifest manifest = null;
        Attributes attribs = null;
        try {
            for (int k = 0; k < vData.size(); ++k) {
                ModuleClasspathData archiveClasspath = (ModuleClasspathData)vData.elementAt(k);
                String classpath = archiveClasspath.getClasspath();
                if (classpath == null || "".equals(classpath)) continue;
                archive = k == 0 ? ArchiveUtil.getAssemblyFileArchive() : FileArchiveFactory.openArchiveStatic((String)(Constants.JEUS_ASSEMBLY_DIR + Constants.FS + archiveClasspath.getArchive()));
                manifest = archive.getManifest();
                attribs = manifest.getMainAttributes();
                attribs.putValue(Attributes.Name.CLASS_PATH.toString(), archiveClasspath.getClasspath());
                OutputStream os = null;
                try {
                    os = archive.addEntry("META-INF/MANIFEST.MF");
                    manifest.write(os);
                    continue;
                }
                finally {
                    archive.closeEntry(os);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.dispose();
    }

    private void doCancel() {
        this.dispose();
    }

    public void insert(String archive, String classpath) {
        this.tableModel.insert(new ModuleClasspathData(archive, classpath));
    }
}

