/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.ui.wizard;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jeus.tool.builder.ui.wizard.ColumnData;
import jeus.tool.builder.ui.wizard.ModuleClasspathData;

class ModuleClasspathTableModel
extends AbstractTableModel {
    public static final ColumnData[] columns = new ColumnData[]{new ColumnData("Archive", 30, 2), new ColumnData("Classpath", 150, 2)};
    public static final int COL_ARCHIVE = 0;
    public static final int COL_CLASSPATH = 1;
    public Vector vector = new Vector();

    public Vector getData() {
        return this.vector;
    }

    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    public void setValueAt(Object v, int row, int col) {
        try {
            ModuleClasspathData data = (ModuleClasspathData)this.vector.elementAt(row);
            String sValue = v.toString();
            switch (col) {
                case 0: {
                    data.setArchive(sValue);
                    break;
                }
                case 1: {
                    data.setClasspath(sValue);
                    break;
                }
            }
            this.fireTableCellUpdated(row, col);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getRowCount() {
        return this.vector == null ? 0 : this.vector.size();
    }

    public int getColumnCount() {
        return columns.length;
    }

    public String getColumnName(int column) {
        return ModuleClasspathTableModel.columns[column].title;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public Object getValueAt(int nRow, int nCol) {
        if (nRow < 0 || nRow >= this.getRowCount()) {
            return "";
        }
        ModuleClasspathData data = (ModuleClasspathData)this.vector.elementAt(nRow);
        switch (nCol) {
            case 0: {
                return data.getArchive();
            }
            case 1: {
                return data.getClasspath();
            }
        }
        return "";
    }

    public void insert() {
        this.vector.add(new ModuleClasspathData());
        this.fireTableDataChanged();
    }

    public void insert(int nRow) {
        if (nRow < 0) {
            nRow = 0;
        }
        if (nRow > this.vector.size()) {
            nRow = this.vector.size();
        }
        this.vector.insertElementAt(new ModuleClasspathData(), nRow);
        this.fireTableDataChanged();
    }

    public void insert(ModuleClasspathData data) {
        this.vector.add(data);
        this.fireTableDataChanged();
    }

    public boolean delete(int nRow) {
        if (nRow < 0 || nRow >= this.vector.size()) {
            return false;
        }
        this.vector.remove(nRow);
        this.fireTableDataChanged();
        return true;
    }

    protected void clear() {
        for (int k = this.getRowCount() - 1; k >= 0; --k) {
            this.delete(k);
        }
        this.fireTableDataChanged();
    }
}

