/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.config.DConfigBeanRootSpecification;
import jeus.deploy.config.DConfigBeanSpecification;
import jeus.deploy.config.DDBeanReference;
import jeus.tool.builder.AdjustmentException;
import jeus.tool.builder.inspector.xml.EJBModuleXMLInsp;
import jeus.tool.builder.module.desc.EJBModuleDescriptor;
import jeus.tool.xmlui.util.XMLUtil;
import jeus.xml.util.IXPathAPI;
import jeus.xml.util.XPathAPIFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuntimeDDAdjuster {
    private DConfigBeanRootSpecification rootspec;

    public RuntimeDDAdjuster(DConfigBeanRootSpecification specification) {
        this.rootspec = specification;
    }

    public void adjust(Document j2eeDocument, Document jeusDocument) throws AdjustmentException {
        Element j2ee = j2eeDocument.getDocumentElement();
        Element jeus = jeusDocument.getDocumentElement();
        this.adjust(j2ee, jeus);
    }

    public void adjust(Element j2ee, Element jeus) throws AdjustmentException {
        if (jeus == null || !this.rootspec.getRootElement().equals(jeus.getLocalName())) {
            throw new AdjustmentException("j2ee document element's local name must be '" + this.rootspec.getRootElement() + "'.");
        }
        if (!this.rootspec.getNamespace().equals(jeus.getNamespaceURI())) {
            throw new AdjustmentException("j2ee document element's namespace URI must be '" + this.rootspec.getNamespace() + "'.");
        }
        IXPathAPI j2eeAPI = XPathAPIFactory.createXPathAPI();
        IXPathAPI jeusAPI = XPathAPIFactory.createXPathAPI();
        this.adjust(this.rootspec, j2ee, jeus, j2eeAPI, jeusAPI);
    }

    public void adjust(DConfigBeanSpecification parentspec, Element j2eeElement, Element jeusElement) throws AdjustmentException {
        this.adjust(parentspec, j2eeElement, jeusElement, XPathAPIFactory.createXPathAPI(), XPathAPIFactory.createXPathAPI());
    }

    public void adjust(DConfigBeanSpecification parentspec, Element j2eeElement, Element jeusElement, IXPathAPI j2eeAPI, IXPathAPI jeusAPI) throws AdjustmentException {
        DConfigBeanSpecification[] specs = parentspec.getChildren();
        if (specs == null) {
            return;
        }
        for (int i = 0; i < specs.length; ++i) {
            DConfigBeanSpecification spec = specs[i];
            String xpath = spec.getDDBeanXPath(j2eeElement);
            try {
                NodeList nodeList = j2eeAPI.selectNodeList(j2eeElement, xpath, j2eeElement.getOwnerDocument());
                ArrayList<Element> matchedList = new ArrayList<Element>();
                for (int n = 0; n < nodeList.getLength(); ++n) {
                    DDBeanReference[] refs;
                    String sxpath;
                    Element snode = (Element)nodeList.item(n);
                    Element svnode = (Element)j2eeAPI.selectSingleNode(snode, sxpath = (refs = spec.getDDBeanReferences())[0].getSrcXPath(j2eeElement), j2eeElement.getOwnerDocument());
                    if (svnode == null) {
                        throw new AdjustmentException("J2EE element must have " + sxpath + " element.");
                    }
                    String rvalue = XMLUtil.getValue(svnode);
                    String fxpath = "./" + refs[0].getRefFindXPath(jeusElement.getNamespaceURI(), jeusElement.getPrefix());
                    fxpath = fxpath.replaceAll("\\$\\{" + svnode.getLocalName() + "\\}", rvalue);
                    Element rnode = (Element)jeusAPI.selectSingleNode(jeusElement, fxpath, jeusElement.getOwnerDocument());
                    Node rvnode = null;
                    String rxpath = refs[0].getRefXPath(jeusElement.getNamespaceURI(), jeusElement.getPrefix());
                    String rfield = refs[0].getRefField(jeusElement.getNamespaceURI(), jeusElement.getPrefix());
                    if (rnode == null) {
                        if (rfield.startsWith(":")) {
                            rfield = rfield.substring(1);
                        }
                        StringTokenizer stk = new StringTokenizer(rxpath, "/");
                        Node parent = jeusElement;
                        while (stk.hasMoreTokens()) {
                            String token = stk.nextToken();
                            parent = this.findOrCreate(parent, token, !stk.hasMoreTokens());
                        }
                        Document document = parent.getOwnerDocument();
                        Element child = document.createElementNS(parent.getNamespaceURI(), rfield);
                        child.appendChild(document.createTextNode(rvalue));
                        parent.appendChild(child);
                        rnode = (Element)child.getParentNode();
                        rvnode = child;
                    } else {
                        rvnode = jeusAPI.selectSingleNode(jeusElement, fxpath + "/" + rfield, jeusElement.getOwnerDocument());
                    }
                    matchedList.add(rnode);
                    this.adjust(spec, snode, rnode, j2eeAPI, jeusAPI);
                }
                DDBeanReference[] refs = spec.getDDBeanReferences();
                String rxpath = refs[0].getRefXPath(jeusElement.getNamespaceURI(), jeusElement.getPrefix());
                String rfield = refs[0].getRefField(jeusElement.getNamespaceURI(), jeusElement.getPrefix());
                rfield = rfield.substring(rfield.indexOf(":") + 1);
                NodeList targetList = jeusAPI.selectNodeList(jeusElement, "./" + rxpath, jeusElement.getOwnerDocument());
                for (int t = 0; t < targetList.getLength(); ++t) {
                    Node node = targetList.item(t);
                    if (this.containsNode(matchedList, node, rfield) || node.getParentNode() == null) continue;
                    node.getParentNode().removeChild(node);
                }
                continue;
            }
            catch (TransformerException e) {
                System.err.println(xpath);
                e.printStackTrace();
            }
        }
    }

    private boolean containsNode(List matchedList, Node target, String rfield) {
        for (int i = 0; i < matchedList.size(); ++i) {
            Node src = (Node)matchedList.get(i);
            try {
                String srcValue = XMLUtil.getFirstElementValue((Element)src, rfield);
                String targetValue = XMLUtil.getFirstElementValue((Element)target, rfield);
                if (srcValue == null || !srcValue.equals(targetValue)) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private Node findOrCreate(Node parent, String name, boolean leaf) {
        if (name.startsWith(":")) {
            name = name.substring(1);
        }
        if (!leaf) {
            NodeList nodeList = parent.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals(name)) continue;
                return node;
            }
        }
        Document document = parent.getOwnerDocument();
        Element child = document.createElementNS(parent.getNamespaceURI(), name);
        parent.appendChild(child);
        return child;
    }

    public static void main(String[] args) throws Exception {
        EJBModuleDescriptor descriptor = new EJBModuleDescriptor(FileArchiveFactory.openArchiveStatic((String)"d:/projects/jeus5/jeus5/webhome/bongnara_default/customer_ejb/customer_ejb"));
        EJBModuleXMLInsp insp = new EJBModuleXMLInsp(descriptor);
        Element j2eeElement = insp.getJ2eeElement();
        IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
        NodeList nodeList = xpathAPI.selectNodeList(j2eeElement, "./:enterprise-beans/:*/:*[name()='ejb-ref' or name()='ejb-local-ref']");
        System.err.println(nodeList.getLength());
    }
}

