/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.wizard.deploy;

import java.awt.Color;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jeus.tool.builder.resource.ImgRscManager;
import jeus.tool.builder.wizard.deploy.ModuleTreeNode;

public class ModuleTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static Hashtable iconMap = new Hashtable();
    private static String[][] iconPairs = new String[][]{{"J2EEApplication", "/jeus/tool/resource/image/mbean/ear_running.gif"}, {"EJBModule", "/jeus/tool/resource/image/mbean/ejb_module_running.gif"}, {"WebModule", "/jeus/tool/resource/image/mbean/web_module_running.gif"}, {"ResourceAdapterModule", "/jeus/tool/resource/image/mbean/ra_module_running.gif"}, {"AppClientModule", "/jeus/tool/resource/image/mbean/ca_module_running.gif"}, {"StatelessSessionBean", "/jeus/tool/resource/image/mbean/ejb_stateless_running.gif"}, {"StatefulSessionBean", "/jeus/tool/resource/image/mbean/ejb_stateful_running.gif"}, {"EntityBean", "/jeus/tool/resource/image/mbean/ejb_entity_running.gif"}, {"MessageDrivenBean", "/jeus/tool/resource/image/mbean/ejb_message_running.gif"}, {"Servlet", "/jeus/tool/resource/image/mbean/servlet_running.gif"}};

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof ModuleTreeNode) {
            ModuleTreeNode node = (ModuleTreeNode)value;
            Icon icon = (Icon)iconMap.get(node.getXMLInspector().getType());
            if (icon != null) {
                label.setIcon(icon);
            }
            label.setText(node.getXMLInspector().getName());
        }
        return label;
    }

    public Color getTextSelectionColor() {
        return Color.WHITE;
    }

    public Color getBorderSelectionColor() {
        return Color.decode("#597FBF").darker().darker();
    }

    public Color getBackgroundSelectionColor() {
        return Color.decode("#597FBF");
    }

    static {
        for (int i = 0; i < iconPairs.length; ++i) {
            try {
                Icon icon = ImgRscManager.getImageIcon(iconPairs[i][1]);
                iconMap.put(iconPairs[i][0], icon);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

