/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jeus.tool.common.CancelButtonDialog;
import jeus.tool.common.ConfigPane;
import jeus.tool.configui.ListConfigContainerPanel;

public class ConfigDialog
extends CancelButtonDialog {
    public boolean SHOW_ERROR_DEFAULT_DLG = true;
    ConfigPane confPane = new ConfigPane();
    JPanel jPanel1 = new JPanel();
    JButton cancelBT = new JButton();
    JButton okBT = new JButton();
    private static final int FIXED_WIDTH = 400;
    private static final int LIST_FIXED_WIDTH = 600;
    private static final int LIST_FIXED_HEIGHT = 500;

    public ConfigDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ConfigDialog(ConfigPane confPane) {
        this.confPane = confPane;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean showDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getPreferredSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        this.isCanceled = false;
        this.isOk = false;
        this.pack();
        if (this.confPane instanceof ListConfigContainerPanel && ((ListConfigContainerPanel)this.confPane).getItemCount() > 0) {
            if (this.getWidth() < 600) {
                this.setSize(600, this.getHeight());
            }
            if (this.getHeight() < 500) {
                this.setSize(this.getWidth(), 500);
            }
        } else if (this.getWidth() < 400) {
            this.setSize(400, this.getHeight());
        }
        this.show();
        return this.getCanceled();
    }

    public void setCustomizeErrorDlg() {
        this.SHOW_ERROR_DEFAULT_DLG = false;
    }

    private void jbInit() throws Exception {
        this.setTitle(this.confPane.getTitle());
        this.setModal(true);
        this.cancelBT.setText("Cancel");
        this.cancelBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.cancelBT_actionPerformed(e);
            }
        });
        this.okBT.setText("  Ok  ");
        this.okBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.okBT_actionPerformed(e);
            }
        });
        if (this.confPane instanceof ListConfigContainerPanel) {
            this.getContentPane().add((Component)this.confPane, "Center");
        } else {
            JScrollPane scroll = new JScrollPane(this.confPane);
            this.getContentPane().add((Component)scroll, "Center");
        }
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.okBT, null);
        this.jPanel1.add((Component)this.cancelBT, null);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder(1));
    }

    void cancelBT_actionPerformed(ActionEvent e) {
        this.setCanceled();
        this.dispose();
    }

    void okBT_actionPerformed(ActionEvent e) {
        this.createConfig();
        String message = this.checkInputValidity();
        if (message != null) {
            if (this.SHOW_ERROR_DEFAULT_DLG) {
                JOptionPane.showMessageDialog(this, message, "Error", 0);
            }
            return;
        }
        this.setOk();
        this.dispose();
    }

    public void setConfig(Object config) {
        this.confPane.setConfigObject(config);
    }

    public Object getConfig() {
        return this.confPane.getConfigObject();
    }

    private void createConfig() {
        this.confPane.createConfig();
    }

    public void removeCancel() {
        this.jPanel1.remove(this.cancelBT);
    }

    public String checkInputValidity() {
        try {
            return this.confPane.checkInputValidity();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

