/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JList;
import jeus.tool.common.ExtensionFileFilter;
import jeus.util.JeusBootstrapProperties;

public class DefaultPathFileChooser
extends JFileChooser {
    static String defaultPath = JeusBootstrapProperties.JEUS_HOME;

    public DefaultPathFileChooser() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setMultiSelectionEnabled(true);
    }

    public DefaultPathFileChooser(String dPath, String title, boolean multiSel, boolean acceptAll) {
        super(dPath);
        if (!acceptAll) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        this.setCurrentDirectory(new File(dPath));
        this.setMultiSelectionEnabled(multiSel);
        this.setDialogTitle(title);
    }

    public DefaultPathFileChooser(String title, boolean multiSel, boolean acceptAll) {
        super(defaultPath);
        if (!acceptAll) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        this.setCurrentDirectory(new File(defaultPath));
        this.setMultiSelectionEnabled(multiSel);
        this.setDialogTitle(title);
    }

    public String getDefaultPath() {
        return defaultPath;
    }

    public void setFilteringExtension(String extension, String description) {
        ExtensionFileFilter filter = new ExtensionFileFilter(extension, description);
        this.setFileFilter(filter);
    }

    public void setFilteringExtension(String[] extension) {
        ExtensionFileFilter filter = new ExtensionFileFilter(extension);
        this.setFileFilter(filter);
    }

    public void setFilteringExtension(String[] extension, String description) {
        ExtensionFileFilter filter = new ExtensionFileFilter(extension, description);
        this.setFileFilter(filter);
    }

    public int showFileDialog(Component parent, String buttonText) {
        int returnVal = this.showDialog(parent, buttonText);
        if (returnVal == 0) {
            defaultPath = this.getSelectedFile().getParent();
        }
        return returnVal;
    }

    public File[] getSelectedFiles2() {
        Container c1 = (Container)this.getComponent(3);
        JList list = null;
        while (c1 != null) {
            Container c = (Container)c1.getComponent(0);
            if (c instanceof JList) {
                list = (JList)c;
                break;
            }
            c1 = c;
        }
        Object[] entries = list.getSelectedValues();
        File[] files = new File[entries.length];
        for (int k = 0; k < entries.length; ++k) {
            if (!(entries[k] instanceof File)) continue;
            files[k] = (File)entries[k];
        }
        return files;
    }
}

