/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ListDisplayPane
extends JPanel
implements ActionListener {
    TitledBorder titledBorder1;
    JScrollPane jScrollPane1 = new JScrollPane();
    JList displayLST = new JList();
    public JButton removeBT = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    public JButton addBT = new JButton();
    public JButton modifyBT = new JButton();
    private String title = "List Display Pane";
    private DefaultListModel model = new DefaultListModel();
    private boolean isDuplicationEnabled = true;
    public static final String ADD = "Add";
    public static final String MODIFY = "Modify";
    public int mode = 0;
    public static final int EDIT_MODE = 0;
    public static final int BROWSE_MODE = 1;
    public boolean removeDisable = false;

    public ListDisplayPane() {
        this.addActionListenerToAddCommand(this);
        this.addActionListenerToModifyCommand(this);
        this.addActionListenerToRemoveCommand(this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ListDisplayPane(String title) {
        this.title = title;
        this.addActionListenerToAddCommand(this);
        this.addActionListenerToModifyCommand(this);
        this.addActionListenerToRemoveCommand(this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ListDisplayPane(String title, ActionListener listener) {
        this.title = title;
        this.addActionListenerToAddCommand(listener);
        this.addActionListenerToModifyCommand(listener);
        this.addActionListenerToRemoveCommand(this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ListDisplayPane(String title, ActionListener listener, boolean isDuplicationEnabled) {
        this.title = title;
        this.setDuplicationEnabled(isDuplicationEnabled);
        this.addActionListenerToAddCommand(listener);
        this.addActionListenerToModifyCommand(listener);
        this.addActionListenerToRemoveCommand(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public ListDisplayPane(String title, ActionListener listener, boolean isDuplicationEnabled, boolean removeDisable) {
        this.title = title;
        this.removeDisable = removeDisable;
        this.setDuplicationEnabled(isDuplicationEnabled);
        this.addActionListenerToAddCommand(listener);
        this.addActionListenerToModifyCommand(listener);
        if (removeDisable) {
            this.addActionListenerToRemoveCommand(listener);
        } else {
            this.addActionListenerToRemoveCommand(this);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addBT) {
            this.add();
        } else if (e.getSource() == this.modifyBT) {
            this.modify();
        } else if (e.getSource() == this.removeBT) {
            if (this.removeDisable) {
                this.removeNothing();
            } else {
                this.remove();
            }
        }
    }

    public void add() {
    }

    public void modify() {
    }

    public void removeNothing() {
    }

    public void setListDisabled() {
        this.addBT.setEnabled(false);
        this.modifyBT.setEnabled(false);
        this.removeBT.setEnabled(false);
    }

    public void setListEnabled() {
        this.addBT.setEnabled(true);
        this.modifyBT.setEnabled(true);
        this.removeBT.setEnabled(true);
    }

    public void setDuplicationEnabled(boolean isDuplicationEnabled) {
        this.isDuplicationEnabled = isDuplicationEnabled;
    }

    public void addActionListenerToAddCommand(ActionListener listener) {
        this.addBT.addActionListener(listener);
    }

    public void addActionListenerToModifyCommand(ActionListener listener) {
        this.modifyBT.addActionListener(listener);
    }

    public void addActionListenerToRemoveCommand(ActionListener listener) {
        this.removeBT.addActionListener(listener);
    }

    public void removeModifyButton() {
        this.remove(this.modifyBT);
    }

    public void setModificationEnabled(boolean isModificationEnabled) {
        this.modifyBT.setVisible(isModificationEnabled);
        this.modifyBT.setEnabled(isModificationEnabled);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.titledBorder1 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(134, 134, 134)), this.title);
        this.removeBT.setMaximumSize(new Dimension(79, 29));
        this.removeBT.setText("Remove");
        this.addBT.setText(ADD);
        this.modifyBT.setText(MODIFY);
        this.setBorder(this.titledBorder1);
        this.displayLST.setModel(this.model);
        this.jScrollPane1.setPreferredSize(new Dimension(250, 131));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.removeBT, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.addBT, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.modifyBT, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.displayLST, null);
    }

    public void modifyPreferredSize(Dimension dim) {
        this.jScrollPane1.setPreferredSize(dim);
    }

    public void setBrowseMode() {
        this.addBT.setEnabled(false);
        this.removeBT.setEnabled(false);
        this.modifyBT.setText("Browse");
        this.mode = 1;
    }

    public void remove() {
        Object[] objects = this.displayLST.getSelectedValues();
        for (int i = 0; i < objects.length; ++i) {
            this.model.removeElement(objects[i]);
        }
    }

    public void removeElement(int i) {
        this.model.removeElementAt(i);
    }

    public boolean addItem(Object object) {
        if (!this.isDuplicationEnabled && this.existInList(object)) {
            return false;
        }
        this.model.addElement(object);
        return true;
    }

    public Object[] getSelectedValues() {
        return this.displayLST.getSelectedValues();
    }

    public Object getSelectedValue() {
        return this.displayLST.getSelectedValue();
    }

    public Object getValueAt(int index) {
        return this.model.get(index);
    }

    public boolean existInList(Object object) {
        return this.model.contains(object);
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    public Object[] getValues() {
        return this.model.toArray();
    }

    public void modifyValueAt(int index, Object object) {
        this.model.removeElementAt(index);
        this.model.add(index, object);
    }

    public int getSelectedIndex() {
        return this.displayLST.getSelectedIndex();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

