/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jeus.tool.common.CancelButtonDialog;

public class TableRowInputDialog
extends CancelButtonDialog {
    JPanel jPanel2 = new JPanel();
    JPanel jPanel1 = new JPanel();
    JButton okBT = new JButton();
    JButton cancelBT = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextField[] textFields;
    JComboBox comboBox;
    JLabel[] labels;
    int cbIndex = -1;
    int[] mandatoryRows;

    public TableRowInputDialog(String[] columnNames) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setColumnNames(columnNames);
    }

    public TableRowInputDialog(String[] columnNames, int[] disableRows) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setColumnNames(columnNames, disableRows);
    }

    public TableRowInputDialog(String[] columnNames, int index, String value) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setColumnNames(columnNames);
        this.textFields[index].setText(value);
    }

    public TableRowInputDialog(String[] columnNames, String[] values) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setColumnNames(columnNames);
        for (int i = 0; i < values.length; ++i) {
            this.textFields[i].setText(values[i]);
        }
    }

    public TableRowInputDialog(String[] columnNames, int cbIndex, JComboBox cb) {
        this.cbIndex = cbIndex;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setColumnNames(columnNames, cbIndex, cb);
    }

    public TableRowInputDialog(String[] columnNames, String[] values, int cbIndex, JComboBox cb) {
        this.cbIndex = cbIndex;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setColumnNames(columnNames, cbIndex, cb);
        for (int i = 0; i < values.length; ++i) {
            this.textFields[i].setText(values[i]);
        }
    }

    public TableRowInputDialog(String[] columnNames, int cbIndex, JComboBox cb, int[] disableRows) {
        this.cbIndex = cbIndex;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setColumnNames(columnNames, cbIndex, cb, disableRows);
    }

    public TableRowInputDialog(String[] columnNames, String[] values, int cbIndex, JComboBox cb, int[] disableRows) {
        this.cbIndex = cbIndex;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setColumnNames(columnNames, cbIndex, cb, disableRows);
        for (int i = 0; i < values.length; ++i) {
            this.textFields[i].setText(values[i]);
        }
    }

    private void setColumnNames(String[] columnNames, int cbIndex, JComboBox cb, int[] disableRows) {
        this.textFields = new JTextField[columnNames.length];
        this.labels = new JLabel[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            JLabel label = new JLabel();
            label.setText(columnNames[i]);
            this.jPanel2.add((Component)label, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.labels[i] = label;
            if (i == cbIndex) {
                this.jPanel2.add((Component)cb, new GridBagConstraints(1, i, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.comboBox = cb;
            } else {
                JTextField textField = new JTextField();
                textField.setColumns(20);
                this.jPanel2.add((Component)textField, new GridBagConstraints(1, i, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.textFields[i] = textField;
            }
            for (int k = 0; k < disableRows.length; ++k) {
                if (disableRows[k] != i) continue;
                this.labels[i].setEnabled(false);
                if (i == cbIndex) {
                    this.comboBox.setEnabled(false);
                    continue;
                }
                this.textFields[i].setEnabled(false);
            }
        }
    }

    private void setColumnNames(String[] columnNames, int cbIndex, JComboBox cb) {
        this.textFields = new JTextField[columnNames.length];
        this.labels = new JLabel[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            JLabel label = new JLabel();
            label.setText(columnNames[i]);
            this.jPanel2.add((Component)label, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.labels[i] = label;
            if (i == cbIndex) {
                this.jPanel2.add((Component)cb, new GridBagConstraints(1, i, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.comboBox = cb;
                continue;
            }
            JTextField textField = new JTextField();
            textField.setColumns(20);
            this.jPanel2.add((Component)textField, new GridBagConstraints(1, i, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.textFields[i] = textField;
        }
    }

    private void setColumnNames(String[] columnNames, int[] disableRows) {
        this.textFields = new JTextField[columnNames.length];
        this.labels = new JLabel[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            JLabel label = new JLabel();
            label.setText(columnNames[i]);
            this.jPanel2.add((Component)label, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.labels[i] = label;
            JTextField textField = new JTextField();
            textField.setColumns(20);
            this.jPanel2.add((Component)textField, new GridBagConstraints(1, i, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.textFields[i] = textField;
            for (int k = 0; k < disableRows.length; ++k) {
                if (disableRows[k] != i) continue;
                this.labels[i].setEnabled(false);
                this.textFields[i].setEnabled(false);
            }
        }
    }

    private void setColumnNames(String[] columnNames) {
        this.textFields = new JTextField[columnNames.length];
        this.labels = new JLabel[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            JLabel label = new JLabel();
            label.setText(columnNames[i]);
            this.jPanel2.add((Component)label, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.labels[i] = label;
            JTextField textField = new JTextField();
            textField.setColumns(20);
            this.jPanel2.add((Component)textField, new GridBagConstraints(1, i, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.textFields[i] = textField;
        }
    }

    public void setMandatoryColumn(int[] columns) {
        this.mandatoryRows = columns;
    }

    public String checkInputValidity() {
        String msg = null;
        if (this.mandatoryRows != null) {
            for (int i = 0; i < this.mandatoryRows.length; ++i) {
                int index = this.mandatoryRows[i];
                if (this.textFields[index].getText() != null && !this.textFields[index].getText().equals("")) continue;
                String labelName = this.labels[index].getText().replace('*', ' ').trim();
                msg = "[" + this.getTitle() + "] " + labelName + " field must be set";
                return msg;
            }
        }
        return msg;
    }

    private void jbInit() throws Exception {
        this.okBT.setText("  Ok  ");
        this.okBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableRowInputDialog.this.okBT_actionPerformed(e);
            }
        });
        this.cancelBT.setText("Cancel");
        this.cancelBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableRowInputDialog.this.cancelBT_actionPerformed(e);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.setModal(true);
        this.setTitle("Table Row Data Input Dialog");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.okBT, null);
        this.jPanel1.add((Component)this.cancelBT, null);
    }

    void okBT_actionPerformed(ActionEvent e) {
        String msg = this.checkInputValidity();
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg, this.getTitle() + " Error", 0);
            return;
        }
        this.setOk();
        this.dispose();
    }

    void cancelBT_actionPerformed(ActionEvent e) {
        this.setCanceled();
        this.dispose();
    }

    public String getInputData(int column) {
        if (column == this.cbIndex) {
            return (String)this.comboBox.getSelectedItem();
        }
        return this.textFields[column].getText();
    }

    public String[] getAllInputData() {
        String[] val = new String[this.textFields.length];
        for (int i = 0; i < this.textFields.length; ++i) {
            val[i] = i == this.cbIndex ? (String)this.comboBox.getSelectedItem() : this.textFields[i].getText();
        }
        return val;
    }

    public void setDefaultValue(String defaultValue, int column) {
        if (column == this.cbIndex) {
            this.comboBox.setSelectedItem(defaultValue);
        } else {
            this.textFields[column].setText(defaultValue);
        }
    }
}

