/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common.xml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jeus.tool.common.xml.XMLUtil;

public class XMLTree
implements Cloneable {
    private String name = null;
    private String value = null;
    private String publicID = null;
    private String systemID = null;
    private Hashtable attributes = new Hashtable();
    private Vector elements = new Vector();
    private String[] displayValue = null;
    private String displayDelim = " ";
    private boolean addXMLNameToDisplayName = false;
    public final String ADD_XML_NAME_PREFIX = "::XMLNAME::";
    private String nodeName = null;
    private String engineContainerName = null;
    private String engineName = null;

    public XMLTree() {
    }

    public XMLTree(String name) {
        this.setName(name);
    }

    public XMLTree(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object clone() {
        try {
            XMLTree newTree = new XMLTree();
            newTree.setName(new String(this.name));
            if (this.value != null) {
                newTree.setValue(new String(this.value));
            }
            if (this.publicID != null) {
                newTree.setPublicID(new String(this.publicID));
            }
            if (this.systemID != null) {
                newTree.setSystemID(new String(this.systemID));
            }
            newTree.setAttributes((Hashtable)this.attributes.clone());
            Vector<XMLTree> v = new Vector<XMLTree>();
            Enumeration enum1 = this.elements.elements();
            while (enum1.hasMoreElements()) {
                XMLTree eachTree = (XMLTree)enum1.nextElement();
                v.add((XMLTree)eachTree.clone());
            }
            newTree.setElements(v);
            return newTree;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPublicID() {
        return this.publicID;
    }

    public void setPublicID(String publicID) {
        this.publicID = publicID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String systemID) {
        this.systemID = systemID;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value != null ? value.trim() : value;
    }

    public void appendValue(String _value) {
        this.value = this.value != null ? this.value + _value.trim() : _value.trim();
    }

    public Object getAttribute(Object key) {
        if (key == null) {
            throw new NullPointerException("getAttribute(key)");
        }
        return this.attributes.get(key);
    }

    public String getAttributeDefault(String keyVal, String defaultValue) {
        String key = keyVal;
        if (key == null) {
            throw new NullPointerException("getAttribute(key)");
        }
        String val = (String)this.attributes.get(key);
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public void addAttribute(Object key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        this.attributes.put(key, value);
    }

    public void addAttributeDefault(String key, String value, String defaultValue) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        if (value.trim().equals("")) {
            return;
        }
        if (value.equals(defaultValue)) {
            return;
        }
        this.attributes.put(key, value);
    }

    public void addStrictAttribute(String key, String value) {
        if (value != null && !value.trim().equals("")) {
            String keyValue = key;
            String objValue = value;
            this.addAttribute(keyValue, objValue);
        }
    }

    public void removeAttribute(Object key) {
        if (key == null) {
            return;
        }
        this.attributes.remove(key);
    }

    public Enumeration attributes() {
        return this.attributes.keys();
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Hashtable value) {
        this.attributes = value;
    }

    public void addElement(Object value) {
        if (value == null) {
            return;
        }
        this.elements.addElement(value);
    }

    public void addElements(Vector values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            Object val = values.get(i);
            this.elements.addElement(val);
        }
    }

    public void removeElement(Object value) {
        if (value == null) {
            return;
        }
        this.elements.removeElement(value);
    }

    public Enumeration elements() {
        return this.elements.elements();
    }

    public XMLTree getFirstElement(Object key) {
        if (this.getElements(key).size() > 0) {
            return (XMLTree)this.getElements(key).elementAt(0);
        }
        return null;
    }

    public Enumeration elements(Object key) {
        return this.getElements(key).elements();
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector value) {
        this.elements = value;
    }

    public Vector getElement(String key) {
        String objKey = key;
        return this.getElements(key);
    }

    public Vector getElements(Object key) {
        Vector<XMLTree> v = new Vector<XMLTree>();
        Enumeration e = this.getElements().elements();
        while (e.hasMoreElements()) {
            XMLTree element = (XMLTree)e.nextElement();
            if (!element.getName().equals(key)) continue;
            v.addElement(element);
        }
        return v;
    }

    public Hashtable getElementMappingTable() {
        Hashtable<String, Vector> nameList = new Hashtable<String, Vector>();
        Enumeration enum1 = this.elements();
        while (enum1.hasMoreElements()) {
            XMLTree element = (XMLTree)enum1.nextElement();
            String elementName = element.getName();
            if (nameList.containsKey(elementName)) continue;
            nameList.put(elementName, this.getElements(elementName));
        }
        return nameList;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public void clear() {
        this.attributes.clear();
        this.elements.removeAllElements();
    }

    public String toDebug() {
        StringBuffer str = new StringBuffer();
        str.append("[" + this.name + " : " + this.value + "]\n");
        str.append("elements : ");
        for (int i = 0; i < this.elements.size(); ++i) {
            XMLTree oneTree = (XMLTree)this.elements.get(i);
            str.append(oneTree.toDebug());
        }
        return str.toString();
    }

    public String toString() {
        if (this.displayValue == null || this.displayValue.length == 0) {
            StringBuffer stb = new StringBuffer();
            stb.append(this.name);
            if (this.value != null && !this.value.trim().equals("")) {
                stb.append(":" + this.value);
            } else if (this.elements != null && this.elements.size() > 0) {
                Vector subElements;
                XMLTree firstSubElement;
                String firstSubValue;
                XMLTree firstElement = (XMLTree)this.elements.elementAt(0);
                String firstValue = firstElement.getValue();
                if (firstValue != null && !firstValue.trim().equals("")) {
                    stb.append(":" + firstValue);
                } else if (firstElement.getElements() != null && firstElement.getElements().size() > 0 && (firstSubValue = (firstSubElement = (XMLTree)(subElements = firstElement.getElements()).elementAt(0)).getValue()) != null && !firstSubValue.trim().equals("")) {
                    stb.append(":" + firstSubValue);
                }
            }
            String s = stb.toString();
            return s;
        }
        StringBuffer s2 = new StringBuffer();
        if (this.addXMLNameToDisplayName && this.name != null) {
            s2.append("( " + this.name + " ) ");
        }
        for (int i = 0; i < this.displayValue.length; ++i) {
            if (i != 0) {
                if (this.displayDelim != null && !this.displayDelim.trim().equals("")) {
                    s2.append(this.displayDelim);
                } else {
                    s2.append("_");
                }
            }
            s2.append(this.displayValue[i]);
        }
        return s2.toString();
    }

    public void setDisplayItemName(String itemName) {
        if (itemName == null) {
            return;
        }
        if (itemName.equals("container-transaction")) {
            this.displayValue = new String[1];
            Vector methodList = this.getElements("method");
            if (methodList == null || methodList.size() == 0) {
                this.displayValue[0] = "container-transaction";
                return;
            }
            XMLTree firstMethod = (XMLTree)methodList.get(0);
            String firstMethodEJBName = XMLUtil.getSubtreeValue(firstMethod, "ejb-name");
            String firstMethodMethodName = XMLUtil.getSubtreeValue(firstMethod, "method-name");
            String methodString = firstMethodEJBName + ":" + firstMethodMethodName;
            StringBuffer stb = new StringBuffer();
            stb.append(methodString);
            XMLTree transAttrTree = this.getFirstElement("trans-attribute");
            if (transAttrTree.getValue() != null) {
                stb.append("(" + transAttrTree.getValue() + ")");
            }
            this.displayValue[0] = stb.toString();
            return;
        }
        if (itemName.equals("method-permission")) {
            this.displayValue = new String[1];
            Vector methodList = this.getElements("method");
            if (methodList == null || methodList.size() == 0) {
                this.displayValue[0] = "method-permission";
                return;
            }
            XMLTree firstMethod = (XMLTree)methodList.get(0);
            String firstMethodEJBName = XMLUtil.getSubtreeValue(firstMethod, "ejb-name");
            String firstMethodMethodName = XMLUtil.getSubtreeValue(firstMethod, "method-name");
            String methodString = firstMethodEJBName + ":" + firstMethodMethodName;
            StringBuffer stb = new StringBuffer();
            Vector roleList = this.getElements("role-name");
            if (roleList == null || roleList.size() == 0) {
                Vector uncheck = this.getElements("unchecked");
                if (uncheck == null || uncheck.size() == 0) {
                    this.displayValue[0] = methodString;
                    return;
                }
                stb.append(methodString);
                stb.append(" (unchecked) ");
                this.displayValue[0] = stb.toString();
                return;
            }
            XMLTree firstRole = (XMLTree)roleList.get(0);
            String roleString = firstRole.getValue();
            stb.append(methodString);
            stb.append(" (" + roleString + ")");
            this.displayValue[0] = stb.toString();
            return;
        }
        if (itemName.startsWith("::XMLNAME::")) {
            this.addXMLNameToDisplayName = true;
            itemName = itemName.substring("::XMLNAME::".length());
        }
        String delim = " ";
        if (itemName.indexOf(":") > 0) {
            delim = ":";
            this.displayDelim = ":";
        }
        StringTokenizer sToken = new StringTokenizer(itemName, delim);
        ArrayList<String> nameList = new ArrayList<String>();
        while (sToken.hasMoreTokens()) {
            nameList.add(sToken.nextToken());
        }
        this.displayValue = new String[nameList.size()];
        for (int k = 0; k < nameList.size(); ++k) {
            XMLTree childTree;
            String foundName = (String)nameList.get(k);
            if (this.attributes.containsKey(foundName)) {
                this.displayValue[k] = (String)this.attributes.get(foundName);
            }
            if ((childTree = this.getFirstElement(foundName)) == null) continue;
            this.displayValue[k] = childTree.getValue();
        }
        if (this.displayValue[0] == null) {
            String elementName = (String)nameList.get(0);
            XMLTree firstOne = (XMLTree)this.elements.get(0);
            if (firstOne != null) {
                this.displayValue[0] = XMLUtil.getSubtreeValue(firstOne, elementName);
            }
        }
    }

    public void setNodeName(String name) {
        this.nodeName = name;
    }

    public void setEngineContainerName(String name) {
        this.engineContainerName = name;
    }

    public void setEngineName(String name) {
        this.engineName = name;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getEngineContainerName() {
        return this.engineContainerName;
    }

    public String getEngineName() {
        return this.engineName;
    }
}

