/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import jeus.security.util.Base64Coder;
import jeus.tool.common.ConfigDialog;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.configui.ConfigItemPanel;
import jeus.tool.configui.ConfigManagerList;
import jeus.tool.configui.ConfigPanel;
import jeus.tool.configui.DoubleConfigPanel;
import jeus.tool.configui.ExclusiveConfigPanel;
import jeus.tool.configui.FlatConfigContainerPanel;
import jeus.tool.configui.ListConfigContainerPanel;
import jeus.tool.configui.MultiConfigList;
import jeus.tool.configui.MultiItemTable;
import jeus.tool.configui.MultiSelectTable;
import jeus.tool.configui.ScrollableTextArea;
import jeus.tool.configui.XMLOptionParameter;
import jeus.tool.configui.schema.ConfigContainer;
import jeus.tool.configui.schema.ConfigExclusiveContainer;
import jeus.tool.configui.schema.ConfigItem;
import jeus.tool.manager.common.XMLSettingDialogFactory;
import jeus.util.ErrorMsgManager;

public class ConfigContainerPanel
extends ConfigPanel {
    protected ConfigContainer mySchema;
    protected XMLTree myTree;
    Vector xmlChildTrees;
    protected String externalID = "";
    protected Vector msgVector = new Vector();
    protected ConfigManagerList configManagerList = new ConfigManagerList();
    ConfigContainerPanel multiChildPanel;
    String LANGUAGE = WIOParameters.LANGUAGE;
    protected boolean _OnlyOneSubContainer = false;
    protected int pane_xml_y = -1;
    protected int xml_x_max = 2;
    protected Color REQUIRED_COLOR = Color.decode("#597FBF");
    protected JTabbedPane tabPane = new JTabbedPane();
    protected JPanel basicPane;

    public ConfigContainerPanel() {
    }

    public ConfigContainerPanel(Object descriptor) {
        super(descriptor);
    }

    public ConfigContainerPanel(ConfigContainer desc) {
        this.basicPane = this;
        this.mySchema = desc;
        if (desc.getGlobalID() != null) {
            this.externalID = desc.getGlobalID();
        }
        try {
            this.setInit(desc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String val) {
        this.externalID = val;
    }

    public ConfigManagerList getConfigManagerList() {
        return this.configManagerList;
    }

    public XMLTree getMyTree() {
        return this.myTree;
    }

    public void setXIndexMax(int val) {
        this.xml_x_max = val;
    }

    public void resetValue() {
        Enumeration elementEnum = this.configManagerList.keys();
        while (elementEnum.hasMoreElements()) {
            String itemName = (String)elementEnum.nextElement();
            ConfigPanel confElementPane = this.configManagerList.getPanel(itemName);
            confElementPane.resetValue();
        }
    }

    public void setConfigurationValue(XMLTree xmlTree) {
        this.myTree = xmlTree;
        this.descriptor = xmlTree;
        if (this.myTree == null || this.myTree.getName() == null) {
            this.resetValue();
            return;
        }
        this.resetValue();
        Hashtable attrList = xmlTree.getAttributes();
        Enumeration keyEnum = attrList.keys();
        while (keyEnum.hasMoreElements()) {
            String nextKey = (String)keyEnum.nextElement();
            String nextValue = (String)attrList.get(nextKey);
            ConfigItemPanel confItemPane = (ConfigItemPanel)this.configManagerList.getPanel(nextKey);
            if (confItemPane == null) continue;
            confItemPane.setValue(nextValue);
        }
        Hashtable elementTable = xmlTree.getElementMappingTable();
        int elementCount = xmlTree.getElementCount();
        int eleTmpCount = 0;
        Enumeration keyEnum2 = elementTable.keys();
        while (keyEnum2.hasMoreElements()) {
            ConfigPanel confElementPane;
            String elementName = (String)keyEnum2.nextElement();
            Vector elementVector = (Vector)elementTable.get(elementName);
            String childName = "";
            String childValue = "";
            XMLTree elementTree = null;
            if (elementVector != null && elementVector.size() == 1) {
                elementTree = (XMLTree)elementVector.get(0);
                childName = elementTree.getName();
                childValue = elementTree.getValue();
            }
            if ((confElementPane = this.configManagerList.getPanel(elementName)) == null) continue;
            if (confElementPane instanceof ConfigItemPanel) {
                ConfigItemPanel confItemPane = (ConfigItemPanel)confElementPane;
                if (confItemPane.getType() != null && confItemPane.getType().equals("Empty")) {
                    confItemPane.setValue("true");
                    continue;
                }
                confItemPane.setValue(childValue);
                continue;
            }
            if (confElementPane instanceof MultiItemTable) {
                MultiItemTable mTablePane = (MultiItemTable)confElementPane;
                String[] tmpList = new String[elementVector.size()];
                for (int x = 0; x < tmpList.length; ++x) {
                    XMLTree tmpTree = (XMLTree)elementVector.get(x);
                    tmpList[x] = tmpTree.getValue();
                }
                mTablePane.setValue(tmpList);
                continue;
            }
            if (confElementPane instanceof ConfigContainerPanel) {
                ConfigContainerPanel confContainerPane = (ConfigContainerPanel)confElementPane;
                confContainerPane.setValue(elementTree);
                continue;
            }
            if (confElementPane instanceof ExclusiveConfigPanel) {
                ExclusiveConfigPanel exPane = (ExclusiveConfigPanel)confElementPane;
                exPane.setValue(elementVector);
                continue;
            }
            if (confElementPane instanceof MultiConfigList) {
                MultiConfigList mListPane = (MultiConfigList)confElementPane;
                if (mListPane.isExclusive()) {
                    mListPane.setValueExclusive(elementVector);
                    if (elementVector != null) {
                        eleTmpCount += elementVector.size();
                    }
                    if (eleTmpCount != elementCount) continue;
                    mListPane.setValueFinish();
                    continue;
                }
                mListPane.setValue(elementVector);
                continue;
            }
            if (confElementPane instanceof DoubleConfigPanel) {
                DoubleConfigPanel doublePane = (DoubleConfigPanel)confElementPane;
                doublePane.setValue(elementVector);
                continue;
            }
            if (confElementPane instanceof MultiSelectTable) {
                MultiSelectTable newPanel = (MultiSelectTable)confElementPane;
                newPanel.setValue(elementVector);
                continue;
            }
            System.out.println("can not find ConfigContainerPane for element (" + childName + ")");
        }
    }

    public Vector getMessage() {
        return this.msgVector;
    }

    public String checkInputValidity() {
        Vector msgVector = this.getMessage();
        ConfigDialog dlg = XMLSettingDialogFactory.getDlg(msgVector);
        if (dlg != null) {
            dlg.showDialog();
            return "XML Configuration is not complete";
        }
        return null;
    }

    public XMLTree getConfigurationValue() throws XMLConverterException {
        this.msgVector = new Vector();
        String myName = this.mySchema.getName();
        this.myTree = new XMLTree(myName);
        this.descriptor = this.myTree;
        ConfigItem[] subItems = this.mySchema.getConfigItem();
        boolean isIntendedToSet = true;
        boolean thereIsRequiredField = false;
        boolean someRequiredFieldSet = false;
        for (int i = 0; subItems != null && i < subItems.length; ++i) {
            String value;
            ConfigItem subItem = subItems[i];
            String itemName = subItem.getName();
            String itemDisplayName = subItem.getDisplayName();
            String itemType = subItem.getItemType();
            String defaultValue = subItem.getDefaultValue();
            String isMulti = subItem.getMulti();
            String xmlType = subItem.getXmlType();
            String isRequired = subItem.getRequired();
            if (isMulti != null && !isMulti.trim().equals("")) {
                MultiItemTable multiItemTable = (MultiItemTable)this.configManagerList.getPanel(itemName);
                String[] valueList = (String[])multiItemTable.getValue();
                if (valueList.length <= 0) continue;
                for (int k = 0; k < valueList.length; ++k) {
                    XMLTree elementTree = new XMLTree(itemName);
                    elementTree.setValue(valueList[k]);
                    if (valueList[k] == null || valueList[k].trim().equals("")) continue;
                    this.myTree.addElement(elementTree);
                }
                continue;
            }
            ConfigItemPanel confItemPane = (ConfigItemPanel)this.configManagerList.getPanel(itemName);
            if (confItemPane == null) {
                confItemPane = (ConfigItemPanel)this.configManagerList.getPanel(itemName);
            }
            if ((value = (String)confItemPane.getValue()) == null || value.trim().equals("")) {
                if (isRequired != null && isRequired.equals("true")) {
                    thereIsRequiredField = true;
                    this.msgVector.add(ErrorMsgManager.getLocalizedString((int)12500, (Object[])new String[]{myName, itemName}));
                }
                if (confItemPane.getType() == null || !confItemPane.getType().equals("Empty")) continue;
                this.myTree.addElement(new XMLTree(itemName));
                continue;
            }
            if (xmlType.equals("attr") || xmlType.equals("attribute")) {
                if (XMLOptionParameter.SHOW_DEFAULT_XML) {
                    this.myTree.addAttribute(itemName, value);
                    continue;
                }
                if (value.equals(defaultValue)) continue;
                this.myTree.addAttribute(itemName, value);
                continue;
            }
            if (isRequired != null && isRequired.equals("true")) {
                someRequiredFieldSet = true;
            }
            XMLTree elementTree = new XMLTree(itemName);
            if (confItemPane.getType() != null && confItemPane.getType().equalsIgnoreCase("Password")) {
                if (value == null || value.trim().equals("")) {
                    this.msgVector.add(ErrorMsgManager.getLocalizedString((int)12502, (Object[])new String[]{myName, itemName}));
                    continue;
                }
                String decodedValue = Base64Coder.decode(value);
                if (decodedValue.length() < 7) {
                    this.msgVector.add(ErrorMsgManager.getLocalizedString((int)12502, (Object[])new String[]{myName, itemName}));
                    continue;
                }
            }
            if (confItemPane.getType() != null && confItemPane.getType().equalsIgnoreCase("Integer") && value != null && !value.trim().equals("")) {
                try {
                    Integer.parseInt(value.trim());
                }
                catch (Exception e) {
                    this.msgVector.add("Integer value must be set for : [" + myName + "]" + " " + itemName);
                    continue;
                }
            }
            if (confItemPane.getType() != null && confItemPane.getType().equalsIgnoreCase("Long") && value != null && !value.trim().equals("")) {
                try {
                    Long.parseLong(value.trim());
                }
                catch (Exception e) {
                    this.msgVector.add("Long value must be set for : [" + myName + "]" + " " + itemName);
                    continue;
                }
            }
            if (confItemPane.getType() != null && confItemPane.getType().equalsIgnoreCase("Float") && value != null && !value.trim().equals("")) {
                try {
                    Float.parseFloat(value.trim());
                }
                catch (Exception e) {
                    this.msgVector.add("Float value must be set for : [" + myName + "]" + " " + itemName);
                    continue;
                }
            }
            if (confItemPane.getType() != null && confItemPane.getType().equals("Empty")) {
                if (confItemPane.getValue() == null || !confItemPane.getValue().equals("true")) continue;
                this.myTree.addElement(new XMLTree(itemName));
                continue;
            }
            elementTree.setValue(value);
            if (XMLOptionParameter.SHOW_DEFAULT_XML) {
                this.myTree.addElement(elementTree);
                continue;
            }
            if (value.equals(defaultValue)) continue;
            this.myTree.addElement(elementTree);
        }
        if (thereIsRequiredField && !someRequiredFieldSet) {
            this.myTree.clear();
        }
        ConfigContainer[] subContainers = this.mySchema.getConfigContainer();
        for (int j = 0; subContainers != null && j < subContainers.length; ++j) {
            ConfigContainer subContainer = subContainers[j];
            String containerName = subContainer.getName();
            String isRequired = subContainer.getRequired();
            if (subContainer.getMulti() != null && subContainer.getMulti().equals("true")) {
                MultiConfigList newMultiPanel = null;
                if (subContainer instanceof ConfigExclusiveContainer) {
                    String oneSubContainerName = subContainer.getConfigContainer(0).getName();
                    newMultiPanel = (MultiConfigList)this.configManagerList.getPanel(oneSubContainerName);
                    if (newMultiPanel == null) {
                        newMultiPanel = (MultiConfigList)this.configManagerList.getPanel(oneSubContainerName);
                    }
                } else {
                    newMultiPanel = (MultiConfigList)this.configManagerList.getPanel(containerName);
                    if (newMultiPanel == null) {
                        newMultiPanel = (MultiConfigList)this.configManagerList.getPanel(containerName);
                    }
                }
                Vector multiValue = (Vector)newMultiPanel.getValue();
                if (multiValue == null) {
                    if (subContainer.getRequired() == null || !subContainer.getRequired().equals("true")) continue;
                    this.msgVector.add(ErrorMsgManager.getLocalizedString((int)12501, (Object[])new String[]{containerName}));
                    continue;
                }
                this.myTree.addElements(multiValue);
                Vector multimsg = newMultiPanel.getMessage();
                if (multimsg == null) continue;
                this.msgVector.addAll(multimsg);
                continue;
            }
            if (subContainer.getType() != null && subContainer.getType().equals("Double")) {
                DoubleConfigPanel doublePane = (DoubleConfigPanel)this.configManagerList.getPanel(containerName);
                Vector doubleValue = (Vector)doublePane.getValue();
                if (doubleValue == null) {
                    if (subContainer.getRequired() == null || !subContainer.getRequired().equals("true")) continue;
                    this.msgVector.add(ErrorMsgManager.getLocalizedString((int)12501, (Object[])new String[]{containerName}));
                    continue;
                }
                if (doubleValue == null) continue;
                this.myTree.addElements(doubleValue);
                continue;
            }
            if (subContainer instanceof ConfigExclusiveContainer) {
                String oneSubContainerName = subContainer.getAnySubName();
                if (oneSubContainerName == null) continue;
                ExclusiveConfigPanel exPane = (ExclusiveConfigPanel)this.configManagerList.getPanel(oneSubContainerName);
                Object exPaneValue = exPane.getValue();
                if (exPaneValue != null) {
                    if (exPaneValue instanceof Vector) {
                        Vector exVector = (Vector)exPaneValue;
                        this.myTree.addElements(exVector);
                        continue;
                    }
                    if (!(exPaneValue instanceof XMLTree)) continue;
                    XMLTree exTree = (XMLTree)exPaneValue;
                    this.myTree.addElement(exPane.getValue());
                    continue;
                }
                if (isRequired == null || !isRequired.equals("true")) continue;
                this.msgVector.add(ErrorMsgManager.getLocalizedString((int)12500, (Object[])new String[]{myName, oneSubContainerName}));
                continue;
            }
            ConfigContainerPanel newPanel = (ConfigContainerPanel)this.configManagerList.getPanel(containerName);
            if (newPanel == null) {
                newPanel = (ConfigContainerPanel)this.configManagerList.getPanel(containerName);
            }
            XMLTree newTree = (XMLTree)newPanel.getValue();
            Vector newMessage = newPanel.getMessage();
            if (newTree != null) {
                this.myTree.addElement(newTree);
                if (newMessage == null) continue;
                this.msgVector.addAll(newMessage);
                continue;
            }
            if (isRequired == null || !isRequired.equals("true") || newMessage == null) continue;
            this.msgVector.addAll(newMessage);
        }
        if (this.myTree.getElementCount() == 0 && this.myTree.getAttributeCount() == 0) {
            if (this.myTree.getName() != null && this.myTree.getName().equals("method-params")) {
                return this.myTree;
            }
            return null;
        }
        return this.myTree;
    }

    public void createConfig() {
        this.getValue();
    }

    public Object getValueTopTree() {
        Object value = this.getValue();
        if (value == null) {
            String myName = this.mySchema.getName();
            this.myTree = new XMLTree(myName);
            return this.myTree;
        }
        return value;
    }

    public Object getValue() {
        XMLTree val = null;
        try {
            val = this.getConfigurationValue();
        }
        catch (XMLConverterException e) {
            String msg = ErrorMsgManager.getLocalizedString((Throwable)((Object)e));
            System.out.println(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    public void setValue(Object val) {
        if (val instanceof XMLTree) {
            XMLTree valTree = (XMLTree)val;
            this.setConfigurationValue(valTree);
            this.setConfigObject(valTree);
        }
    }

    public void setMultiChildPanel(ConfigContainerPanel mc) {
        this.multiChildPanel = mc;
    }

    public ConfigContainerPanel getMultiChildPanel() {
        return this.multiChildPanel;
    }

    public void setInitComplex(ConfigContainer anyConfig) {
    }

    public void setMultiChildPanel(ConfigContainer anyConfig) {
        anyConfig.setMulti("false");
        this.multiChildPanel = this.createConfigContainerPanel(anyConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitExclusiveSingle(ConfigContainer anyConfig) {
        ExclusiveConfigPanel exPane = null;
        if (anyConfig.getContainerUIClass() != null && !anyConfig.getContainerUIClass().trim().equals("")) {
            try {
                String uri = anyConfig.getContainerUIClass();
                Class<?> containerPanelClass = Class.forName(uri);
                Constructor<?> c = containerPanelClass.getConstructor(ConfigContainer.class);
                exPane = (ExclusiveConfigPanel)c.newInstance(anyConfig);
            }
            catch (ClassNotFoundException e) {
                System.out.println("class not found : " + anyConfig.getContainerUIClass());
            }
            catch (InstantiationException e2) {
                System.out.println("class instantiation error : " + anyConfig.getContainerUIClass());
            }
            catch (IllegalAccessException e3) {
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            finally {
                if (exPane == null) {
                    exPane = new ExclusiveConfigPanel(anyConfig);
                }
            }
        } else {
            exPane = new ExclusiveConfigPanel(anyConfig);
        }
        ConfigItem[] subItems = anyConfig.getConfigItem();
        for (int i = 0; i < subItems.length; ++i) {
            this.configManagerList.setPanel(subItems[i].getName(), exPane);
        }
        ConfigContainer[] subContainers = anyConfig.getConfigContainer();
        for (int j = 0; j < subContainers.length; ++j) {
            this.configManagerList.setPanel(subContainers[j].getName(), exPane);
        }
        exPane.prepareResources(anyConfig);
        ++this.pane_xml_y;
        this.addConfigPane(anyConfig, exPane, this.xml_x_max, 1, 0, this.pane_xml_y);
    }

    public void setInitDouble(ConfigContainer anyConfig) {
        DoubleConfigPanel doublePane = new DoubleConfigPanel(anyConfig);
        doublePane.prepareResources(anyConfig);
        ++this.pane_xml_y;
        this.configManagerList.setPanel(anyConfig.getName(), doublePane);
        this.basicPane.add((Component)doublePane, new GridBagConstraints(0, this.pane_xml_y, this.xml_x_max, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitExclusiveMulti(ConfigContainer anyConfig) {
        ConfigContainer childConfig = anyConfig.cloneMe();
        childConfig.setMulti("false");
        MultiConfigList mList = null;
        if (anyConfig.getContainerUIClass() != null && !anyConfig.getContainerUIClass().trim().equals("")) {
            try {
                String uri = anyConfig.getContainerUIClass();
                Class<?> containerPanelClass = Class.forName(uri);
                Constructor<?> c = containerPanelClass.getConstructor(ConfigContainer.class);
                mList = (MultiConfigList)c.newInstance(childConfig);
            }
            catch (ClassNotFoundException e) {
                System.out.println("class not found : " + anyConfig.getContainerUIClass());
            }
            catch (InstantiationException e2) {
                System.out.println("class instantiation error : " + anyConfig.getContainerUIClass());
            }
            catch (IllegalAccessException e3) {
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            finally {
                if (mList == null) {
                    mList = new MultiConfigList(childConfig);
                }
            }
        } else {
            mList = new MultiConfigList(childConfig);
        }
        ++this.pane_xml_y;
        ConfigItem[] subItems = childConfig.getConfigItem();
        for (int i = 0; i < subItems.length; ++i) {
            this.configManagerList.setPanel(subItems[i].getName(), mList);
        }
        ConfigContainer[] subContainers = childConfig.getConfigContainer();
        for (int j = 0; j < subContainers.length; ++j) {
            this.configManagerList.setPanel(subContainers[j].getName(), mList);
        }
        mList.prepareResources(anyConfig);
        this.addConfigPane(anyConfig, mList, this.xml_x_max, 1, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitMulti(ConfigContainer anyConfig) {
        ConfigContainer childConfig = anyConfig.cloneMe();
        childConfig.setMulti("false");
        MultiConfigList mList = null;
        if (anyConfig.getContainerUIClass() != null && !anyConfig.getContainerUIClass().trim().equals("")) {
            try {
                String uri = anyConfig.getContainerUIClass();
                Class<?> containerPanelClass = Class.forName(uri);
                Constructor<?> c = containerPanelClass.getConstructor(ConfigContainer.class);
                mList = (MultiConfigList)c.newInstance(childConfig);
            }
            catch (ClassNotFoundException e) {
                System.out.println("class not found : " + anyConfig.getContainerUIClass());
            }
            catch (InstantiationException e2) {
                System.out.println("class instantiation error : " + anyConfig.getContainerUIClass());
            }
            catch (IllegalAccessException e3) {
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            finally {
                if (mList == null) {
                    mList = new MultiConfigList(childConfig);
                }
            }
        } else {
            mList = new MultiConfigList(childConfig);
        }
        mList.prepareResources(anyConfig);
        ++this.pane_xml_y;
        this.configManagerList.setPanel(anyConfig.getName(), mList);
        this.addConfigPane(anyConfig, mList, this.xml_x_max, 1, 0, 0);
    }

    public void setInitSubItems(ConfigItem[] subItems) {
        for (int i = 0; i < subItems.length; ++i) {
            JLabel itemLB;
            ConfigItem subItem = subItems[i];
            if (this.externalID != null) {
                subItem.setGlobalID(this.externalID);
            }
            String itemName = subItem.getName();
            String itemDisplayName = subItem.getDisplayName();
            String itemType = subItem.getItemType();
            String defaultValue = subItem.getDefaultValue();
            String isMulti = subItem.getMulti();
            String required = subItem.getRequired();
            if (isMulti != null && isMulti.equals("true")) {
                MultiItemTable mTable = new MultiItemTable();
                String multiItemDisplay = itemName;
                if (itemDisplayName != null && !itemDisplayName.trim().equals("")) {
                    multiItemDisplay = itemDisplayName;
                }
                mTable.setTitle(multiItemDisplay);
                String[] colNames = new String[]{multiItemDisplay};
                mTable.setColumnNames(colNames);
                this.configManagerList.setPanel(itemName, mTable);
                ++this.pane_xml_y;
                this.basicPane.add((Component)mTable, new GridBagConstraints(0, this.pane_xml_y, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
                continue;
            }
            if (defaultValue == null || defaultValue.equals("")) {
                defaultValue = null;
            }
            String[] candValues = new String[]{};
            if (itemType != null && itemType.endsWith("Choice")) {
                candValues = subItem.getCandidateValue();
            }
            String labelName = "";
            labelName = itemDisplayName != null && !itemDisplayName.trim().equals("") ? itemDisplayName : itemName;
            if (required != null && required.equals("true")) {
                itemLB = new JLabel(labelName + " *");
                itemLB.setForeground(this.REQUIRED_COLOR);
            } else {
                itemLB = new JLabel(labelName);
            }
            JComponent itemValueCmp = null;
            if (itemType == null) {
                itemType = "String";
            }
            if (itemType.equals("Boolean")) {
                itemValueCmp = new JCheckBox();
                if (defaultValue != null && defaultValue.equals("true")) {
                    ((AbstractButton)itemValueCmp).setSelected(true);
                }
            } else if (itemType.endsWith("Choice")) {
                itemValueCmp = new JComboBox();
                for (int j = 0; j < candValues.length; ++j) {
                    ((JComboBox)itemValueCmp).addItem(candValues[j]);
                    if (defaultValue == null) continue;
                    ((JComboBox)itemValueCmp).setSelectedItem(defaultValue);
                }
                if (itemType.startsWith("Editable")) {
                    ((JComboBox)itemValueCmp).setEditable(true);
                }
            } else if (itemType.equals("Empty")) {
                itemValueCmp = new JCheckBox();
            } else if (itemType.equals("Password")) {
                itemValueCmp = new JPasswordField();
            } else if (itemType.equals("TextArea") || itemName.equals("description")) {
                itemValueCmp = new ScrollableTextArea(3, 1);
                itemValueCmp.setSize(1, 35);
            } else {
                itemValueCmp = new JTextField();
                if (defaultValue != null) {
                    ((JTextField)itemValueCmp).setText(defaultValue);
                }
            }
            ConfigItemPanel itemPanel = new ConfigItemPanel(itemValueCmp);
            itemPanel.setType(itemType);
            itemPanel.setDefaultValue(defaultValue);
            this.configManagerList.setPanel(itemName, itemPanel);
            ++this.pane_xml_y;
            this.basicPane.add((Component)itemLB, new GridBagConstraints(0, this.pane_xml_y, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.basicPane.add((Component)itemPanel, new GridBagConstraints(1, this.pane_xml_y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitSimple(ConfigContainer anyConfig) {
        ConfigItem[] subItems;
        if (anyConfig.getTabListenerClass() != null && !anyConfig.getTabListenerClass().trim().equals("")) {
            try {
                String uri = anyConfig.getTabListenerClass();
                Class<?> tabListenerClass = Class.forName(uri);
                Constructor<?> c = tabListenerClass.getConstructor(ConfigContainerPanel.class);
                ChangeListener myListener = (ChangeListener)c.newInstance(this);
                this.tabPane.addChangeListener(myListener);
            }
            catch (ClassNotFoundException e) {
                System.out.println("class not found : " + anyConfig.getTabListenerClass());
            }
            catch (InstantiationException e2) {
                System.out.println("class instantiation error : " + anyConfig.getTabListenerClass());
            }
            catch (IllegalAccessException e3) {
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
        ConfigContainer[] subContainers = anyConfig.getConfigContainer();
        boolean doubleContainer = false;
        if (subContainers != null && subContainers.length > 0) {
            for (int i = 0; i < subContainers.length; ++i) {
                if (subContainers[i].getType() == null || !subContainers[i].getType().equals("Double")) continue;
                doubleContainer = true;
                break;
            }
        }
        if (subContainers == null || subContainers.length == 0 || doubleContainer) {
            subItems = anyConfig.getConfigItem();
            if (subItems.length > 0) {
                this.setInitSubItems(subItems);
                if (anyConfig.getParentLayOut() == null || !anyConfig.getParentLayOut().equals("Flat")) {
                    ++this.pane_xml_y;
                    this.basicPane.add(Box.createVerticalGlue(), new GridBagConstraints(0, this.pane_xml_y, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 5, 5), 0, 0));
                }
            }
            if (doubleContainer) {
                ++this.pane_xml_y;
                this.setInitSubContainers(subContainers, this.pane_xml_y);
            }
        } else {
            subItems = anyConfig.getConfigItem();
            ConfigContainer generalContainer = null;
            ConfigContainer[] allContainers = anyConfig.getConfigContainer();
            if (subItems.length > 0) {
                int i;
                generalContainer = new ConfigContainer();
                generalContainer.setName("$general$");
                generalContainer.setSmallIcon(anyConfig.getGeneralSmallIcon());
                generalContainer.setBigIcon(anyConfig.getGeneralBigIcon());
                for (i = 0; i < subItems.length; ++i) {
                    generalContainer.addConfigItem(subItems[i]);
                }
                allContainers = new ConfigContainer[subContainers.length + 1];
                allContainers[0] = generalContainer;
                for (i = 0; i < subContainers.length; ++i) {
                    allContainers[i + 1] = subContainers[i];
                }
            }
            ++this.pane_xml_y;
            this.setInitSubContainers(allContainers, this.pane_xml_y);
        }
    }

    public void setInitSubContainers(ConfigContainer[] subContainers, int y_index) {
        this.beginInitSubContainers(subContainers);
        for (int i = 0; i < subContainers.length; ++i) {
            ConfigContainer subContainer = subContainers[i];
            if (this.externalID != null) {
                subContainer.setGlobalID(this.externalID);
            }
            ConfigContainerPanel configPanel = null;
            if (subContainer.getMulti() != null && subContainer.getMulti().equals("true")) {
                if (subContainer instanceof ConfigExclusiveContainer) {
                    this.setInitExclusiveMulti(subContainer);
                    continue;
                }
                this.setInitMulti(subContainer);
                continue;
            }
            if (subContainer.getType() != null && subContainer.getType().equals("Double")) {
                this.setInitDouble(subContainer);
                continue;
            }
            if (subContainer instanceof ConfigExclusiveContainer) {
                this.setInitExclusiveSingle(subContainer);
                continue;
            }
            configPanel = this.createConfigContainerPanel(subContainer);
            this.configManagerList.setPanel(subContainer.getName(), configPanel);
            this.addConfigPane(subContainer, configPanel, this.xml_x_max, 1, 0, y_index);
        }
        this.endInitSubContainers(subContainers, 0, y_index, this.xml_x_max, 1);
    }

    protected ConfigContainerPanel createConfigContainerPanel(ConfigContainer subContainer) {
        return ConfigContainerPanel.createConfigContainerPanel(subContainer, false);
    }

    public static ConfigContainerPanel createConfigContainerPanel(ConfigContainer subContainer, boolean sub) {
        ConfigPanel configPanel = null;
        try {
            String uiclass = null;
            uiclass = sub ? subContainer.getContainerUIClass() : subContainer.getSubContainerUIClass();
            Class<?> containerPanelClass = Class.forName(uiclass);
            Constructor<?> c = containerPanelClass.getConstructor(ConfigContainer.class);
            configPanel = (ConfigContainerPanel)c.newInstance(subContainer);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (configPanel == null) {
            String layout = null;
            layout = !sub ? subContainer.getLayOut() : subContainer.getSubLayOut();
            configPanel = layout.equals("Tab") ? new ConfigContainerPanel(subContainer) : (layout.equals("List") ? new ListConfigContainerPanel(subContainer) : new FlatConfigContainerPanel(subContainer));
        }
        configPanel.prepareResources(subContainer);
        return configPanel;
    }

    public void isItOneSubContainer(ConfigContainer anyConfig) {
        if (anyConfig.getConfigItem() == null || anyConfig.getConfigContainer() == null) {
            return;
        }
        if (anyConfig.getConfigItem().length == 0 && anyConfig.getConfigContainer().length == 1) {
            this._OnlyOneSubContainer = true;
            return;
        }
        this._OnlyOneSubContainer = false;
    }

    protected void addConfigPane(ConfigContainer subContainer, ConfigPanel newPanel, int colspan, int rowspan, int x, int y) {
        if (!this._OnlyOneSubContainer) {
            if (newPanel.getSmallIcon() != null) {
                this.tabPane.addTab(subContainer.getDisplayName(), newPanel.getSmallIcon(), newPanel);
            } else {
                this.tabPane.addTab(subContainer.getDisplayName(), newPanel);
            }
        } else {
            this.basicPane.add((Component)newPanel, new GridBagConstraints(x, y, colspan, rowspan, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    protected void beginInitSubContainers(ConfigContainer[] subContainers) {
    }

    protected void endInitSubContainers(ConfigContainer[] subContainers, int x, int y, int colspan, int rowspan) {
        if (!this._OnlyOneSubContainer && this.tabPane.getTabCount() > 0) {
            this.basicPane.add((Component)this.tabPane, new GridBagConstraints(x, y, colspan, rowspan, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    public void setInit(ConfigContainer anyConfig) throws Exception {
        this.mySchema = anyConfig;
        this.setLayout(new BorderLayout());
        if (anyConfig == null) {
            return;
        }
        this.basicPane.setLayout(new GridBagLayout());
        this.isItOneSubContainer(anyConfig);
        this.setInitSimple(anyConfig);
    }
}

