/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jeus.tool.common.ConfigDialog;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.configui.ConfigContainerPanel;
import jeus.tool.configui.ConfigPanel;
import jeus.tool.configui.DefaultColumnParser;
import jeus.tool.configui.IColumnParser;
import jeus.tool.configui.TypeSelectPane;
import jeus.tool.configui.schema.ConfigContainer;
import jeus.tool.configui.schema.ConfigExclusiveContainer;

public class MultiConfigList
extends ConfigPanel
implements ActionListener,
ListSelectionListener {
    TitledBorder titledBorder1;
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable displayTable = new JTable();
    XMLTreeTableModel tableModel;
    public JButton removeBT = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    public JButton addBT = new JButton();
    public JButton modifyBT = new JButton();
    protected String title = "List Display Pane";
    private boolean isDuplicationEnabled = true;
    public static final String ADD = "Add";
    public static final String MODIFY = "Modify";
    public int mode = 0;
    public static final int EDIT_MODE = 0;
    public static final int BROWSE_MODE = 1;
    public boolean removeDisable = false;
    protected ConfigContainer configContainer;
    protected ArrayList exclusiveList = new ArrayList();
    protected ArrayList exclusiveContainers = new ArrayList();

    protected void init(String title) {
        this.title = title;
        this.addActionListenerToAddCommand(this);
        this.addActionListenerToModifyCommand(this);
        this.addActionListenerToRemoveCommand(this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MultiConfigList() {
        this.init(null);
    }

    public MultiConfigList(String title) {
        this.init(title);
    }

    public boolean isExclusive() {
        return this.exclusiveList.size() > 0;
    }

    public MultiConfigList(ConfigContainer anyConfig) {
        ConfigContainer[] exclusiveContainerList;
        this.configContainer = anyConfig;
        if (anyConfig instanceof ConfigExclusiveContainer && (exclusiveContainerList = anyConfig.getConfigContainer()) != null) {
            for (int j = 0; j < exclusiveContainerList.length; ++j) {
                this.exclusiveList.add(exclusiveContainerList[j].getName());
                exclusiveContainerList[j].setGlobalID(anyConfig.getGlobalID());
                this.exclusiveContainers.add(exclusiveContainerList[j]);
            }
        }
        this.init(anyConfig.getName());
    }

    public Object getValue() {
        Object[] vals = this.getValues();
        if (vals == null || vals.length == 0) {
            return null;
        }
        Vector<Object> treeList = new Vector<Object>();
        for (int i = 0; i < vals.length; ++i) {
            treeList.add(vals[i]);
        }
        return treeList;
    }

    public Vector getMessage() {
        return null;
    }

    public void clear() {
        if (this.tableModel != null) {
            this.tableModel.clear();
        }
    }

    public void resetValue() {
        this.clear();
    }

    public void setValue(Object val) {
        this.clear();
        if (val instanceof Vector) {
            Vector valueList = (Vector)val;
            Enumeration enum1 = valueList.elements();
            while (enum1.hasMoreElements()) {
                XMLTree itemTree = (XMLTree)enum1.nextElement();
                this.addItem(itemTree);
            }
        }
    }

    public void setValueFinish() {
    }

    public void setValueExclusive(Object val) {
        if (val instanceof Vector) {
            Vector valueList = (Vector)val;
            Enumeration enum1 = valueList.elements();
            while (enum1.hasMoreElements()) {
                String elementName;
                XMLTree itemTree = (XMLTree)enum1.nextElement();
                if (this.configContainer != null && (elementName = this.configContainer.getMultiDisplayName()) != null) {
                    itemTree.setDisplayItemName(elementName);
                }
                this.addItem(itemTree);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addBT) {
            this.add();
        } else if (e.getSource() == this.modifyBT) {
            this.modify();
        } else if (e.getSource() == this.removeBT) {
            if (this.removeDisable) {
                this.removeNothing();
            } else {
                this.remove();
            }
        }
    }

    public void add(ConfigContainer selectedConfig) {
        String elementName;
        ConfigContainerPanel pane = ConfigContainerPanel.createConfigContainerPanel(selectedConfig, true);
        pane.setTitle(this.configContainer.getName());
        ConfigDialog dlg = new ConfigDialog(pane);
        dlg.setCustomizeErrorDlg();
        boolean returnVal = dlg.showDialog();
        if (!dlg.getOk()) {
            return;
        }
        XMLTree oneChildXML = (XMLTree)dlg.getConfig();
        if (this.configContainer != null && (elementName = selectedConfig.getMultiDisplayName()) != null) {
            oneChildXML.setDisplayItemName(elementName);
        }
        this.addItem(oneChildXML);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add() {
        String elementName;
        if (this.exclusiveList != null && this.exclusiveList.size() > 0) {
            this.addExclusive();
            return;
        }
        ConfigContainerPanel pane = ConfigContainerPanel.createConfigContainerPanel(this.configContainer, true);
        pane.setTitle(this.configContainer.getName());
        ConfigDialog dlg = new ConfigDialog(pane);
        dlg.setCustomizeErrorDlg();
        boolean returnVal = dlg.showDialog();
        if (returnVal) {
            return;
        }
        XMLTree oneChildXML = (XMLTree)dlg.getConfig();
        if (this.configContainer != null && (elementName = this.configContainer.getMultiDisplayName()) != null) {
            oneChildXML.setDisplayItemName(elementName);
        }
        if (this.configContainer.getType() != null && this.configContainer.getType().equals("Unique")) {
            String displayValue = oneChildXML.toString();
            boolean isExist = false;
            Object[] list = this.getValues();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    XMLTree oneElement = (XMLTree)list[i];
                    if (displayValue == null || !displayValue.equals(oneElement.toString())) continue;
                    isExist = true;
                }
            }
            if (!isExist) {
                this.addItem(oneChildXML);
                return;
            }
            JOptionPane.showMessageDialog(this, "Item (" + displayValue + ") already exist!");
            return;
        }
        this.addItem(oneChildXML);
    }

    public void addExclusive() {
        TypeSelectPane pane = new TypeSelectPane(this.exclusiveList);
        pane.setTitle("Type Selection Dialog");
        ConfigDialog dlg = new ConfigDialog(pane);
        dlg.setCustomizeErrorDlg();
        boolean returnVal = dlg.showDialog();
        if (!dlg.getOk()) {
            return;
        }
        Integer selectionIndex = (Integer)dlg.getConfig();
        this.add((ConfigContainer)this.exclusiveContainers.get(selectionIndex));
    }

    public void modifyExclusive() {
        String elementName;
        Object object = this.getSelectedValue();
        if (object == null) {
            return;
        }
        int index = this.getSelectedIndex();
        XMLTree oneChildXML = (XMLTree)object;
        if (oneChildXML.getName() == null) {
            return;
        }
        int typeIndex = this.exclusiveList.indexOf(oneChildXML.getName());
        if (typeIndex == -1) {
            typeIndex = 0;
        }
        ConfigContainer selectedConfig = (ConfigContainer)this.exclusiveContainers.get(typeIndex);
        ConfigContainerPanel pane = ConfigContainerPanel.createConfigContainerPanel(selectedConfig, true);
        pane.setValue(oneChildXML);
        pane.setTitle(selectedConfig.getName());
        ConfigDialog dlg = new ConfigDialog(pane);
        dlg.setCustomizeErrorDlg();
        boolean returnVal = dlg.showDialog();
        if (!dlg.getOk()) {
            return;
        }
        oneChildXML = (XMLTree)dlg.getConfig();
        if (selectedConfig != null && (elementName = selectedConfig.getMultiDisplayName()) != null) {
            oneChildXML.setDisplayItemName(elementName);
        }
        this.modifyValueAt(index, oneChildXML);
    }

    public void modify() {
        if (this.exclusiveList != null && this.exclusiveList.size() > 0) {
            this.modifyExclusive();
        } else {
            String elementName;
            Object object = this.getSelectedValue();
            if (object == null) {
                return;
            }
            int index = this.getSelectedIndex();
            XMLTree oneChildXML = (XMLTree)object;
            ConfigContainerPanel pane = ConfigContainerPanel.createConfigContainerPanel(this.configContainer, true);
            pane.setValue(oneChildXML);
            pane.setTitle(this.configContainer.getName());
            ConfigDialog dlg = new ConfigDialog(pane);
            dlg.setCustomizeErrorDlg();
            boolean returnVal = dlg.showDialog();
            if (!dlg.getOk()) {
                return;
            }
            oneChildXML = (XMLTree)dlg.getConfig();
            if (this.configContainer != null && (elementName = this.configContainer.getMultiDisplayName()) != null) {
                oneChildXML.setDisplayItemName(elementName);
            }
            this.modifyValueAt(index, oneChildXML);
        }
    }

    public void removeNothing() {
    }

    public void setListDisabled() {
        this.addBT.setEnabled(false);
        this.modifyBT.setEnabled(false);
        this.removeBT.setEnabled(false);
    }

    public void setListEnabled() {
        this.addBT.setEnabled(true);
        this.modifyBT.setEnabled(true);
        this.removeBT.setEnabled(true);
    }

    public void setDuplicationEnabled(boolean isDuplicationEnabled) {
        this.isDuplicationEnabled = isDuplicationEnabled;
    }

    public void addActionListenerToAddCommand(ActionListener listener) {
        this.addBT.addActionListener(listener);
    }

    public void addActionListenerToModifyCommand(ActionListener listener) {
        this.modifyBT.addActionListener(listener);
    }

    public void addActionListenerToRemoveCommand(ActionListener listener) {
        this.removeBT.addActionListener(listener);
    }

    public void removeModifyButton() {
        this.remove(this.modifyBT);
    }

    public void setModificationEnabled(boolean isModificationEnabled) {
        this.modifyBT.setVisible(isModificationEnabled);
        this.modifyBT.setEnabled(isModificationEnabled);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.removeBT.setMaximumSize(new Dimension(79, 29));
        this.removeBT.setText("Remove");
        this.addBT.setText(ADD);
        this.modifyBT.setText(MODIFY);
        String columnParser = this.configContainer.getMultiColumnParser();
        if (columnParser != null && columnParser.trim().length() > 0) {
            try {
                IColumnParser parser = (IColumnParser)Class.forName(columnParser).newInstance();
                this.tableModel = new XMLTreeTableModel(this.configContainer, parser);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.tableModel == null) {
            this.tableModel = new XMLTreeTableModel(this.configContainer);
        }
        this.displayTable.setModel(this.tableModel);
        this.displayTable.getSelectionModel().addListSelectionListener(this);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 131));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.removeBT, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.addBT, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.modifyBT, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.displayTable, null);
        this.modifyBT.setEnabled(false);
        this.removeBT.setEnabled(false);
    }

    public void modifyPreferredSize(Dimension dim) {
        this.jScrollPane1.setPreferredSize(dim);
    }

    public void setBrowseMode() {
        this.addBT.setEnabled(false);
        this.removeBT.setEnabled(false);
        this.modifyBT.setText("Browse");
        this.mode = 1;
    }

    public void remove() {
        int[] rows = this.displayTable.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.removeElement(rows[i]);
        }
    }

    public void removeElement(int i) {
        this.tableModel.removeRow(i);
        if (this.tableModel.getSize() == 0) {
            this.removeBT.setEnabled(false);
            this.modifyBT.setEnabled(false);
        }
    }

    public boolean addItem(Object object) {
        if (!this.isDuplicationEnabled && this.existInList(object)) {
            return false;
        }
        this.tableModel.addXMLTree((XMLTree)object);
        return true;
    }

    public Object[] getSelectedValues() {
        ArrayList<XMLTree> values = new ArrayList<XMLTree>();
        int[] rows = this.displayTable.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            values.add(this.tableModel.get(rows[i]));
        }
        return values.toArray();
    }

    public Object getSelectedValue() {
        int row = this.displayTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.tableModel.get(row);
    }

    public Object getValueAt(int index) {
        return this.tableModel.get(index);
    }

    public boolean existInList(Object object) {
        return this.tableModel.contains((XMLTree)object);
    }

    public int getItemCount() {
        return this.tableModel.getSize();
    }

    public Object[] getValues() {
        return this.tableModel.toArray();
    }

    public void modifyValueAt(int index, Object object) {
        this.tableModel.addXMLTree((XMLTree)object, index);
    }

    public int getSelectedIndex() {
        return this.displayTable.getSelectedRow();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.modifyBT.setEnabled(true);
        this.removeBT.setEnabled(true);
    }

    public static class XMLTreeTableModel
    extends DefaultTableModel {
        private ArrayList trees = new ArrayList();
        private IColumnParser columnParser;
        private ConfigContainer cc;

        public XMLTreeTableModel(ConfigContainer cc) {
            this(cc, new DefaultColumnParser());
        }

        public XMLTreeTableModel(ConfigContainer cc, IColumnParser columnParser) {
            this.cc = cc;
            this.columnParser = columnParser;
            String[] columns = columnParser.getColumns(cc);
            for (int i = 0; i < columns.length; ++i) {
                this.addColumn(columns[i]);
            }
        }

        public void addXMLTree(XMLTree xmlTree, int index) {
            this.trees.remove(index);
            this.trees.add(index, xmlTree);
            if (index >= this.getRowCount()) {
                this.addRow(this.columnParser.getRow(this.cc, xmlTree));
            } else {
                String[] data = this.columnParser.getRow(this.cc, xmlTree);
                for (int i = 0; i < data.length; ++i) {
                    this.setValueAt(data[i], index, i);
                }
            }
        }

        public void addXMLTree(XMLTree xmlTree) {
            this.trees.add(xmlTree);
            this.addRow(this.columnParser.getRow(this.cc, xmlTree));
        }

        public boolean contains(XMLTree xmlTree) {
            return this.trees.contains(xmlTree);
        }

        public Object[] toArray() {
            return this.trees.toArray();
        }

        public void clear() {
            this.trees.clear();
        }

        public int getSize() {
            return this.trees.size();
        }

        public void removeRow(int row) {
            this.trees.remove(row);
            super.removeRow(row);
        }

        public XMLTree get(int index) {
            if (this.trees.size() > index) {
                return (XMLTree)this.trees.get(index);
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

