/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.common;

import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.util.message.JeusMessage_Converter;

public class ValidString {
    public static final int INT = 0;
    public static final int FLOAT = 1;
    public static final int BOOLEAN = 2;
    public static final int LONG = 3;
    public static final int DOUBLE = 4;

    public static Object getProperTypeFromString(XMLTree xmlTree, String elementName, int type, boolean required, String defaultValue) throws XMLConverterException {
        String value = null;
        value = defaultValue != null ? XMLUtil.getSubtreeValueDefault(xmlTree, elementName, defaultValue) : XMLUtil.getSubtreeValue(xmlTree, elementName);
        if (required && !ValidString.notEmptyString(value)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, elementName);
        }
        if (value == null || value.equals("")) {
            return null;
        }
        try {
            switch (type) {
                case 0: {
                    return Integer.valueOf(value);
                }
                case 1: {
                    return Float.valueOf(value);
                }
                case 2: {
                    return Boolean.valueOf(value);
                }
                case 3: {
                    return Long.valueOf(value);
                }
                case 4: {
                    return Double.valueOf(value);
                }
            }
            return null;
        }
        catch (NumberFormatException ex) {
            throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{elementName, ValidString.convertString(type)});
        }
    }

    private static String convertString(int type) {
        switch (type) {
            case 0: {
                return "int";
            }
            case 1: {
                return "float";
            }
            case 2: {
                return "boolean";
            }
            case 3: {
                return "long";
            }
            case 4: {
                return "double";
            }
        }
        return null;
    }

    public static boolean notEmptyString(String string) {
        return string != null && !string.trim().equals("");
    }

    public static String restrictChoice(String tagName, String target, String choice1, String choice2) throws XMLConverterException {
        if (target.equalsIgnoreCase(choice1)) {
            return choice1;
        }
        if (target.equalsIgnoreCase(choice2)) {
            return choice2;
        }
        throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{tagName, choice1 + "|" + choice2});
    }

    public static String restrictChoice(String tagName, String target, String choice1, String choice2, String choice3) throws XMLConverterException {
        if (target.equalsIgnoreCase(choice1)) {
            return choice1;
        }
        if (target.equalsIgnoreCase(choice2)) {
            return choice2;
        }
        if (target.equalsIgnoreCase(choice3)) {
            return choice3;
        }
        throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{tagName, choice1 + "|" + choice2 + "|" + choice3});
    }

    public static String restrictChoice(String tagName, String target, String choice1, String choice2, String choice3, String choice4) throws XMLConverterException {
        if (target.equalsIgnoreCase(choice1)) {
            return choice1;
        }
        if (target.equalsIgnoreCase(choice2)) {
            return choice2;
        }
        if (target.equalsIgnoreCase(choice3)) {
            return choice3;
        }
        if (target.equalsIgnoreCase(choice4)) {
            return choice4;
        }
        throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{tagName, choice1 + "|" + choice2 + "|" + choice3 + "|" + choice4});
    }

    public static String restrictChoice(String tagName, String target, String choice1, String choice2, String choice3, String choice4, String choice5) throws XMLConverterException {
        if (target.equalsIgnoreCase(choice1)) {
            return choice1;
        }
        if (target.equalsIgnoreCase(choice2)) {
            return choice2;
        }
        if (target.equalsIgnoreCase(choice3)) {
            return choice3;
        }
        if (target.equalsIgnoreCase(choice4)) {
            return choice4;
        }
        if (target.equalsIgnoreCase(choice5)) {
            return choice5;
        }
        throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{tagName, choice1 + "|" + choice2 + "|" + choice3 + "|" + choice4 + "|" + choice5});
    }

    public static String restrictChoice(String tagName, String target, String choice1, String choice2, String choice3, String choice4, String choice5, String choice6, String choice7) throws XMLConverterException {
        if (target.equalsIgnoreCase(choice1)) {
            return choice1;
        }
        if (target.equalsIgnoreCase(choice2)) {
            return choice2;
        }
        if (target.equalsIgnoreCase(choice3)) {
            return choice3;
        }
        if (target.equalsIgnoreCase(choice4)) {
            return choice4;
        }
        if (target.equalsIgnoreCase(choice5)) {
            return choice5;
        }
        if (target.equalsIgnoreCase(choice6)) {
            return choice6;
        }
        if (target.equalsIgnoreCase(choice7)) {
            return choice7;
        }
        throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{tagName, choice1 + "|" + choice2 + "|" + choice3 + "|" + choice4 + "|" + choice5 + "|" + choice6 + "|" + choice7});
    }
}

