/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.version.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.common.ModuleConversion;
import jeus.tool.converter.version.XMLVersionConverter;
import jeus.tool.converter.version.desctojaxb.FileRealmJaxbConverter;
import jeus.tool.converter.version.process.ConversionUtil;
import jeus.util.JeusException;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Converter;
import jeus.util.properties.JeusNetPropertyValues;

public class ProcessConversion
extends ModuleConversion {
    private static String FS = System.getProperty("file.separator");
    private static String CONVERTER_PACKAGE_PREFIX = "jeus.tool.converter.version.desctojaxb.";
    private static String[] converter_name = new String[]{"JeusMainJaxbConverter", "EJBMainJaxbConverter", "WEBMainJaxbConverter", "JMSMainJaxbConverter", "FileRealmConverter", "EJBDDJaxbConverter", "WEBDDJaxbConverter", "ClientDDJaxbConverter"};
    public static String NODE_NAME = null;
    private static Object jeusMainJaxb = null;
    private File[] ejbEngineDirs;
    private File[] webEngineDirs;
    private File[] jmsEngineDirs;
    private static final Logger logger = JeusLogger.getLogger((String)"jeus.converter");

    public void convertAll() throws JeusException {
        try {
            String localhost = JeusNetPropertyValues.LOCAL_FULL_HOSTNAME;
            int index = localhost.indexOf(46);
            if (index > 0) {
                localhost = localhost.substring(0, index);
            }
            NODE_NAME = localhost;
        }
        catch (Exception e) {
            throw new JeusException("Getting local host name is failed", (Throwable)e);
        }
        this.ejbEngineDirs = ConversionUtil.getOldEngineDirs(XMLVersionConverter.EJB_MAIN);
        this.webEngineDirs = ConversionUtil.getOldEngineDirs(XMLVersionConverter.WEB_MAIN);
        this.jmsEngineDirs = ConversionUtil.getOldEngineDirs(XMLVersionConverter.JMS_MAIN);
        this.processJeusMain();
        this.convertFTF(0, XMLVersionConverter.REALM_MAIN, null, null);
        this.convertEngineDir(XMLVersionConverter.EJB_MAIN);
        this.convertEngineDir(XMLVersionConverter.WEB_MAIN);
        this.convertEngineDir(XMLVersionConverter.JMS_MAIN);
    }

    public void processJeusMain() {
        String[] ejbMainOldPaths = ConversionUtil.getOldEngineXMLPaths(XMLVersionConverter.EJB_MAIN, this.ejbEngineDirs);
        String[] webMainOldPaths = ConversionUtil.getOldEngineXMLPaths(XMLVersionConverter.WEB_MAIN, this.webEngineDirs);
        String[] jmsMainOldPaths = ConversionUtil.getOldEngineXMLPaths(XMLVersionConverter.JMS_MAIN, this.jmsEngineDirs);
        String jeusMain_OldPath = ConversionUtil.getOldPath(XMLVersionConverter.JEUS_CONFIG, null, null);
        String jeusMain_NewPath = ConversionUtil.getNewPath(XMLVersionConverter.JEUS_CONFIG, null, null);
        System.out.println("[NOTE] conversion started for : " + jeusMain_OldPath + " to " + jeusMain_NewPath);
        try {
            this.convertJeusMain(jeusMain_OldPath, jeusMain_NewPath, ejbMainOldPaths, webMainOldPaths, jmsMainOldPaths);
            System.out.println("Conversion Success\n");
        }
        catch (Exception e) {
            System.out.println("Conversion Fail");
            logger.log(Level.SEVERE, "detail : ", e);
        }
    }

    public void convertJeusMain(String jeusMainSourcePath, String jeusMainTargetPath, String[] ejbSourcePaths, String[] webSourcePaths, String[] jmsSourcePaths) throws JeusException {
        Class<?> converterClass = null;
        XMLConverter jeusMainConverter = null;
        XMLConverter ejbMainConverter = null;
        XMLConverter webMainConverter = null;
        XMLConverter jmsMainConverter = null;
        try {
            converterClass = Class.forName(CONVERTER_PACKAGE_PREFIX + converter_name[XMLVersionConverter.JEUS_CONFIG]);
            jeusMainConverter = (XMLConverter)converterClass.newInstance();
            converterClass = Class.forName(CONVERTER_PACKAGE_PREFIX + converter_name[XMLVersionConverter.EJB_MAIN]);
            ejbMainConverter = (XMLConverter)converterClass.newInstance();
            converterClass = Class.forName(CONVERTER_PACKAGE_PREFIX + converter_name[XMLVersionConverter.WEB_MAIN]);
            webMainConverter = (XMLConverter)converterClass.newInstance();
            converterClass = Class.forName(CONVERTER_PACKAGE_PREFIX + converter_name[XMLVersionConverter.JMS_MAIN]);
            jmsMainConverter = (XMLConverter)converterClass.newInstance();
        }
        catch (Exception e) {
            throw new JeusException("Getting converter class is failed", (Throwable)e);
        }
        XMLTree[] xmlTrees = new XMLTree[1 + ejbSourcePaths.length + webSourcePaths.length + jmsSourcePaths.length];
        int count = 0;
        try {
            boolean validate = WIOParameters.XML_VALIDATION;
            XMLUtil xmlUtil = new XMLUtil();
            File jeusMainxmlFile = new File(jeusMainSourcePath);
            FileInputStream in = new FileInputStream(jeusMainxmlFile);
            xmlTrees[count++] = xmlUtil.process((InputStream)in, validate, jeusMainConverter.getPublicID(), jeusMainConverter.getSystemID(), jeusMainConverter.getType());
            count = ConversionUtil.getEngineXMLTrees(ejbSourcePaths, ejbMainConverter, this.ejbEngineDirs, xmlTrees, count);
            count = ConversionUtil.getEngineXMLTrees(webSourcePaths, webMainConverter, this.webEngineDirs, xmlTrees, count);
            count = ConversionUtil.getEngineXMLTrees(jmsSourcePaths, jmsMainConverter, this.webEngineDirs, xmlTrees, count);
        }
        catch (Exception e) {
            throw new JeusException("Getting xmlTree is failed", (Throwable)e);
        }
        if (xmlTrees[0] == null) {
            throw new JeusException("Source Path doesn't contain old version xml");
        }
        try {
            File targetFile = new File(jeusMainTargetPath);
            jeusMainJaxb = jeusMainConverter.constructJAXBObject(xmlTrees);
            ProcessConversion.marshalDescriptor(jeusMainJaxb, ConversionUtil.PACKAGE_PREFIX, targetFile);
        }
        catch (Exception e) {
            throw new JeusException("Mashaling Jaxb Object is failed", (Throwable)e);
        }
    }

    public void convertFTF(int versionType, int docType, String engineName, String fileName) {
        String old_path = ConversionUtil.getOldPath(docType, engineName, fileName);
        String new_path = ConversionUtil.getNewPath(docType, engineName, fileName);
        System.out.println("[NOTE] conversion started for : " + old_path + " to " + new_path);
        try {
            this.doConvertDD(docType, old_path, new_path);
            System.out.println("Conversion Success \n");
        }
        catch (Exception e) {
            System.out.println("Conversion Fail");
            logger.log(Level.SEVERE, "detail : ", e);
        }
    }

    private void convertEngineDir(int engineType) {
        File[] engineDirs = null;
        if (engineType == XMLVersionConverter.EJB_MAIN) {
            engineDirs = this.ejbEngineDirs;
        } else if (engineType == XMLVersionConverter.WEB_MAIN) {
            engineDirs = this.webEngineDirs;
        }
        if (engineType == XMLVersionConverter.JMS_MAIN) {
            engineDirs = this.jmsEngineDirs;
        }
        if (engineDirs == null) {
            return;
        }
        for (int k = 0; k < engineDirs.length; ++k) {
            this.convertFTF(0, engineType, engineDirs[k].getName(), null);
        }
    }

    public void doConvertDD(int docType, String sourcePath, String targetPath) throws Exception {
        if (targetPath == null) {
            String[] temp = FileUtils.separateDirAndFile((String)sourcePath);
            targetPath = FileUtils.getAbsolutePath((String)temp[1]);
        }
        if (docType == XMLVersionConverter.REALM_MAIN) {
            ProcessConversion.convertSecurity(sourcePath, targetPath);
            return;
        }
        Class<?> converterClass = null;
        XMLConverter sourceConverter = null;
        try {
            converterClass = Class.forName(CONVERTER_PACKAGE_PREFIX + converter_name[docType]);
            sourceConverter = (XMLConverter)converterClass.newInstance();
        }
        catch (Exception e) {
            throw new JeusException(JeusMessage_Converter._6105, (Object)converter_name[docType], (Throwable)e);
        }
        XMLTree xmlTree = null;
        try {
            File xmlFile = new File(sourcePath);
            FileInputStream in = new FileInputStream(xmlFile);
            XMLUtil xmlUtil = new XMLUtil();
            boolean validate = WIOParameters.XML_VALIDATION;
            xmlTree = xmlUtil.process((InputStream)in, validate, sourceConverter.getPublicID(), sourceConverter.getSystemID(), sourceConverter.getType());
        }
        catch (Exception e) {
            throw new JeusException(JeusMessage_Converter._6106, (Object)sourcePath, (Throwable)e);
        }
        if (xmlTree == null) {
            new Exception("Source Path doesn't contain old version xml");
        }
        try {
            File targetFile = new File(targetPath);
            Object jaxbObject = sourceConverter.constructJAXBObject(xmlTree);
            ProcessConversion.marshalDescriptor(jaxbObject, ConversionUtil.PACKAGE_PREFIX, targetFile);
        }
        catch (Exception e) {
            throw new JeusException(JeusMessage_Converter._6107, (Object)targetPath, (Throwable)e);
        }
    }

    public static void convertSecurity(String sourcePath, String targetPath) throws JeusException {
        FileRealmJaxbConverter converter = new FileRealmJaxbConverter();
        FileInputStream in = null;
        try {
            in = new FileInputStream(sourcePath);
        }
        catch (FileNotFoundException e) {
            throw new JeusException("Fail to find " + sourcePath, (Throwable)e);
        }
        XMLTree xmlTree = null;
        XMLUtil xmlUtil = new XMLUtil();
        boolean validate = WIOParameters.XML_VALIDATION;
        try {
            xmlTree = xmlUtil.process((InputStream)in, validate, 100);
        }
        catch (Exception e) {
            throw new JeusException(JeusMessage_Converter._6106, (Object)sourcePath);
        }
        Object valueConfig = null;
        try {
            valueConfig = converter.constructJAXBObject(xmlTree);
        }
        catch (Exception e) {
            throw new JeusException("Fail to convert " + sourcePath, (Throwable)e);
        }
        if (valueConfig == null) {
            new Exception("XML File read error for " + sourcePath);
        }
        try {
            Vector valueObject = (Vector)valueConfig;
            Object accountObject = valueObject.get(0);
            Object policyObject = valueObject.get(1);
            File accountFile = new File(targetPath);
            String absolutePath = accountFile.getAbsolutePath();
            String policyPath = absolutePath.substring(0, absolutePath.lastIndexOf(FS)) + FS + "policies.xml";
            File policyFile = new File(policyPath);
            ProcessConversion.marshalDescriptor(accountObject, ConversionUtil.PACKAGE_PREFIX, accountFile);
            ProcessConversion.marshalDescriptor(policyObject, ConversionUtil.PACKAGE_PREFIX, policyFile);
        }
        catch (Exception e) {
            throw new JeusException(JeusMessage_Converter._6107, (Object)targetPath, (Throwable)e);
        }
    }

    public void convertJeusDD(int moduleType, File workingSpace, String jarFileName) throws Exception {
        String JEUS_DD = null;
        File META_INF = null;
        int ddType = -1;
        if (moduleType == 1) {
            META_INF = new File(workingSpace.getAbsolutePath() + FS + "META-INF");
            JEUS_DD = "jeus-ejb-dd";
            ddType = XMLVersionConverter.JEUS_EJB_DD;
        } else if (moduleType == 2) {
            META_INF = new File(workingSpace.getAbsolutePath() + FS + "WEB-INF");
            JEUS_DD = "jeus-web-dd";
            ddType = XMLVersionConverter.JEUS_WEB_DD;
        } else {
            return;
        }
        File[] fileList = META_INF.listFiles();
        if (fileList == null) {
            System.out.println(META_INF + " does not have any files");
            return;
        }
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            if (!file.getName().endsWith(".xml") || !file.getName().startsWith(JEUS_DD)) continue;
            this.doConvertDD(ddType, file.getAbsolutePath(), file.getAbsolutePath());
        }
    }
}

