/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.desctojaxb;

import java.util.Vector;
import javax.xml.bind.JAXBException;
import jeus.descriptor.jms.ConnectionFactoryDescriptor;
import jeus.descriptor.jms.DestinationDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLDBConnPoolDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLDataSourceDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLDomainConfigDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLJMSServerDescriptor;
import jeus.xml.binding.jeusDD.ConnectionFactoryType;
import jeus.xml.binding.jeusDD.DbStorageType;
import jeus.xml.binding.jeusDD.DestinationType;
import jeus.xml.binding.jeusDD.DestinationTypeType;
import jeus.xml.binding.jeusDD.FactoryTypeType;
import jeus.xml.binding.jeusDD.JmsServerType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.ServiceConfig;
import jeus.xml.binding.jeusDD.StorageType;

public class JMSMainJaxbConverter {
    public static JmsServerType constructJaxbObject(WLDomainConfigDescriptor wlDomainInfo) throws JAXBException {
        ObjectFactory jmsMainFactory = new ObjectFactory();
        JmsServerType jmsServer = jmsMainFactory.createJmsServerType();
        if (wlDomainInfo == null) {
            return null;
        }
        WLJMSServerDescriptor wljmsDesc = wlDomainInfo.getJMSServerDesc();
        if (wljmsDesc == null) {
            return null;
        }
        ServiceConfig service = jmsMainFactory.createServiceConfig();
        service.setPort(Integer.valueOf(9000 + WLDomainConfigDescriptor.count));
        service.setName("JEUSMQ");
        jmsServer.getServiceConfig().add(service);
        for (int i = 0; i < wljmsDesc.getDestinations().size(); ++i) {
            String exportName;
            DestinationDescriptor dc = (DestinationDescriptor)wljmsDesc.getDestinations().get(i);
            DestinationType destination = jmsMainFactory.createDestinationType();
            if (dc.getType() == 1) {
                destination.setType(DestinationTypeType.fromValue((String)"queue"));
            } else if (dc.getType() == 2) {
                destination.setType(DestinationTypeType.fromValue((String)"topic"));
            }
            String name = dc.getName();
            if (name != null) {
                destination.setName(name);
            }
            if ((exportName = dc.getJNDIName()) != null) {
                destination.setExportName(exportName);
            }
            jmsServer.getDestination().add(destination);
        }
        Vector cfList = wlDomainInfo.getJMSConnectionFactories();
        for (int i = 0; i < cfList.size(); ++i) {
            String exportName;
            ConnectionFactoryDescriptor cfDes = (ConnectionFactoryDescriptor)cfList.get(i);
            ConnectionFactoryType cfType = jmsMainFactory.createConnectionFactoryType();
            cfType.setType(FactoryTypeType.fromValue((String)"topic"));
            String name = cfDes.getName();
            if (name != null) {
                cfType.setName(name);
            }
            if ((exportName = cfDes.getJNDIName()) != null) {
                cfType.setExportName(exportName);
            }
            jmsServer.getConnectionFactory().add(cfType);
        }
        ConnectionFactoryType cfType1 = jmsMainFactory.createConnectionFactoryType();
        cfType1.setType(FactoryTypeType.fromValue((String)"topic"));
        cfType1.setName("TopicConnectionFactory");
        jmsServer.getConnectionFactory().add(cfType1);
        ConnectionFactoryType cfType2 = jmsMainFactory.createConnectionFactoryType();
        cfType2.setType(FactoryTypeType.fromValue((String)"queue"));
        cfType2.setName("QueueConnectionFactory");
        jmsServer.getConnectionFactory().add(cfType2);
        StorageType storage = jmsMainFactory.createStorageType();
        Vector jmsJDBCList = wlDomainInfo.getJmsJDBCStoreList();
        if (jmsJDBCList.size() > 0) {
            WLDataSourceDescriptor jmsJDBCStore = (WLDataSourceDescriptor)jmsJDBCList.elementAt(0);
            WLDBConnPoolDescriptor wlpoolInfo = wlDomainInfo.getPoolInfoWithName(jmsJDBCStore.getConnectionPool());
            Vector txDataSource = wlDomainInfo.getTxDataSourceList();
            for (int i = 0; i < txDataSource.size(); ++i) {
                WLDataSourceDescriptor dataSource = (WLDataSourceDescriptor)txDataSource.elementAt(i);
                if (!dataSource.getPoolName().equals(wlpoolInfo.getName())) continue;
                DbStorageType storageType = jmsMainFactory.createDbStorageType();
                storageType.setDataSourceName(dataSource.getJNDIName());
                storage.setDbStorage(storageType);
                jmsServer.setStorage(storage);
                break;
            }
        }
        return jmsServer;
    }
}

