/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.xmltowldesc;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import jeus.descriptor.ejb.JNDIInfo;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.weblogic.descriptor.WLBeanDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLJarDescriptor;
import jeus.util.JeusException;
import jeus.util.file.FileUtils;
import jeus.util.message.JeusMessage_Converter;

public class WLJarConverter
extends XMLConverter {
    public static String FS = System.getProperty("file.separator");
    public static final String EJB_JAR = "weblogic-ejb-jar";
    public static final String ENTERPRISE_BEAN = "weblogic-enterprise-bean";
    public static final String EJB_NAME = "ejb-name";
    public static final String JNDI_NAME = "jndi-name";
    public static final String LOCAL_JNDI_NAME = "local-jndi-name";
    public static final String CALL_BY_REFERENCE = "enable-call-by-reference";
    public static final String REFERENCE_DESCRIPTOR = "reference-descriptor";
    public static final String RESOURCE_DESCRIPTION = "resource-description";
    public static final String RESOURCE_ENV_DESCRIPTION = "resource-env-description";
    public static final String EJB_REFERENCE_DESCRIPTION = "ejb-reference-description";
    public static final String EJB_LOCAL_REFERENCE_DESCRIPTION = "ejb-local-reference-description";
    public static final String EJB_REF_NAME = "ejb-ref-name";
    public static final String RES_REF_NAME = "res-ref-name";
    public static final String RES_ENV_REF_NAME = "res-env-ref-name";
    public static final String MESSAGE_DRIVEN_DESCRIPTOR = "message-driven-descriptor";
    public static final String DESTINATION_JNDI_NAME = "destination-jndi-name";
    public static final String CONNECTION_FACTORY_JNDI_NAME = "connection-factory-jndi-name";
    public static final String ENTERPRISE_BEANS = "enterprise-beans";
    public static final String MESSAGE_DRIVEN = "message-driven";
    public static final String MESSAGE_DRIVEN_DESTINATION = "message-driven-destination";
    public static final String DESTINATION_TYPE = "destination-type";

    public Object getUserObject(XMLTree[] xmlTrees) throws XMLConverterException {
        XMLTree wlJarTree = xmlTrees[0];
        XMLTree ejbDDTree = xmlTrees[1];
        if (!wlJarTree.getName().equals(EJB_JAR)) {
            return null;
        }
        WLJarDescriptor desc = new WLJarDescriptor();
        Vector<WLBeanDescriptor> beanList = new Vector<WLBeanDescriptor>();
        Enumeration e = wlJarTree.elements(ENTERPRISE_BEAN);
        while (e.hasMoreElements()) {
            XMLTree beanTree = (XMLTree)e.nextElement();
            beanList.addElement(this.getBeanDescriptor(beanTree, ejbDDTree));
        }
        desc.setBeans(beanList);
        return desc;
    }

    public WLBeanDescriptor getBeanDescriptor(XMLTree beanTree, XMLTree ejbDDTree) {
        XMLTree refDescTree;
        WLBeanDescriptor bdesc = new WLBeanDescriptor();
        String ejbName = XMLUtil.getSubtreeValue(beanTree, EJB_NAME);
        bdesc.setEJBName(ejbName);
        bdesc.setJNDIName(XMLUtil.getSubtreeValue(beanTree, JNDI_NAME));
        bdesc.setLocalJNDIName(XMLUtil.getSubtreeValue(beanTree, LOCAL_JNDI_NAME));
        XMLTree mdbDesTree = beanTree.getFirstElement(MESSAGE_DRIVEN_DESCRIPTOR);
        if (mdbDesTree != null) {
            bdesc.setDestinationJndiName(XMLUtil.getSubtreeValue(mdbDesTree, DESTINATION_JNDI_NAME));
            String connectionFactoryJndiName = XMLUtil.getSubtreeValue(mdbDesTree, CONNECTION_FACTORY_JNDI_NAME);
            if (connectionFactoryJndiName != null) {
                bdesc.setConnectionFacJndiName(connectionFactoryJndiName);
            } else {
                XMLTree beansTree = ejbDDTree.getFirstElement(ENTERPRISE_BEANS);
                Enumeration enum1 = beansTree.elements(MESSAGE_DRIVEN);
                XMLTree messageTree = null;
                while (enum1.hasMoreElements()) {
                    messageTree = (XMLTree)enum1.nextElement();
                    if (!ejbName.equals(XMLUtil.getSubtreeValue(messageTree, EJB_NAME))) continue;
                    XMLTree destinationTree = messageTree.getFirstElement(MESSAGE_DRIVEN_DESTINATION);
                    String destinationType = XMLUtil.getSubtreeValue(destinationTree, DESTINATION_TYPE);
                    if (destinationType.endsWith("Topic")) {
                        bdesc.setConnectionFacJndiName("TopicConnectionFactory");
                        continue;
                    }
                    if (!destinationType.endsWith("Queue")) continue;
                    bdesc.setConnectionFacJndiName("QueueConnectionFactory");
                }
            }
        }
        if ((refDescTree = beanTree.getFirstElement(REFERENCE_DESCRIPTOR)) != null) {
            this.fillEJBRefs(bdesc, refDescTree);
            this.fillResEnvRefs(bdesc, refDescTree);
            this.fillResRefs(bdesc, refDescTree);
        }
        return bdesc;
    }

    public void fillResEnvRefs(WLBeanDescriptor desc, XMLTree refDescTree) {
        if (desc == null) {
            return;
        }
        Enumeration enum1 = refDescTree.elements(RESOURCE_ENV_DESCRIPTION);
        Vector<JNDIInfo> resEnvRef = new Vector<JNDIInfo>();
        while (enum1.hasMoreElements()) {
            XMLTree resTree = (XMLTree)enum1.nextElement();
            String name = XMLUtil.getSubtreeValue(resTree, RES_ENV_REF_NAME);
            String value = XMLUtil.getSubtreeValue(resTree, JNDI_NAME);
            JNDIInfo jndiInfo = new JNDIInfo(name, value);
            resEnvRef.addElement(jndiInfo);
        }
        desc.setResourceEnvRefs(resEnvRef);
    }

    public void fillResRefs(WLBeanDescriptor desc, XMLTree refDescTree) {
        if (desc == null) {
            return;
        }
        Enumeration enum1 = refDescTree.elements(RESOURCE_DESCRIPTION);
        Vector<JNDIInfo> resRef = new Vector<JNDIInfo>();
        while (enum1.hasMoreElements()) {
            XMLTree resTree = (XMLTree)enum1.nextElement();
            String name = XMLUtil.getSubtreeValue(resTree, RES_REF_NAME);
            String value = XMLUtil.getSubtreeValue(resTree, JNDI_NAME);
            JNDIInfo jndiInfo = new JNDIInfo(name, value);
            resRef.addElement(jndiInfo);
        }
        desc.setResourceRefs(resRef);
    }

    public void fillEJBRefs(WLBeanDescriptor desc, XMLTree refDescTree) {
        if (desc == null) {
            return;
        }
        Enumeration enum1 = refDescTree.elements(EJB_REFERENCE_DESCRIPTION);
        Vector<JNDIInfo> ejbRef = new Vector<JNDIInfo>();
        while (enum1.hasMoreElements()) {
            XMLTree ejbRefTree = (XMLTree)enum1.nextElement();
            String name = XMLUtil.getSubtreeValue(ejbRefTree, EJB_REF_NAME);
            String value = XMLUtil.getSubtreeValue(ejbRefTree, JNDI_NAME);
            JNDIInfo jndiInfo = new JNDIInfo(name, value);
            ejbRef.addElement(jndiInfo);
        }
        Enumeration enum2 = refDescTree.elements(EJB_LOCAL_REFERENCE_DESCRIPTION);
        while (enum2.hasMoreElements()) {
            XMLTree ejbRefTree = (XMLTree)enum2.nextElement();
            String name = XMLUtil.getSubtreeValue(ejbRefTree, EJB_REF_NAME);
            String value = XMLUtil.getSubtreeValue(ejbRefTree, JNDI_NAME);
            JNDIInfo jndiInfo = new JNDIInfo(name, value);
            ejbRef.addElement(jndiInfo);
        }
        desc.setEJBRefs(ejbRef);
    }

    public String getSystemID() {
        return "system id";
    }

    public String getPublicID() {
        return "public id";
    }

    public int getType() {
        return -1;
    }

    public static int getStaticType() {
        return -1;
    }

    public static Object readConfigureValue(String somePath) throws JeusException {
        WLJarConverter converter = new WLJarConverter();
        try {
            FileInputStream in = new FileInputStream(new File(somePath));
            XMLUtil xmlUtil = new XMLUtil();
            XMLTree xmlTree = xmlUtil.process((InputStream)in, false, WLJarConverter.getStaticType());
            String[] dirAndFile = FileUtils.separateDirAndFile((String)somePath);
            String ejbJar = dirAndFile[0] + FS + "ejb-jar.xml";
            FileInputStream in2 = new FileInputStream(new File(ejbJar));
            XMLTree xmlTree2 = xmlUtil.process((InputStream)in2, false, WLJarConverter.getStaticType());
            XMLTree[] xmlTrees = new XMLTree[]{xmlTree, xmlTree2};
            return converter.getUserObject(xmlTrees);
        }
        catch (Exception e) {
            throw new JeusException(JeusMessage_Converter._6106, (Object)somePath, (Throwable)e);
        }
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        return null;
    }
}

