/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.ddinit;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import javax.xml.bind.JAXBException;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.deploy.io.runtime.WebRuntimeDDFile;
import jeus.servlet.jsp.HttpJspBase;
import jeus.tool.builder.Constants;
import jeus.tool.ddinit.JeusBaseDDInit;
import jeus.tool.util.JarManager;
import jeus.util.message.JeusMessage_Converter;
import jeus.webservices.spi.EWSProvider;
import jeus.xml.binding.JeusJAXBException;
import jeus.xml.binding.j2ee.FilterMappingType;
import jeus.xml.binding.j2ee.FilterNameType;
import jeus.xml.binding.j2ee.FilterType;
import jeus.xml.binding.j2ee.FullyQualifiedClassType;
import jeus.xml.binding.j2ee.ListenerType;
import jeus.xml.binding.j2ee.ObjectFactory;
import jeus.xml.binding.j2ee.ServletMappingType;
import jeus.xml.binding.j2ee.ServletNameType;
import jeus.xml.binding.j2ee.ServletType;
import jeus.xml.binding.j2ee.UrlPatternType;
import jeus.xml.binding.j2ee.WebAppType;
import jeus.xml.binding.jeusDD.ContextType;

public class WEBDDInit
extends JeusBaseDDInit {
    public static String path = null;

    public boolean doesAllJ2EEDDExist(Object[] j2eeDesc) {
        return j2eeDesc.length == 1 && j2eeDesc[0] instanceof WebAppType;
    }

    public boolean doesAllJEUSDDExist(Object[] jeusDesc) {
        return jeusDesc.length == 1 && jeusDesc[0] instanceof ContextType;
    }

    public boolean doesAllJEUSDDExist() throws IOException {
        path = new WebRuntimeDDFile(this.moduleName).getDeploymentDescriptorPath();
        return this.sourceArchive.contains(path);
    }

    public Object[] getJEUSDescriptor() throws JAXBException, JeusJAXBException {
        WebRuntimeDDFile file = new WebRuntimeDDFile(this.moduleName);
        try {
            return new Object[]{file.getDeploymentDescriptor(this.sourceArchive)};
        }
        catch (JeusJAXBException e) {
            throw e;
        }
        catch (IOException e) {
            return new Object[0];
        }
    }

    public Object[] getJ2EEDescriptor() throws JAXBException, JeusJAXBException {
        if (this.j2eeDescriptors != null) {
            return this.j2eeDescriptors;
        }
        WebDeploymentDescriptorFile file = new WebDeploymentDescriptorFile();
        try {
            return new Object[]{file.getDeploymentDescriptor(this.sourceArchive)};
        }
        catch (JeusJAXBException e) {
            throw e;
        }
        catch (IOException e) {
            return new Object[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDescriptor(Object[] j2eeDesc, Object[] jeusDesc) throws JAXBException, IOException {
        String j2eeDescString = null;
        String j2eePath = null;
        if (j2eeDesc != null) {
            WebDeploymentDescriptorFile file = new WebDeploymentDescriptorFile();
            ObjectFactory fac = new ObjectFactory();
            j2eeDescString = file.marshalDescriptor(fac.createWebApp((WebAppType)j2eeDesc[0]));
            j2eePath = file.getDeploymentDescriptorPath();
        }
        String jeusDescString = null;
        String jeusPath = null;
        if (jeusDesc != null) {
            WebRuntimeDDFile file = new WebRuntimeDDFile(null);
            jeus.xml.binding.jeusDD.ObjectFactory fac = new jeus.xml.binding.jeusDD.ObjectFactory();
            jeusDescString = file.marshalDescriptor(fac.createJeusWebDd((ContextType)jeusDesc[0]));
            jeusPath = file.getDeploymentDescriptorPath();
        }
        AbstractArchive destArchive = this.sourceArchive;
        try {
            if (this.sourceArchive instanceof InputJarArchive) {
                String newJarFileName = this.sourceArchive.getArchiveUri() + ".new";
                destArchive = JarArchiveFactory.createArchiveStatic((String)newJarFileName);
                ArrayList<String> list = new ArrayList<String>();
                if (j2eePath != null) {
                    list.add(j2eePath);
                }
                if (jeusPath != null) {
                    list.add(jeusPath);
                }
                ArchiveHelper.copy((AbstractArchive)this.sourceArchive, (AbstractArchive)destArchive, (String[])list.toArray(new String[0]));
            }
            if (j2eePath != null) {
                this.writeDescriptor(destArchive, j2eePath, j2eeDescString);
            }
            if (jeusPath != null) {
                this.writeDescriptor(destArchive, jeusPath, jeusDescString);
            }
        }
        finally {
            destArchive.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDescriptor(AbstractArchive destArchive, String j2eePath, String j2eeDescString) throws IOException {
        OutputStream os = destArchive.addEntry(j2eePath);
        try {
            os.write(j2eeDescString.getBytes());
        }
        finally {
            ArchiveHelper.close((OutputStream)os);
        }
    }

    public Object[] initJeusDescriptor(Object[] j2eeDesc, Object[] jeusDesc) throws IOException, JAXBException {
        EWSProvider provider;
        this.logger.log(JeusMessage_Converter._6524_LEVEL, JeusMessage_Converter._6524);
        jeus.xml.binding.jeusDD.ObjectFactory webDDFactory = new jeus.xml.binding.jeusDD.ObjectFactory();
        ContextType jeusWebDd = webDDFactory.createContextType();
        jeusWebDd.setVersion("6.0");
        if (this.contextPath != null) {
            jeusWebDd.setContextPath(this.contextPath);
        } else {
            jeusWebDd.setContextPath("/" + this.moduleName);
        }
        jeusWebDd.fillDefault();
        if (j2eeDesc != null && j2eeDesc.length > 0 && (provider = EWSProvider.getProvider()) != null) {
            provider.makeJeusWebservicesclientDdFromWebModule(this.sourceArchive, (WebAppType)j2eeDesc[0], jeusWebDd);
        }
        return new Object[]{jeusWebDd};
    }

    public Object[] initJeusDescriptor() throws JAXBException, IOException {
        Object[] j2eeDesc = this.getJ2EEDescriptor();
        return this.initJeusDescriptor(j2eeDesc, null);
    }

    public Object[] initJ2EEDescriptor() throws JAXBException, JeusJAXBException {
        Object[] j2eeDesc = this.getJ2EEDescriptor();
        return this.initJ2EEDescriptor(j2eeDesc);
    }

    public Object[] initJ2EEDescriptor(Object[] j2eeDesc) throws JAXBException {
        this.logger.log(JeusMessage_Converter._6525_LEVEL, JeusMessage_Converter._6525);
        ObjectFactory webAppFactory = new ObjectFactory();
        WebAppType webApp = webAppFactory.createWebAppType();
        webApp.setVersion("2.5");
        List webAppList = webApp.getDescriptionAndDisplayNameAndIcon();
        path = new WebRuntimeDDFile(this.moduleName).getDeploymentDescriptorPath();
        for (int i = 0; i < this.classes.size(); ++i) {
            String servletName;
            String className;
            Class servletClass = (Class)this.classes.get(i);
            if (HttpJspBase.class.isAssignableFrom(servletClass)) continue;
            if (ServletContextListener.class.isAssignableFrom(servletClass) || ServletContextAttributeListener.class.isAssignableFrom(servletClass) || HttpSessionListener.class.isAssignableFrom(servletClass) || HttpSessionAttributeListener.class.isAssignableFrom(servletClass) || HttpSessionBindingListener.class.isAssignableFrom(servletClass) || HttpSessionActivationListener.class.isAssignableFrom(servletClass)) {
                this.logger.log(JeusMessage_Converter._6546_LEVEL, JeusMessage_Converter._6546, (Object)servletClass.getName());
                ListenerType listenerType = webAppFactory.createListenerType();
                FullyQualifiedClassType servletClassType = webAppFactory.createFullyQualifiedClassType();
                className = servletClass.getName();
                servletClassType.setValue(className);
                listenerType.setListenerClass(servletClassType);
                webAppList.add(listenerType);
                continue;
            }
            if (Filter.class.isAssignableFrom(servletClass)) {
                this.logger.log(JeusMessage_Converter._6547_LEVEL, JeusMessage_Converter._6547, (Object)servletClass.getName());
                FilterType filterType = webAppFactory.createFilterType();
                className = servletClass.getName();
                int j = className.lastIndexOf(".");
                servletName = j > 0 ? className.substring(j + 1) : className;
                FilterNameType filterNameType = webAppFactory.createFilterNameType();
                filterNameType.setValue(servletName);
                filterType.setFilterName(filterNameType);
                FullyQualifiedClassType filterClassType = webAppFactory.createFullyQualifiedClassType();
                filterClassType.setValue(className);
                filterType.setFilterClass(filterClassType);
                FilterMappingType filterMappingType = webAppFactory.createFilterMappingType();
                ServletNameType servletNameType = webAppFactory.createServletNameType();
                servletNameType.setValue(servletName);
                filterMappingType.getUrlPatternOrServletName().add(servletNameType);
                filterMappingType.setFilterName(filterNameType);
                webAppList.add(filterType);
                webAppList.add(filterMappingType);
                continue;
            }
            if (!Servlet.class.isAssignableFrom(servletClass)) continue;
            this.logger.log(JeusMessage_Converter._6548_LEVEL, JeusMessage_Converter._6548, (Object)servletClass.getName());
            ServletType servletType = webAppFactory.createServletType();
            className = servletClass.getName();
            int j = className.lastIndexOf(".");
            servletName = j > 0 ? className.substring(j + 1) : className;
            ServletNameType servletNameType = webAppFactory.createServletNameType();
            servletNameType.setValue(servletName);
            servletType.setServletName(servletNameType);
            FullyQualifiedClassType servletClassType = webAppFactory.createFullyQualifiedClassType();
            servletClassType.setValue(className);
            servletType.setServletClass(servletClassType);
            ServletMappingType servletMappingType = webAppFactory.createServletMappingType();
            servletMappingType.setServletName(servletNameType);
            UrlPatternType urlPatternType = webAppFactory.createUrlPatternType();
            urlPatternType.setValue("/" + servletName + "/*");
            webAppList.add(servletType);
            webAppList.add(servletMappingType);
        }
        return new Object[]{webApp};
    }

    protected String getModuleExtension() {
        return ".war";
    }

    public static void main(String[] args) {
        try {
            WEBDDInit ddinit = new WEBDDInit();
            if (ddinit.parseArgs(args)) {
                ddinit.execute();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadClasses() throws IOException {
        this.logger.log(JeusMessage_Converter._6549_LEVEL, JeusMessage_Converter._6549);
        File tmp = new File(this.moduleName + "_" + System.currentTimeMillis());
        if (!tmp.mkdir()) {
            throw new IOException("Unable to create temporary directory for " + this.sourceArchive.getArchiveUrl());
        }
        String warPath = this.sourceArchive.getArchiveUrl().toExternalForm();
        try {
            if (new File(warPath).isFile()) {
                int ib = warPath.indexOf("jar:file:");
                int ie = warPath.lastIndexOf("!");
                if (ib >= 0 && ie > ib) {
                    warPath = warPath.substring(ib + 9, ie);
                }
                this.logger.log(JeusMessage_Converter._6550_LEVEL, JeusMessage_Converter._6550, (Object)warPath);
                JarManager.unJar(warPath, tmp.getPath());
            } else {
                warPath = Constants.JEUS_ASSEMBLY_DIR;
                tmp.delete();
                tmp = new File(warPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unable to unjar " + this.sourceArchive.getArchiveUrl());
        }
        File webinf = new File(tmp, "WEB-INF");
        File classesDir = new File(webinf, "classes");
        File libDir = new File(webinf, "lib");
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (classesDir.exists()) {
            URL url = classesDir.toURL();
            String classname = url.toExternalForm();
            urlList.add(url);
            AbstractArchive classArchive = FileArchiveFactory.openArchiveStatic((String)classname.substring(classname.indexOf("file:") + 5));
            Enumeration entries = classArchive.entries();
            while (entries.hasMoreElements()) {
                String bClass = (String)entries.nextElement();
                int index = bClass.lastIndexOf(".class");
                if (index < 0) continue;
                bClass = bClass.substring(0, index).replace('/', '.');
                list.add(bClass);
            }
        }
        if (libDir.exists()) {
            File[] libs = libDir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getPath().endsWith(".jar") || file.getPath().endsWith(".zip");
                }
            });
            for (int i = 0; i < libs.length; ++i) {
                URL url = libs[i].toURL();
                String libname = url.toExternalForm();
                urlList.add(url);
                AbstractArchive libArchive = JarArchiveFactory.openArchiveStatic((String)libname.substring(libname.indexOf("file:") + 5));
                Enumeration entries = libArchive.entries();
                while (entries.hasMoreElements()) {
                    String aClass = (String)entries.nextElement();
                    int index = aClass.lastIndexOf(".class");
                    if (index < 0) continue;
                    aClass = aClass.substring(0, index).replace('/', '.');
                    list.add(aClass);
                }
            }
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        this.classLoader = new URLClassLoader(urls);
        this.classes = new Vector();
        if (list.size() == 0) {
            this.logger.log(JeusMessage_Converter._6551_LEVEL, JeusMessage_Converter._6551, (Object)this.sourceArchive.getArchiveUri());
        } else {
            this.logger.log(JeusMessage_Converter._6552_LEVEL, JeusMessage_Converter._6552, (Object)this.sourceArchive.getArchiveUri());
        }
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            try {
                Class<?> class1 = this.classLoader.loadClass(s);
                this.classes.add(class1);
                this.logger.log(Level.FINE, "Found class {0}", (Object)class1.getName());
                continue;
            }
            catch (ClassNotFoundException classnotfoundexception) {
                this.logger.log(Level.FINE, "ClassNotFound: {0}", (Object)classnotfoundexception.getMessage());
                continue;
            }
            catch (NoClassDefFoundError noclassdeffounderror) {
                this.logger.log(Level.FINE, "NoClassDefFound: {0}", (Object)noclassdeffounderror.getMessage());
            }
        }
    }

    static void p(String s) {
        System.out.println("[WEBDDInit-WEB]: " + s);
    }
}

