/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import jeus.deploy.archivist.FileArchive;
import jeus.descriptor.tool.Descriptor;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.deployment.FileInfo;
import jeus.tool.manager.common.FileDirMapDescriptor;
import jeus.tool.util.FileUtil;
import jeus.tool.util.JarManager;
import jeus.util.file.FileUtils;

public abstract class DeployUnit {
    public static final String fs = System.getProperty("file.separator");
    public static final char fsc = fs.charAt(0);
    public static final String WEB_HOME = "webhome";
    public static final String SUCCESS = "SUCCESS";
    public static final String FAIL = "FAIL";
    public static final String META_INF = "META-INF";
    public static String WORKING_DIR = WIOParameters.JEUS_HOME + fs + "workspace" + fs + "deployment";
    protected String root = null;
    protected String source = null;
    protected Vector fileContents = new Vector();
    protected Descriptor descriptor = null;
    protected XMLConverter converter = null;
    protected XMLTree descriptorTree = null;
    protected XMLTree jeusDescriptorTree = null;
    protected FileDirMapDescriptor fileDesc = null;

    public static void setWorkingDIR(String path) {
        WORKING_DIR = path;
    }

    public abstract String getDescriptorPath();

    public abstract String getJeusDDToBePath();

    public abstract int getUnitType();

    public abstract int getJeusDDType();

    public DeployUnit(String paramSource) {
        this.setSource(paramSource);
    }

    protected String makeRoot() throws Exception {
        String prefix = this.source.substring(this.source.lastIndexOf(fsc) + 1);
        String suffix = ".tmp";
        File tempDir = new File(WORKING_DIR);
        tempDir.mkdirs();
        File rootFile = File.createTempFile(prefix, suffix, tempDir);
        rootFile.delete();
        rootFile.mkdirs();
        return rootFile.getPath();
    }

    public void setSource(String paramSource) {
        this.source = paramSource;
    }

    public void setRoot(String paramRoot) {
        this.root = paramRoot;
    }

    public void setFileContents(Vector paramFileContents) {
        this.fileContents = paramFileContents;
    }

    public void addFile(FileInfo fileInfo) {
        this.fileContents.add(fileInfo);
    }

    public void removeFile(FileInfo fileInfo) {
        this.fileContents.remove(fileInfo);
    }

    public void setDescriptor(Descriptor paramDescriptor) {
        this.descriptor = paramDescriptor;
    }

    public String getSource() {
        return this.source;
    }

    public String getRoot() {
        return this.root;
    }

    public Vector getFileContents() {
        return this.fileContents;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void loadDescriptor() throws Exception {
        this.descriptor = (Descriptor)this.converter.load(new File(this.getDescriptorPath()));
    }

    public void saveDescriptor() throws Exception {
        this.converter.save(new File(this.getDescriptorPath()), (Object)this.descriptor);
    }

    public void loadFileContents() {
        File[] files = FileUtil.listAllFiles(this.root);
        for (int i = 0; i < files.length; ++i) {
            String filePath;
            if (files[i].isDirectory() || (filePath = files[i].getPath()).equals(this.getDescriptorPath())) continue;
            String uri = filePath.substring(this.root.length());
            String fileURI = uri.startsWith(fs) ? uri.substring(1).replace(fsc, '/') : uri.replace(fsc, '/');
            FileInfo fileInfo = new FileInfo(files[i], fileURI);
            this.fileContents.add(fileInfo);
        }
    }

    public void makeFileContents() throws Exception {
        Enumeration e = this.fileContents.elements();
        while (e.hasMoreElements()) {
            FileInfo fileInfo = (FileInfo)e.nextElement();
            fileInfo.copyTo(this.root);
        }
    }

    public void openPackage() throws Exception {
        if (this.root == null) {
            this.setRoot(this.makeRoot());
        }
        JarManager.unJar(this.source, this.root);
        this.loadFileContents();
        this.loadDescriptor();
    }

    public void openPackage(boolean extract) throws Exception {
        String _path = FileUtils.getPathWithoutExtension((String)this.source, (String)".war");
        if (extract) {
            File _rootDir = new File(_path);
            if (_rootDir.exists()) {
                FileArchive fileArchive = new FileArchive(_path);
                fileArchive.delete();
            }
            JarManager.unJar(this.source, _path);
        }
        this.root = _path;
        this.loadFileContents();
    }

    public DeployUnit(String source, boolean isWIO) throws Exception {
        this.setSource(source);
        this.setRoot(this.makeRoot());
        JarManager.unJar(source, this.root);
        this.loadFileContentsWIO();
        this.loadDescriptorWIO();
    }

    public DeployUnit(String source, FileDirMapDescriptor fileDesc, XMLTree descriptor) throws Exception {
        this.setSource(source);
        this.fileContents = fileDesc.getFileInfos();
        this.descriptorTree = descriptor;
    }

    public void createJarWIO(String newSource) throws Exception {
        this.setRoot(this.makeRoot());
        this.saveFileContentsWIO();
        this.saveDescriptorWIO();
        JarManager.jar(newSource, this.root);
    }

    public void saveFileContentsWIO() throws Exception {
        this.makeFileContents();
    }

    public void loadFileContentsWIO() {
        this.loadFileContents();
        if (this.fileContents == null) {
            return;
        }
        Enumeration enum1 = this.fileContents.elements();
        Vector<File> relativeFiles = new Vector<File>();
        while (enum1.hasMoreElements()) {
            FileInfo finfo = (FileInfo)enum1.nextElement();
            File fullpathFile = finfo.getFile();
            File relativeFile = FileDirMapDescriptor.relativize(new File(this.root), fullpathFile);
            relativeFiles.add(relativeFile);
        }
        this.fileDesc = new FileDirMapDescriptor(this.root, relativeFiles);
    }

    public FileDirMapDescriptor getFileDesc() {
        return this.fileDesc;
    }

    public void setFileDesc(FileDirMapDescriptor fdesc) {
        this.fileDesc = fdesc;
        this.fileContents = fdesc.getFileInfos();
    }

    public String getPublicID() {
        return "deploy unit";
    }

    public String getSystemID() {
        return "system id";
    }

    public void saveDescriptorWIO() throws Exception {
        XMLUtil xmlUtil = new XMLUtil();
        xmlUtil.saveWIO(this.descriptorTree, this.getUnitType(), new File(this.getDescriptorPath()));
        this.saveJeusDescriptorWIO(xmlUtil);
    }

    public void saveJeusDescriptorWIO(XMLUtil xmlUtil) throws Exception {
        XMLTree jeusDDTree = this.getJeusDescriptorTree();
        if (jeusDDTree != null) {
            xmlUtil.saveWIO(jeusDDTree, this.getJeusDDType(), new File(this.getJeusDDToBePath()));
        }
    }

    public void loadDescriptorWIO() throws Exception {
        File xmlFile = new File(this.getDescriptorPath());
        FileInputStream in = new FileInputStream(xmlFile);
        XMLUtil xmlUtil = new XMLUtil();
        boolean validate = false;
        this.descriptorTree = xmlUtil.process((InputStream)in, validate, this.getUnitType());
        if (this.getJeusDDToBePath() == null) {
            return;
        }
        File ddFilePath = new File(this.getJeusDDToBePath());
        if (ddFilePath.exists()) {
            FileInputStream inDD = new FileInputStream(ddFilePath);
            this.setJeusDescriptorTree(xmlUtil.process((InputStream)inDD, validate, this.getJeusDDType()));
        }
    }

    public XMLTree getDescriptorTree() {
        return this.descriptorTree;
    }

    public void setDescriptorTree(XMLTree myTree) {
        this.descriptorTree = myTree;
    }

    public XMLTree getJeusDescriptorTree() {
        return this.jeusDescriptorTree;
    }

    public void setJeusDescriptorTree(XMLTree myTree) {
        this.jeusDescriptorTree = myTree;
    }

    public void makePackage() throws Exception {
        if (this.root == null) {
            this.setRoot(this.makeRoot());
        }
        this.saveDescriptor();
        this.makeFileContents();
        JarManager.jar(this.source, this.root);
    }

    public void modifyPackage() throws Exception {
        String oldRoot = this.root;
        this.setRoot(this.makeRoot());
        this.makePackage();
        FileUtil.rmdir(oldRoot);
        this.fileContents.removeAllElements();
        this.loadFileContents();
    }

    public void deleteDeployedFiles() {
        if (this.root == null) {
            return;
        }
        FileUtil.rmdir(this.root);
    }

    public String toString() {
        return this.source.substring(this.source.lastIndexOf(fsc) + 1);
    }
}

