/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.deployment;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import jeus.descriptor.ejb.EJBDBInfo;
import jeus.descriptor.ejb.EJBDescriptor;
import jeus.descriptor.ejb.EJBEntityDescriptor;
import jeus.descriptor.ejb.EJBModDescriptor;
import jeus.descriptor.tool.BeanDescriptor;
import jeus.descriptor.tool.Descriptor;
import jeus.descriptor.tool.EJBModuleDescriptor;
import jeus.descriptor.tool.EntityDescriptor;
import jeus.descriptor.tool.MessageDrivenDescriptor;
import jeus.descriptor.tool.Method;
import jeus.descriptor.tool.SessionDescriptor;
import jeus.ejb.util.MethodConvertor;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.EJBDescriptorConverter;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.deployment.DeployUnit;
import jeus.tool.deployment.FileInfo;
import jeus.tool.manager.common.FileDirMapDescriptor;
import jeus.tool.util.JarManager;
import jeus.tool.util.SerializeManager;

public class EJBModule
extends DeployUnit {
    public static final String DESCRIPTOR = "ejb-jar.xml";
    public static final String DD_DESCRIPTOR = "jeus-ejb-dd.xml";
    public static final String EJB_HOME = "webhome/ejb_home";
    public static final String SOURCE_JAR = "webhome/ejb_home/sourceJar.jar";
    public static final String SOURCE_JAR_AUTO = "ejb:/sourceJar.jar";
    public static final String CONFIG = "config";
    public static final String FIND_BY_PRIMARY_KEY = "findByPrimaryKey";
    public static final String EJB_JAR_ = "ejb-jar_";
    public static final String JEUS_EJB_DD_ = "jeus-ejb-dd_";
    public static final String dotXML = ".xml";
    public static final String dotSER = ".ser";
    public static final String JEUS_DESCRIPTOR_PREFIX = "jeus-ejb-dd";
    private String[] contents = null;
    private Vector clientJarList = null;
    private String moduleName = this.getSourceName();

    public EJBModule(String source) {
        super(source);
    }

    public void setModuleName(String name) {
        this.moduleName = name;
    }

    public String getModuleName() {
        if (this.moduleName == null) {
            this.moduleName = this.getSourceName();
        }
        return this.moduleName;
    }

    public String getSourceFullName() {
        String source = this.getSource();
        String name = source.substring(source.lastIndexOf(fsc) + 1);
        return name;
    }

    public String getSourceName() {
        String source = this.getSource();
        String name = source.substring(source.lastIndexOf(fsc) + 1);
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public String getDescriptorPath() {
        return this.root + fs + "META-INF" + fs + DESCRIPTOR;
    }

    public String getJeusDDToBePath() {
        String mayExistPath = this.getJeusDescriptorPath();
        if (mayExistPath != null) {
            return mayExistPath;
        }
        return this.root + fs + "META-INF" + fs + DD_DESCRIPTOR;
    }

    public String getClientJarPath(String jarName) {
        return this.root + fs + jarName;
    }

    public int getJeusDDType() {
        return 1000;
    }

    public EJBModuleDescriptor getEJBDescriptorFromZip() throws Exception {
        String DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/ejb-jar.xml";
        JarFile myJarFile = new JarFile(this.getSource());
        ZipEntry deploymentEntry = myJarFile.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        if (deploymentEntry == null) {
            myJarFile.close();
            throw new Exception("descriptor does not exist in JAR");
        }
        InputStream fis = myJarFile.getInputStream(deploymentEntry);
        EJBModuleDescriptor moduleDesc = (EJBModuleDescriptor)this.converter.load(fis);
        myJarFile.close();
        return moduleDesc;
    }

    public EJBModDescriptor getJeusDescriptoFromZip() throws Exception {
        JarFile myJarFile = new JarFile(this.getSource());
        EJBDescriptorConverter jeusConverter = new EJBDescriptorConverter();
        EJBModDescriptor jeusDescriptor = null;
        Enumeration<JarEntry> me = myJarFile.entries();
        while (me.hasMoreElements()) {
            ZipEntry jeusEntry = me.nextElement();
            if (jeusEntry.getName().indexOf(JEUS_DESCRIPTOR_PREFIX) < 0) continue;
            InputStream fis = myJarFile.getInputStream(jeusEntry);
            jeusDescriptor = (EJBModDescriptor)jeusConverter.load(fis);
            myJarFile.close();
            return jeusDescriptor;
        }
        myJarFile.close();
        return null;
    }

    public String getJeusDescriptorPath() {
        String absPath = this.root + fs + "META-INF";
        String jeusDDName = null;
        File absFile = new File(absPath);
        File[] listFiles = absFile.listFiles();
        if (listFiles == null) {
            return null;
        }
        if (listFiles.length == 0) {
            return null;
        }
        for (int i = 0; i < listFiles.length; ++i) {
            File oneFile = listFiles[i];
            String fileName = oneFile.getName();
            if (!oneFile.isFile() || fileName == null || !fileName.startsWith(JEUS_DESCRIPTOR_PREFIX)) continue;
            jeusDDName = fileName;
        }
        if (jeusDDName == null) {
            return null;
        }
        return this.root + fs + "META-INF" + fs + jeusDDName;
    }

    public EJBModDescriptor getJeusDescriptor() {
        String jeusDDPath = this.getJeusDescriptorPath();
        if (jeusDDPath == null) {
            return null;
        }
        EJBDescriptorConverter jeusConverter = new EJBDescriptorConverter();
        EJBModDescriptor jeusDescriptor = null;
        try {
            jeusDescriptor = (EJBModDescriptor)jeusConverter.load(new File(jeusDDPath));
        }
        catch (Exception e) {
            jeusDescriptor = null;
        }
        return jeusDescriptor;
    }

    public void setContentsOfEJBClientJar(String[] contents) {
        this.contents = contents;
    }

    public String[] getContentsOfEJBClientJar() {
        return this.contents;
    }

    public void openPackage() throws Exception {
        super.openPackage();
        this.openEJBClientJar();
    }

    private void openEJBClientJar() throws Exception {
        String ejbClientJar = ((EJBModuleDescriptor)this.getDescriptor()).getEJBClientJar();
        if (ejbClientJar == null) {
            return;
        }
        String jarPath = this.root + fs + ejbClientJar.replace('/', fsc);
        File testFile = new File(jarPath);
        if (!testFile.exists()) {
            return;
        }
        String[] entries = JarManager.getEntries(jarPath);
        this.contents = new String[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].lastIndexOf(46) == -1) continue;
            this.contents[i] = entries[i].substring(0, entries[i].lastIndexOf(46)).replace('/', '.');
        }
    }

    private void makeEJBClientJar() throws Exception {
        String ejbClientJar = ((EJBModuleDescriptor)this.getDescriptor()).getEJBClientJar();
        if (ejbClientJar == null) {
            return;
        }
        String[] fileContents = new String[this.contents.length];
        String[] entries = new String[this.contents.length];
        String CLASS_EXTENSION = ".class";
        String jarPath = this.root + fs + ejbClientJar.replace('/', fsc);
        for (int i = 0; i < this.contents.length; ++i) {
            entries[i] = this.contents[i].replace('.', '/') + CLASS_EXTENSION;
            fileContents[i] = this.root + fs + this.contents[i].replace('.', fsc) + CLASS_EXTENSION;
        }
        JarManager.jar(jarPath, fileContents, entries);
    }

    public void makePackage() throws Exception {
        if (this.root == null) {
            this.setRoot(this.makeRoot());
        }
        this.saveDescriptor();
        this.makeFileContents();
        this.makeEJBClientJar();
        JarManager.jar(this.source, this.root);
    }

    private String getSerializedDescriptorPath(String beanName) {
        return this.root + fs + "META-INF" + fs + beanName + dotSER;
    }

    public EJBModDescriptor getEJBModDescriptor(EJBModDescriptor modDescriptor) throws Exception {
        EJBModuleDescriptor moduleDescriptor = (EJBModuleDescriptor)this.descriptor;
        EJBModDescriptor desc = moduleDescriptor.toEJBModDescriptor(modDescriptor, this.getModuleName());
        return desc;
    }

    public EJBModDescriptor getEJBModDescriptor(EJBModDescriptor modDescriptor, boolean refFile) throws Exception {
        EJBModuleDescriptor moduleDescriptor = (EJBModuleDescriptor)this.descriptor;
        EJBModDescriptor desc = moduleDescriptor.toEJBModDescriptor(modDescriptor, this.getModuleName(), refFile);
        return desc;
    }

    public EJBModDescriptor getEJBModDescriptor() throws Exception {
        EJBModuleDescriptor moduleDescriptor = (EJBModuleDescriptor)this.descriptor;
        EJBModDescriptor modDescriptor = null;
        modDescriptor = moduleDescriptor.toEJBModDescriptor(this.getModuleName());
        Vector beanList = modDescriptor.getBeanList();
        for (int i = 0; i < beanList.size(); ++i) {
            EJBDescriptor ejbDescriptor = (EJBDescriptor)beanList.get(i);
            if (!(ejbDescriptor instanceof EJBEntityDescriptor)) continue;
            EJBEntityDescriptor entityDescriptor = (EJBEntityDescriptor)ejbDescriptor;
            try {
                entityDescriptor.setNMMethods(this.getMethods(this.getRoot(), entityDescriptor.getEJBObjectClassName()));
            }
            catch (Throwable e) {
                entityDescriptor.setNMMethods(new Vector());
            }
            if (!entityDescriptor.isConManaged() || entityDescriptor.getCMPVersion() == 2) continue;
            EJBDBInfo dbInfo = entityDescriptor.getEJBDBInfo();
            ArrayList<String> al5 = new ArrayList<String>();
            ArrayList<String> al6 = new ArrayList<String>();
            try {
                String[] methods = this.getFindMethods(ejbDescriptor.getEJBHomeClassName());
                for (int methodCount = 0; methodCount < methods.length; ++methodCount) {
                    al5.add(methods[methodCount]);
                    al6.add(new String(""));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            dbInfo.findMethods = al5;
            dbInfo.findSQLs = al6;
        }
        return modDescriptor;
    }

    public EJBDescriptor getEJBDescriptor(String beanName) {
        EJBDescriptor ejbDescriptor;
        block5: {
            try {
                String serPath = this.getSerializedDescriptorPath(beanName);
                ejbDescriptor = (EJBDescriptor)SerializeManager.deserialize(serPath);
            }
            catch (Exception e) {
                ejbDescriptor = ((EJBModuleDescriptor)this.descriptor).toEJBDescriptor(beanName, this.getModuleName());
                if (!(ejbDescriptor instanceof EJBEntityDescriptor) || !((EJBEntityDescriptor)ejbDescriptor).isConManaged()) break block5;
                EJBDBInfo dbInfo = ((EJBEntityDescriptor)ejbDescriptor).getEJBDBInfo();
                ArrayList<String> al5 = new ArrayList<String>();
                ArrayList<String> al6 = new ArrayList<String>();
                try {
                    String[] methods = this.getFindMethods(ejbDescriptor.getEJBHomeClassName());
                    for (int i = 0; i < methods.length; ++i) {
                        al5.add(methods[i]);
                        al6.add(new String(""));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                dbInfo.findMethods = al5;
                dbInfo.findSQLs = al6;
            }
        }
        return ejbDescriptor;
    }

    public String getBaseDirectory(String className) {
        String classURI = className.replace('.', '/') + ".class";
        String baseDir = null;
        Vector fileContents = this.getFileContents();
        for (int i = 0; i < fileContents.size(); ++i) {
            FileInfo fileInfo = (FileInfo)fileContents.get(i);
            if (!fileInfo.getURI().equals(classURI)) continue;
            String realPath = fileInfo.getFile().getPath();
            int index = realPath.indexOf(classURI.replace('/', fsc));
            if (index < 0) break;
            baseDir = realPath.substring(0, index);
            break;
        }
        if (baseDir != null && !baseDir.endsWith("/")) {
            return baseDir + "/";
        }
        return baseDir;
    }

    public Vector getAllMethod() {
        MessageDrivenDescriptor[] messageDrivens;
        EntityDescriptor[] entities;
        EJBModuleDescriptor descriptor = (EJBModuleDescriptor)this.getDescriptor();
        Vector<BeanDescriptor> beanDescriptors = new Vector<BeanDescriptor>();
        SessionDescriptor[] sessions = descriptor.getSessionDescriptors();
        if (sessions != null) {
            beanDescriptors.addAll(Arrays.asList(sessions));
        }
        if ((entities = descriptor.getEntityDescriptors()) != null) {
            beanDescriptors.addAll(Arrays.asList(entities));
        }
        if ((messageDrivens = descriptor.getMessageDrivenDescriptors()) != null) {
            beanDescriptors.addAll(Arrays.asList(messageDrivens));
        }
        Vector<Method> allMethod = new Vector<Method>();
        for (int index = 0; index < beanDescriptors.size(); ++index) {
            BeanDescriptor bean = (BeanDescriptor)beanDescriptors.get(index);
            if (bean instanceof MessageDrivenDescriptor) {
                allMethod.addElement(new Method(bean.getEJBName(), null, "onMessage(javax.jms.Message)"));
                continue;
            }
            allMethod.addElement(new Method(bean.getEJBName(), null, "*"));
            String homeIntf = bean.getHomeInterface();
            Vector homeMethods = new Vector();
            try {
                homeMethods = this.getMethods(this.getBaseDirectory(homeIntf), homeIntf);
            }
            catch (Throwable ehome) {
                // empty catch block
            }
            for (int i = 0; i < homeMethods.size(); ++i) {
                Method method = new Method(bean.getEJBName(), "Home", (String)homeMethods.get(i));
                allMethod.addElement(method);
            }
            String remoteIntf = bean.getRemoteInterface();
            Vector remoteMethods = new Vector();
            try {
                remoteMethods = this.getMethods(this.getBaseDirectory(remoteIntf), remoteIntf);
            }
            catch (Throwable eremote) {
                // empty catch block
            }
            for (int i = 0; i < remoteMethods.size(); ++i) {
                Method method = new Method(bean.getEJBName(), "Remote", (String)remoteMethods.get(i));
                allMethod.addElement(method);
            }
            String localHomeIntf = bean.getLocalHomeInterface();
            Vector localHomeMethods = new Vector();
            try {
                localHomeMethods = this.getMethods(this.getBaseDirectory(localHomeIntf), localHomeIntf);
            }
            catch (Throwable ehome) {
                // empty catch block
            }
            for (int i = 0; i < localHomeMethods.size(); ++i) {
                Method method = new Method(bean.getEJBName(), "LocalHome", (String)localHomeMethods.get(i));
                allMethod.addElement(method);
            }
            String localIntf = bean.getLocalInterface();
            Vector localMethods = new Vector();
            try {
                localMethods = this.getMethods(this.getBaseDirectory(localIntf), localIntf);
            }
            catch (Throwable ehome) {
                // empty catch block
            }
            for (int i = 0; i < localMethods.size(); ++i) {
                Method method = new Method(bean.getEJBName(), "Local", (String)localMethods.get(i));
                allMethod.addElement(method);
            }
        }
        return allMethod;
    }

    public Vector getAllSelectMethods(String beanName) throws Exception {
        Vector<Method> selectMethods = new Vector<Method>();
        Vector beanMethods = new Vector();
        try {
            beanMethods = this.getMethods(this.getBaseDirectory(beanName), beanName);
        }
        catch (Throwable ebean) {
            // empty catch block
        }
        for (int i = 0; i < beanMethods.size(); ++i) {
            String beanMethodString = (String)beanMethods.get(i);
            if (!beanMethodString.startsWith("ejbSelect")) continue;
            Method method = new Method(null, null, beanMethodString);
            selectMethods.addElement(method);
        }
        return selectMethods;
    }

    public Vector getAllFindMethods(String homeClassName) throws Exception {
        Vector<Method> findMethods = new Vector<Method>();
        Vector homeMethods = new Vector();
        try {
            homeMethods = this.getMethods(this.getBaseDirectory(homeClassName), homeClassName);
        }
        catch (Throwable ehome) {
            // empty catch block
        }
        for (int i = 0; i < homeMethods.size(); ++i) {
            String homeMethodString = (String)homeMethods.get(i);
            if (!homeMethodString.startsWith("find")) continue;
            Method method = new Method(null, null, homeMethodString);
            findMethods.addElement(method);
        }
        return findMethods;
    }

    public String[] getFindMethods(String homeClassName) throws Exception {
        File directory = new File(this.root);
        URL[] localURL = new URL[]{directory.toURL()};
        URLClassLoader loader = new URLClassLoader(localURL);
        Class<?> homeInterface = loader.loadClass(homeClassName);
        java.lang.reflect.Method[] methods = homeInterface.getDeclaredMethods();
        Vector<String> findMethods = new Vector<String>();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].toString().equals(FIND_BY_PRIMARY_KEY)) continue;
            StringBuffer method = new StringBuffer(methods[i].getName());
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            method.append("(");
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (j != 0) {
                    method.append(",");
                }
                method.append(parameterTypes[j].getName());
            }
            method.append(")");
            if (!method.toString().startsWith("find")) continue;
            findMethods.addElement(method.toString());
        }
        Object[] objMethods = findMethods.toArray();
        String[] strMethods = new String[objMethods.length];
        for (int i = 0; i < strMethods.length; ++i) {
            strMethods[i] = (String)objMethods[i];
        }
        return strMethods;
    }

    public String[] getMethods(String className) throws Exception {
        File directory = new File(this.root);
        URL[] localURL = new URL[]{directory.toURL()};
        URLClassLoader loader = new URLClassLoader(localURL);
        Class<?> classIntf = loader.loadClass(className);
        java.lang.reflect.Method[] methods = classIntf.getDeclaredMethods();
        Vector<String> foundMethods = new Vector<String>();
        for (int i = 0; i < methods.length; ++i) {
            StringBuffer method = new StringBuffer(methods[i].getName());
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            method.append("(");
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (j != 0) {
                    method.append(",");
                }
                method.append(parameterTypes[j].getName());
            }
            method.append(")");
            foundMethods.addElement(method.toString());
        }
        Object[] objMethods = foundMethods.toArray();
        String[] strMethods = new String[objMethods.length];
        for (int i = 0; i < strMethods.length; ++i) {
            strMethods[i] = (String)objMethods[i];
        }
        return strMethods;
    }

    public Class getClass(String className) throws Exception {
        File directory = new File(this.root);
        URL[] localURL = new URL[]{directory.toURL()};
        URLClassLoader loader = new URLClassLoader(localURL);
        Class<?> classIntf = loader.loadClass(className);
        return classIntf;
    }

    public Vector getMethods(String directoryPath, String className) {
        Class<?> remoteInterface;
        if (directoryPath == null) {
            return new Vector();
        }
        File directory = new File(directoryPath);
        URL[] localURL = new URL[1];
        try {
            localURL[0] = directory.toURL();
            URLClassLoader loader = new URLClassLoader(localURL);
            remoteInterface = loader.loadClass(className);
        }
        catch (Exception ex) {
            return new Vector();
        }
        return MethodConvertor.getMethodTable(remoteInterface);
    }

    public EJBModule(String source, boolean isWIO) throws Exception {
        super(source, isWIO);
        this.descriptor = (Descriptor)this.converter.getUserObject(this.getDescriptorTree());
        this.openEJBClientJar();
    }

    public EJBModule(String source, FileDirMapDescriptor fileDesc, XMLTree xmldescriptor, Vector clientJarList) throws Exception {
        super(source, fileDesc, xmldescriptor);
        this.descriptor = (Descriptor)this.converter.getUserObject(this.getDescriptorTree());
        this.clientJarList = clientJarList;
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(1100);
    }

    public String getSystemID() {
        return WIOParameters.getSystemID(1100);
    }

    public int getUnitType() {
        return 1100;
    }

    public void setClientJarList(Vector list) {
        this.clientJarList = list;
    }

    public void createJarWIO(String newSource) throws Exception {
        this.setRoot(this.makeRoot());
        this.saveDescriptorWIO();
        this.saveFileContentsWIO();
        this.makeEJBClientJarWIO(this.clientJarList);
        this.saveFileContentsWIO();
        JarManager.jar(newSource, this.root);
    }

    public void makeEJBClientJarWIO(Vector clientJarList) throws Exception {
        if (clientJarList == null) {
            return;
        }
        String prevEJBClientJar = ((EJBModuleDescriptor)this.getDescriptor()).getEJBClientJar();
        this.descriptor = (Descriptor)this.converter.getUserObject(this.getDescriptorTree());
        String ejbClientJar = ((EJBModuleDescriptor)this.getDescriptor()).getEJBClientJar();
        if (ejbClientJar == null) {
            return;
        }
        if (prevEJBClientJar != null && prevEJBClientJar != ejbClientJar) {
            Enumeration e = this.fileContents.elements();
            while (e.hasMoreElements()) {
                FileInfo fileInfo = (FileInfo)e.nextElement();
                if (!prevEJBClientJar.equals(fileInfo.getFileName())) continue;
                this.fileContents.remove(fileInfo);
            }
        }
        this.contents = new String[clientJarList.size()];
        for (int i = 0; i < clientJarList.size(); ++i) {
            this.contents[i] = (String)clientJarList.get(i);
        }
        String[] fileContents = new String[this.contents.length];
        String[] entries = new String[this.contents.length];
        String CLASS_EXTENSION = ".class";
        String jarPath = this.root + fs + ejbClientJar.replace('/', fsc);
        for (int i = 0; i < this.contents.length; ++i) {
            entries[i] = this.contents[i].replace('.', '/') + CLASS_EXTENSION;
            fileContents[i] = this.root + fs + this.contents[i].replace('.', fsc) + CLASS_EXTENSION;
        }
        JarManager.jar(jarPath, fileContents, entries);
    }
}

