/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.manager.common;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jeus.server.NodeControllerStub;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;

public class DistributeHandler {
    static String work_dir = WIOParameters.WORKING_DIR + WIOParameters.FS;
    public static final String CONFIG = "config";

    public static String retrieve(Hashtable nodeEngineList, int type) throws Exception {
        if (type == 2 || type == 4 || type == 3 || type == 1203) {
            return DistributeHandler.retrieveEngine(nodeEngineList, type);
        }
        if (type == 1 || type == 7 || type == 601 || type == 100 || type == 1200) {
            return DistributeHandler.retrieveSystem(nodeEngineList, type);
        }
        return null;
    }

    public static void distribute(Hashtable nodeEngineList, XMLTree valueTree, int type) throws Exception {
        if (type == 2 || type == 4 || type == 3 || type == 1203) {
            DistributeHandler.distributeEngine(nodeEngineList, valueTree, type);
        } else if (type == 1 || type == 7 || type == 601 || type == 100 || type == 1200) {
            DistributeHandler.distributeSystem(nodeEngineList, valueTree, type);
        }
    }

    public static String retrieveSystem(Hashtable nodeList, int type) throws Exception {
        String tmpSavePath = work_dir + WIOParameters.getMainFileName(type);
        try {
            Enumeration enum1 = nodeList.keys();
            while (enum1.hasMoreElements()) {
                String nodeName = (String)enum1.nextElement();
                NodeControllerStub nodeController = new NodeControllerStub();
                nodeController.connectTo(nodeName);
                String orgPath = "";
                orgPath = type == 601 ? "jeus:/config/" + nodeName + "/" + "JNLPServer" + "/" + WIOParameters.getMainFileName(type) : "jeus:/config/" + nodeName + "/" + WIOParameters.getMainFileName(type);
                nodeController.rftp(orgPath, tmpSavePath);
                nodeController.disconnect();
            }
        }
        catch (Exception e) {
            return null;
        }
        return tmpSavePath;
    }

    public static void distributeSystem(Hashtable nodeList, XMLTree valueTree, int type) throws Exception {
        String tmpSavePath = work_dir + WIOParameters.getMainFileName(type);
        XMLUtil xmlutil = new XMLUtil();
        File saveFile = new File(tmpSavePath);
        xmlutil.saveWIO(valueTree, type, saveFile);
        NodeControllerStub nodeController = new NodeControllerStub();
        Enumeration enum1 = nodeList.keys();
        while (enum1.hasMoreElements()) {
            String nodeName = (String)enum1.nextElement();
            nodeController.connectTo(nodeName);
            String destURI = null;
            destURI = type == 601 ? "jeus:/config/" + nodeName + "/" + "JNLPServer" + "/" + WIOParameters.getMainFileName(type) : "jeus:/config/" + nodeName + "/" + WIOParameters.getMainFileName(type);
            boolean result = nodeController.ftp(tmpSavePath, destURI, false);
            if (!result) {
                throw new Exception("FTP failed from " + tmpSavePath + " to " + destURI);
            }
            nodeController.disconnect();
        }
    }

    public static String getGroupName(String engineName) {
        String groupName = engineName;
        int endIndex = 0;
        if (engineName.indexOf("_ejb_") > 0) {
            endIndex = engineName.indexOf("_ejb_");
            groupName = engineName.substring(0, endIndex);
        } else if (engineName.indexOf("_servlet_") > 0) {
            endIndex = engineName.indexOf("_servlet_");
            groupName = engineName.substring(0, endIndex);
        } else if (engineName.indexOf("_jms_") > 0) {
            endIndex = engineName.indexOf("_jms_");
            groupName = engineName.substring(0, endIndex);
        } else if (engineName.indexOf("_ws_") > 0) {
            endIndex = engineName.indexOf("_ws_");
            groupName = engineName.substring(0, endIndex);
        } else if (engineName.indexOf("_jps_") > 0) {
            endIndex = engineName.indexOf("_jps_");
            groupName = engineName.substring(0, endIndex);
        }
        return groupName;
    }

    public static String retrieveEngine(Hashtable nodeList, int type) throws Exception {
        String tmpSavePath = work_dir + WIOParameters.getMainFileName(type);
        try {
            Enumeration enum1 = nodeList.keys();
            while (enum1.hasMoreElements()) {
                String nodeName = (String)enum1.nextElement();
                tmpSavePath = work_dir + nodeName + WIOParameters.FS + WIOParameters.getMainFileName(type);
                String engineName = (String)nodeList.get(nodeName);
                String groupName = DistributeHandler.getGroupName(engineName);
                NodeControllerStub nodeController = new NodeControllerStub();
                nodeController.connectTo(nodeName);
                String orgPath = "jeus:/config/" + groupName + "/" + engineName + "/" + WIOParameters.getMainFileName(type);
                nodeController.rftp(orgPath, tmpSavePath);
                nodeController.disconnect();
            }
        }
        catch (Exception e) {
            return null;
        }
        return tmpSavePath;
    }

    public static void distributeEngine(Hashtable nodeEngineList, XMLTree valueTree, int type) throws Exception {
        String tmpSavePath = work_dir + WIOParameters.getMainFileName(type);
        XMLUtil xmlutil = new XMLUtil();
        File saveFile = new File(tmpSavePath);
        xmlutil.saveWIO(valueTree, type, saveFile);
        NodeControllerStub nodeController = new NodeControllerStub();
        Enumeration enum1 = nodeEngineList.keys();
        while (enum1.hasMoreElements()) {
            String nodeName = (String)enum1.nextElement();
            Object engineListObject = nodeEngineList.get(nodeName);
            Vector engineList = new Vector();
            if (engineListObject instanceof Vector) {
                engineList = (Vector)nodeEngineList.get(nodeName);
            } else if (engineListObject instanceof Hashtable) {
                Hashtable engineGroupMap = (Hashtable)engineListObject;
                Enumeration engineEnum = engineGroupMap.keys();
                while (engineEnum.hasMoreElements()) {
                    String engineName = (String)engineEnum.nextElement();
                    engineList.add(engineName);
                }
            }
            nodeController.connectTo(nodeName);
            Enumeration e = engineList.elements();
            while (e.hasMoreElements()) {
                String engineName = (String)e.nextElement();
                String groupName = DistributeHandler.getGroupName(engineName);
                String destURI = "jeus:/config/" + groupName + "/" + engineName + "/" + WIOParameters.getMainFileName(type);
                boolean result = nodeController.ftp(tmpSavePath, destURI, false);
                if (result) continue;
                throw new Exception("FTP failed from " + tmpSavePath + " to " + destURI);
            }
            nodeController.disconnect();
        }
    }
}

