/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.manager.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import jeus.tool.manager.HowToGet;
import jeus.tool.manager.WIOContext;

public class ElementMapTable
implements Serializable {
    Hashtable mapping = new Hashtable();

    public Object get(int type, String value) {
        return this.mapping.get(new ElementMappingKey(type, value));
    }

    public Object get(WIOContext keyCtx) {
        if (keyCtx == null) {
            return null;
        }
        return this.mapping.get(new ElementMappingKey(keyCtx));
    }

    public void put(WIOContext key, Object val) {
        if (val == null) {
            return;
        }
        if (key == null) {
            return;
        }
        this.mapping.put(new ElementMappingKey(key), val);
    }

    public void put(int type, String name, Object val) {
        if (val == null) {
            return;
        }
        if (name == null) {
            return;
        }
        this.mapping.put(new ElementMappingKey(type, name), val);
    }

    public void remove(WIOContext key) {
        this.mapping.remove(new ElementMappingKey(key));
    }

    public void removeAll() {
        this.mapping.clear();
    }

    public Enumeration elements() {
        return this.mapping.elements();
    }

    public boolean containsKey(WIOContext key) {
        return this.mapping.containsKey(new ElementMappingKey(key));
    }

    public boolean containsKey(int type, String val) {
        return this.mapping.containsKey(new ElementMappingKey(type, val));
    }

    public void clear() {
        this.mapping.clear();
    }

    public class ElementMappingKey {
        int type;
        String name = null;
        HowToGet howToReach = null;

        public ElementMappingKey(WIOContext ctx) {
            if (ctx != null) {
                this.type = ctx.getType();
                this.name = ctx.getValue();
                if (ctx.howToGet() != null) {
                    this.howToReach = ctx.howToGet();
                }
            }
        }

        public ElementMappingKey(int type, String name) {
            this.type = type;
            this.name = name;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public HowToGet howToGet() {
            return this.howToReach;
        }

        public boolean equals(Object otherObject) {
            ElementMappingKey otherKey;
            if (otherObject instanceof ElementMappingKey && (otherKey = (ElementMappingKey)otherObject).getType() == this.type && otherKey.getName().equals(this.name)) {
                if (this.howToReach != null) {
                    if (otherKey.howToGet() == null) {
                        return false;
                    }
                    String[] myNames = this.howToReach.getMyNames();
                    if (myNames != null) {
                        if (otherKey.howToGet().getMyNames() == null) {
                            return false;
                        }
                        int myNameSize = myNames.length;
                        String[] comparedNames = otherKey.howToGet().getMyNames();
                        int comparedSize = comparedNames.length;
                        if (myNameSize != comparedSize) {
                            return false;
                        }
                        for (int kk = 0; kk < myNameSize; ++kk) {
                            if (myNames[kk].equals(comparedNames[kk])) continue;
                            return false;
                        }
                        return true;
                    }
                    return otherKey.howToGet().getMyNames() == null;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append("type=" + this.type);
            str.append(" ");
            str.append("name=" + this.name);
            str.append(" ");
            if (this.howToReach != null) {
                str.append("howToRead=" + this.howToReach);
            }
            return str.toString();
        }
    }
}

