/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.monitorapi.monitorinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import jeus.jdbc.info.CPInfo;
import jeus.tool.monitorapi.EJBEngineMonitorManager;
import jeus.tool.monitorapi.JMSEngineMonitorManager;
import jeus.tool.monitorapi.ServletEngineMonitorManager;
import jeus.tool.monitorapi.monitorinfo.EJBEngineMonitorInfo;
import jeus.tool.monitorapi.monitorinfo.JMSEngineMonitorInfo;
import jeus.tool.monitorapi.monitorinfo.MonitorInfo;
import jeus.tool.monitorapi.monitorinfo.ServletEngineMonitorInfo;

public class EngineContainerMonitorInfo
implements MonitorInfo,
Serializable {
    Vector engineList = new Vector();
    CPInfo[] cpInfos = null;
    private String CONTAINER_NAME = "";

    public void setEngineList(Vector list) {
        this.engineList = list;
    }

    public void setContainerName(String containerName) {
        this.CONTAINER_NAME = containerName;
    }

    public void setCPInfos(CPInfo[] infos) {
        this.cpInfos = infos;
    }

    public boolean checkEngineAlive(String engineName) {
        return this.engineList != null && this.engineList.contains(engineName);
    }

    public String getContainerName() {
        return this.CONTAINER_NAME;
    }

    public int getAliveEngineCount() {
        if (this.engineList == null) {
            return 0;
        }
        return this.engineList.size();
    }

    public Iterator getAliveEngineList() {
        return this.engineList.iterator();
    }

    public int getIdleDBConnectionCount() {
        if (this.cpInfos == null || this.cpInfos.length == 0) {
            return -1;
        }
        CPInfo oneInfo = this.cpInfos[0];
        return oneInfo.getIdle();
    }

    public int getIdleDBConnectionCount(String cpName) {
        if (this.cpInfos == null || this.cpInfos.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.cpInfos.length; ++i) {
            CPInfo oneInfo = this.cpInfos[i];
            if (!oneInfo.getName().equals(cpName)) continue;
            return oneInfo.getIdle();
        }
        return -1;
    }

    public int getMaxDBConnectionCount(String cpName) {
        if (this.cpInfos == null || this.cpInfos.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.cpInfos.length; ++i) {
            CPInfo oneInfo = this.cpInfos[i];
            if (!oneInfo.getName().equals(cpName)) continue;
            return oneInfo.getMax();
        }
        return -1;
    }

    public int getMinDBConnectionCount(String cpName) {
        if (this.cpInfos == null || this.cpInfos.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.cpInfos.length; ++i) {
            CPInfo oneInfo = this.cpInfos[i];
            if (!oneInfo.getName().equals(cpName)) continue;
            return oneInfo.getMin();
        }
        return -1;
    }

    public boolean getWaitingDBConnection(String cpName) {
        if (this.cpInfos == null || this.cpInfos.length == 0) {
            return false;
        }
        for (int i = 0; i < this.cpInfos.length; ++i) {
            CPInfo oneInfo = this.cpInfos[i];
            if (!oneInfo.getName().equals(cpName)) continue;
            return oneInfo.isWaiting();
        }
        return false;
    }

    public boolean getWorkingDBConnection(String cpName) {
        if (this.cpInfos == null || this.cpInfos.length == 0) {
            return false;
        }
        for (int i = 0; i < this.cpInfos.length; ++i) {
            CPInfo oneInfo = this.cpInfos[i];
            if (!oneInfo.getName().equals(cpName)) continue;
            return oneInfo.isWorking();
        }
        return false;
    }

    public int getCurrentDBConnectionCount(String cpName) {
        if (this.cpInfos == null || this.cpInfos.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.cpInfos.length; ++i) {
            CPInfo oneInfo = this.cpInfos[i];
            if (!oneInfo.getName().equals(cpName)) continue;
            return oneInfo.getActive() + oneInfo.getIdle();
        }
        return -1;
    }

    public Iterator getDBConnectionList() {
        ArrayList<String> nameList = new ArrayList<String>();
        for (int i = 0; i < this.cpInfos.length; ++i) {
            CPInfo oneInfo = this.cpInfos[i];
            nameList.add(oneInfo.getName());
        }
        return nameList.iterator();
    }

    public ServletEngineMonitorInfo getServletEngineMonitorInfo() {
        Iterator engineIter = this.engineList.iterator();
        ServletEngineMonitorInfo servletEngMonitorInfo = new ServletEngineMonitorInfo();
        boolean notExist = true;
        try {
            while (engineIter.hasNext()) {
                String engineName = (String)engineIter.next();
                if (engineName.indexOf("_servlet") <= 0) continue;
                notExist = false;
                String[] arg = new String[]{engineName};
                ServletEngineMonitorManager servletMng = new ServletEngineMonitorManager("", arg);
                servletEngMonitorInfo = (ServletEngineMonitorInfo)servletMng.getMonitorInfo();
            }
            if (notExist) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return servletEngMonitorInfo;
    }

    public JMSEngineMonitorInfo getJMSEngineMonitorInfo() {
        Iterator engineIter = this.engineList.iterator();
        ArrayList<JMSEngineMonitorInfo> jmsEngineMonitorList = new ArrayList<JMSEngineMonitorInfo>();
        JMSEngineMonitorInfo jmsEngMonitorInfo = new JMSEngineMonitorInfo();
        boolean notExist = true;
        try {
            while (engineIter.hasNext()) {
                String engineName = (String)engineIter.next();
                if (engineName.indexOf("_jms") <= 0) continue;
                notExist = false;
                String[] arg = new String[]{engineName};
                JMSEngineMonitorManager jmsMng = new JMSEngineMonitorManager("", arg);
                jmsEngMonitorInfo = (JMSEngineMonitorInfo)jmsMng.getMonitorInfo();
                jmsEngineMonitorList.add(jmsEngMonitorInfo);
            }
            if (notExist) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return jmsEngMonitorInfo;
    }

    public EJBEngineMonitorInfo getEJBEngineMonitorInfo() {
        Iterator engineIter = this.engineList.iterator();
        EJBEngineMonitorInfo ejbEngMonitorInfo = new EJBEngineMonitorInfo();
        boolean notExist = true;
        try {
            while (engineIter.hasNext()) {
                String engineName = (String)engineIter.next();
                if (engineName.indexOf("_ejb") <= 0) continue;
                notExist = false;
                String[] arg = new String[]{engineName};
                EJBEngineMonitorManager ejbMng = new EJBEngineMonitorManager("", arg);
                ejbEngMonitorInfo = (EJBEngineMonitorInfo)ejbMng.getMonitorInfo();
            }
            if (notExist) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ejbEngMonitorInfo;
    }
}

