/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.resource.xsd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jeus.tool.resource.xsd.DefinedValue;
import jeus.tool.resource.xsd.OccurrenceType;
import jeus.tool.resource.xsd.XMLSchemaResource;

public class ElementDocument
implements Serializable {
    private String id;
    private String displayId;
    private String name;
    private String label;
    private String description;
    private String valueType;
    private String defaultValue;
    private List definedValues = new ArrayList();
    private String example;
    private String performanceRecommentation;
    private boolean deprecated;
    private transient String key;
    private String valueTypeDescription;
    private String valueDescription;
    private OccurrenceType occurrence = OccurrenceType.ONE;
    private String parent;
    private boolean definedValueOverrided;
    private boolean hidden;
    private List children = new ArrayList();
    public static final ElementDocument SHARED_NULL = new ElementDocument("0");
    public static final String ROOT_ID = "1";

    public ElementDocument(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayId() {
        return this.displayId;
    }

    public void setDisplayId(String displayId) {
        this.displayId = displayId;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public List getDefinedValues() {
        return Collections.unmodifiableList(this.definedValues);
    }

    public boolean isDefinedValueOverrided() {
        return this.definedValueOverrided;
    }

    public void setDefinedValueOverrided(boolean definedValueOverrided) {
        this.definedValueOverrided = definedValueOverrided;
    }

    public void addDefinedValue(String value, String description, boolean display) {
        if (this.definedValueOverrided) {
            return;
        }
        this.definedValues.add(new DefinedValue(value, description, display));
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defualtValue) {
        this.defaultValue = defualtValue;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPerformanceRecommendation() {
        return this.performanceRecommentation;
    }

    public void setPerformanceRecommentation(String performanceRecommentation) {
        this.performanceRecommentation = performanceRecommentation;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getValueTypeDescription() {
        return this.valueTypeDescription;
    }

    public void setValueTypeDescription(String valueTypeDescription) {
        this.valueTypeDescription = valueTypeDescription;
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(String id) {
        this.children.add(id);
    }

    public String getValueDescription() {
        return this.valueDescription;
    }

    public void setValueDescription(String valueDescription) {
        this.valueDescription = valueDescription;
    }

    public OccurrenceType getOccurrence() {
        return this.occurrence;
    }

    public void setOccurrence(OccurrenceType occurrence) {
        this.occurrence = occurrence;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public List getAncestors(XMLSchemaResource resource) {
        LinkedList<ElementDocument> path = new LinkedList<ElementDocument>();
        ElementDocument elemDoc = this;
        while (elemDoc.getParent() != null) {
            if ((elemDoc = resource.getElementDocument(elemDoc.getParent())) == null) {
                return Collections.EMPTY_LIST;
            }
            path.addFirst(elemDoc);
        }
        return path;
    }

    public boolean equals(Object obj) {
        return obj instanceof ElementDocument && obj.toString().equals(this.id);
    }

    public String toString() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

