/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jeus.tool.util.FileUtil;
import jeus.util.file.FileUtils;

public class JarManager {
    private static final String fs = System.getProperty("file.separator");
    private static final char fsc = fs.charAt(0);

    public static void unJar(String srcJarName, String dstPath) throws Exception {
        ZipFile srcJar = null;
        ZipEntry entry = null;
        String entryName = null;
        String dstFileName = null;
        File dstFile = null;
        srcJar = new ZipFile(srcJarName);
        Enumeration<? extends ZipEntry> enum1 = srcJar.entries();
        while (enum1.hasMoreElements()) {
            entry = enum1.nextElement();
            entryName = entry.getName();
            dstFileName = dstPath + fs + entryName.replace('/', fsc);
            dstFile = new File(dstFileName);
            if (FileUtils.isDirectory((ZipEntry)entry)) {
                dstFile.mkdirs();
            } else {
                File parentFile = dstFile.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                FileOutputStream outstr = new FileOutputStream(dstFile);
                InputStream instr = srcJar.getInputStream(entry);
                FileUtil.copy(instr, outstr);
                instr.close();
                outstr.close();
            }
            dstFile.setLastModified(entry.getTime());
        }
        srcJar.close();
    }

    public static String[] getEntries(String filename) throws IOException {
        JarFile jarFile = new JarFile(filename);
        return JarManager.getEntries(jarFile);
    }

    public static String[] getEntries(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        return JarManager.getEntries(jarFile);
    }

    public static String[] getEntries(JarFile jarFile) throws IOException {
        Enumeration<JarEntry> e = jarFile.entries();
        Vector<String> entrySet = new Vector<String>();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            entrySet.add(entry.getName());
        }
        jarFile.close();
        Object[] objects = entrySet.toArray();
        String[] entries = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            entries[i] = (String)objects[i];
        }
        return entries;
    }

    public static boolean existInJar(String jarName, String entryName) throws IOException {
        JarFile jarFile = new JarFile(jarName);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().equals(entryName)) continue;
            jarFile.close();
            return true;
        }
        jarFile.close();
        return false;
    }

    public static void jar(String targetJarName, String[] contents, String[] entries) throws IOException {
        File targetFile = new File(targetJarName);
        File parentFile = targetFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        targetFile.createNewFile();
        JarManager.jar(targetFile, contents, entries);
    }

    public static void jar(File targetFile, String[] contents, String[] entries) throws IOException {
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(targetFile));
        for (int i = 0; i < contents.length; ++i) {
            File file = new File(contents[i]);
            JarEntry e = new JarEntry(entries[i]);
            e.setTime(file.lastModified());
            jos.putNextEntry(e);
            if (file.isFile()) {
                FileInputStream is = new FileInputStream(file);
                FileUtil.copy(is, jos);
            }
            jos.closeEntry();
        }
        jos.close();
    }

    public static void jar(String targetJarName, String root) throws IOException {
        File targetFile = new File(targetJarName);
        File parentFile = targetFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        targetFile.createNewFile();
        JarManager.jar(targetFile, root);
    }

    public static void jar(File targetFile, String root) throws IOException {
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(targetFile));
        File[] contents = FileUtil.listAllFiles(root);
        for (int i = 0; i < contents.length; ++i) {
            String path = contents[i].isDirectory() ? contents[i].getPath() + fs : contents[i].getPath();
            String uri = path.substring(root.length());
            String entry = uri.startsWith(fs) ? uri.substring(1).replace(fsc, '/') : uri.replace(fsc, '/');
            jos.putNextEntry(new JarEntry(entry));
            if (contents[i].isFile()) {
                FileInputStream is = new FileInputStream(contents[i]);
                FileUtil.copy(is, jos);
            }
            jos.closeEntry();
        }
        jos.close();
    }
}

