/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class JeusDirectoryScanner {
    public String[] getIncludedFiles(File baseDir, String[] acceptableExtension) {
        Vector<String> v = new Vector<String>();
        try {
            for (File next : JeusDirectoryScanner.getAllFilesUnder(baseDir, new FileNameFilterExtension(acceptableExtension))) {
                v.add(next.getPath());
            }
        }
        finally {
            ArrayList myArray = new ArrayList(v);
            return myArray.toArray(new String[0]);
        }
        {
        }
    }

    public static File relativize(File parent, File child) {
        String baseDir = parent.getAbsolutePath();
        String baseDirAndChild = child.getAbsolutePath();
        String relative = baseDirAndChild.substring(baseDir.length(), baseDirAndChild.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return new File(relative);
    }

    public static Set getAllFilesUnder(File directory, FilenameFilter filenameFilter) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        TreeSet allFiles = new TreeSet();
        JeusDirectoryScanner.recursiveGetFilesUnder(directory, directory, filenameFilter, allFiles, false);
        return allFiles;
    }

    private static void recursiveGetFilesUnder(File relativizingRoot, File directory, FilenameFilter filenameFilter, Set set, boolean returnDirectories) {
        File[] files = directory.listFiles(filenameFilter);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                JeusDirectoryScanner.recursiveGetFilesUnder(relativizingRoot, files[i], filenameFilter, set, returnDirectories);
                if (!returnDirectories) continue;
                set.add(JeusDirectoryScanner.relativize(relativizingRoot, files[i]));
                continue;
            }
            set.add(JeusDirectoryScanner.relativize(relativizingRoot, files[i]));
        }
    }

    public class FileNameFilterExtension
    implements FilenameFilter {
        String[] acceptableExtensions = null;

        FileNameFilterExtension(String[] extensions) {
            this.acceptableExtensions = extensions;
        }

        public boolean accept(File dir, String name) {
            if (this.acceptableExtensions == null) {
                return true;
            }
            for (int k = 0; k < this.acceptableExtensions.length; ++k) {
                if (!name.endsWith(this.acceptableExtensions[k])) continue;
                return true;
            }
            File tmpFile = new File(dir, name);
            return tmpFile.isDirectory();
        }
    }
}

