/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class URLUtil {
    public static URL resolve(String s) throws MalformedURLException {
        return URLUtil.resolve(s, null);
    }

    public static URL resolve(String s, URL url) throws MalformedURLException {
        URL resolve = null;
        if (s.indexOf("://") > -1 || s.indexOf("file:") > -1) {
            resolve = new URL(s);
        } else if (url != null) {
            resolve = new URL(url, s);
        } else if (s.startsWith(File.separator) || s.startsWith("/") || s.length() >= 2 && Character.isLetter(s.charAt(0)) && s.charAt(1) == ':') {
            String fName = s;
            try {
                fName = new File(s).getCanonicalPath();
            }
            catch (NullPointerException npe) {
            }
            catch (IOException npe) {
                // empty catch block
            }
            resolve = new URL("file", "", fName);
        } else {
            String path = System.getProperty("user.dir") + File.separator + s;
            resolve = new URL("file", "", path);
        }
        if (!resolve.getProtocol().equalsIgnoreCase("war") && resolve.getFile().toLowerCase().endsWith(".war")) {
            URL u;
            resolve = u = new URL("war:" + resolve.toString());
        }
        resolve = new URL(URLUtil.trim(resolve.toString(), ".", ".."));
        resolve = new URL(URLUtil.trim(resolve.toString(), "./"));
        return resolve;
    }

    private static String trim(String s, String t) {
        return URLUtil.trim(s, t, null);
    }

    private static String trim(String s, String r, String t) {
        while (s.endsWith(r) && (t == null || !s.endsWith(t))) {
            int i = s.length() - r.length();
            s = s.substring(0, i);
        }
        return s;
    }
}

