/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import jeus.tool.xmlui.IColumnParser;
import jeus.tool.xmlui.schema.XMLUIContainer;
import jeus.tool.xmlui.schema.XMLUIElement;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Element;

public class DefaultColumnParser
implements IColumnParser {
    private String[] cols;
    private Set empties = new HashSet();
    private static Set AVAILABLE_TYPES = new HashSet();

    public String[] getColumns(XMLUIContainer cc) {
        if (cc.getColumnNames().length > 0) {
            this.cols = cc.getColumnNames();
            return this.cols;
        }
        ArrayList<String> columns = new ArrayList<String>();
        XMLUIElement[] subItems = cc.getConfigItem();
        for (int i = 0; i < subItems.length; ++i) {
            String itemType = subItems[i].getItemType();
            int p = itemType.indexOf("[");
            if (p > 0) {
                itemType = itemType.substring(0, p);
            }
            if (itemType != null && itemType.trim().length() != 0 && !AVAILABLE_TYPES.contains(itemType)) continue;
            columns.add(subItems[i].getName());
            if (itemType == null || !itemType.equals("empty")) continue;
            this.empties.add(subItems[i].getName());
        }
        if (columns.size() == 0) {
            this.cols = new String[]{null};
            return new String[]{"data"};
        }
        this.cols = columns.toArray(new String[columns.size()]);
        return this.cols;
    }

    public String[] getRow(XMLUIContainer cc, Element element) {
        String[] exprs = cc.getColumnExprs();
        if (exprs == null || exprs.length == 0) {
            exprs = this.getColumns(cc);
        }
        if (this.cols.length == 1 && this.cols[0] == null) {
            if (cc != null) {
                return new String[]{XMLUtil.getValue(element)};
            }
            return new String[]{""};
        }
        String[] data = new String[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            String expr = exprs[i];
            boolean empty = false;
            boolean hasElementName = false;
            if (expr.startsWith("@") || this.empties.contains(expr)) {
                if (expr.startsWith("@")) {
                    expr = expr.substring(1);
                }
                empty = true;
            }
            Vector context = new Vector();
            context.add(element);
            boolean reached = true;
            StringTokenizer stk = new StringTokenizer(expr, "/");
            while (stk.hasMoreTokens()) {
                String token = stk.nextToken();
                Element first = (Element)context.get(0);
                if (token.equals("*")) {
                    context = XMLUtil.getChildNodes(first);
                } else {
                    if (token.equals("%")) {
                        hasElementName = true;
                        break;
                    }
                    if (token.startsWith("[") && token.endsWith("]")) {
                        StringTokenizer cstk = new StringTokenizer(token.substring(1, token.length() - 1), "|");
                        while (cstk.hasMoreTokens()) {
                            String subexpr = cstk.nextToken().trim();
                            if (subexpr.equals("%")) {
                                hasElementName = true;
                            } else {
                                context = XMLUtil.getChildNodes(first, subexpr);
                                if (context == null || context.size() <= 0) continue;
                            }
                            break;
                        }
                    } else {
                        context = XMLUtil.getChildNodes(first, token);
                    }
                }
                if (context != null && context.size() != 0 && !hasElementName) continue;
                reached = false;
                context = new Vector();
                context.add(first);
                break;
            }
            if (hasElementName) {
                data[i] = XMLUtil.getName((Element)context.get(0));
                continue;
            }
            if (context == null || context.size() == 0) {
                data[i] = "";
                continue;
            }
            Vector elements = context;
            if (empty) {
                if (reached && elements.size() > 0) {
                    data[i] = "true";
                    continue;
                }
                data[i] = "false";
                continue;
            }
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < elements.size(); ++j) {
                String value = XMLUtil.getValue((Element)elements.get(j));
                buf.append(value == null ? "" : value);
                if (j + 1 >= elements.size()) continue;
                buf.append(", ");
            }
            data[i] = buf.toString();
        }
        return data;
    }

    static {
        AVAILABLE_TYPES.add("string");
        AVAILABLE_TYPES.add("empty");
        AVAILABLE_TYPES.add("choice");
        AVAILABLE_TYPES.add("echoice");
        AVAILABLE_TYPES.add("boolean");
        AVAILABLE_TYPES.add("int");
        AVAILABLE_TYPES.add("float");
        AVAILABLE_TYPES.add("long");
        AVAILABLE_TYPES.add("double");
        AVAILABLE_TYPES.add("date");
        AVAILABLE_TYPES.add("dateTime");
        AVAILABLE_TYPES.add("qname");
        AVAILABLE_TYPES.add("referred");
    }
}

