/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import jeus.tool.xmlui.FlatXMLUIPanel;
import jeus.tool.xmlui.ListXMLUIPanel;
import jeus.tool.xmlui.TabXMLUIPanel;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.tool.xmlui.engine.XMLUISession;
import jeus.tool.xmlui.schema.XMLUIContainer;

public class XMLUIPanelFactory {
    public static XMLUIPanel createXMLUIPanel(XMLUIContainer container, XMLUISession session) {
        return XMLUIPanelFactory.createXMLUIPanel(container, false, session);
    }

    public static XMLUIPanel createXMLUIPanel(XMLUIContainer container, boolean sub, XMLUISession session) {
        XMLUIPanel configPanel = null;
        try {
            String uiclass = null;
            uiclass = sub ? container.getContainerUIClass() : container.getSubContainerUIClass();
            if (uiclass != null) {
                Class<?> containerPanelClass = Class.forName(uiclass);
                Constructor<?> c = containerPanelClass.getConstructor(XMLUISession.class, Object.class);
                configPanel = (XMLUIPanel)c.newInstance(session, container);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (configPanel == null) {
            String layout = null;
            layout = !sub ? container.getLayOut() : container.getSubLayOut();
            configPanel = layout.equals("tab") ? new TabXMLUIPanel(session, (Object)container) : (layout.equals("list") ? new ListXMLUIPanel(session, (Object)container) : new FlatXMLUIPanel(session, (Object)container));
        }
        configPanel.initialize(Collections.EMPTY_MAP);
        configPanel.prepareResources(container);
        return configPanel;
    }

    public static XMLUIPanel createXMLUIPanel(XMLUIContainer container, boolean sub, XMLUIEngine engine, Map attrs) {
        XMLUIPanel configPanel = null;
        try {
            String uiclass = null;
            uiclass = sub ? container.getContainerUIClass() : container.getSubContainerUIClass();
            Class<?> containerPanelClass = Class.forName(uiclass);
            Constructor<?> c = containerPanelClass.getConstructor(XMLUIEngine.class, Object.class);
            configPanel = (XMLUIPanel)c.newInstance(engine, container);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (configPanel == null) {
            String layout = null;
            layout = !sub ? container.getLayOut() : container.getSubLayOut();
            configPanel = layout.equals("tab") ? new TabXMLUIPanel(engine, (Object)container) : (layout.equals("list") ? new ListXMLUIPanel(engine, (Object)container) : new FlatXMLUIPanel(engine, (Object)container));
        }
        configPanel.initialize(attrs);
        configPanel.prepareResources(container);
        return configPanel;
    }

    public static XMLUIPanel createXMLUIPanel(XMLUIContainer container, boolean sub, XMLUIEngine engine) {
        return XMLUIPanelFactory.createXMLUIPanel(container, sub, engine, Collections.EMPTY_MAP);
    }
}

