/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jeus.tool.xmlui.DefaultColumnParser;
import jeus.tool.xmlui.IColumnParser;
import jeus.tool.xmlui.PanelChooser;
import jeus.tool.xmlui.XMLUIDialog;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.XMLUIPanelFactory;
import jeus.tool.xmlui.engine.ChangeHistory;
import jeus.tool.xmlui.engine.OperationType;
import jeus.tool.xmlui.engine.XMLUISession;
import jeus.tool.xmlui.schema.XMLUIChoice;
import jeus.tool.xmlui.schema.XMLUIContainer;
import jeus.tool.xmlui.util.MessageUtil;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Element;

public class XMLUIPanelList
extends XMLUIPanel
implements ActionListener,
ListSelectionListener {
    TitledBorder titledBorder1;
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable displayTable = new JTable();
    XMLTreeTableModel tableModel;
    public JButton removeBT = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    public JButton addBT = new JButton();
    public JButton modifyBT = new JButton();
    protected String title = "List Display Pane";
    private boolean isDuplicationEnabled = true;
    public static final String ADD = "Add";
    public static final String MODIFY = "Modify";
    public int mode = 0;
    public static final int EDIT_MODE = 0;
    public static final int BROWSE_MODE = 1;
    public boolean removeDisable = false;
    protected XMLUIContainer configContainer;
    private boolean initializing = false;
    private int minOccurs = 0;
    private int maxOccurs = 1;
    protected ArrayList exclusiveList = new ArrayList();
    protected ArrayList exclusiveContainers = new ArrayList();

    protected void init(String title) {
        this.title = title;
        this.addActionListenerToAddCommand(this);
        this.addActionListenerToModifyCommand(this);
        this.addActionListenerToRemoveCommand(this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XMLUIPanelList() {
        this.init(null);
    }

    public XMLUIPanelList(String title) {
        this.init(title);
    }

    public boolean isExclusive() {
        return this.exclusiveList.size() > 0;
    }

    public boolean contains(String name) {
        return this.exclusiveList.contains(name);
    }

    public XMLUIPanelList(XMLUISession session, Object descriptor) {
        super(session, descriptor);
        XMLUIContainer anyConfig;
        this.configContainer = anyConfig = (XMLUIContainer)descriptor;
        if (anyConfig instanceof XMLUIChoice) {
            XMLUIContainer[] exclusiveContainerList = anyConfig.getConfigContainer();
            if (exclusiveContainerList != null) {
                for (int j = 0; j < exclusiveContainerList.length; ++j) {
                    this.exclusiveList.add(exclusiveContainerList[j].getName());
                    exclusiveContainerList[j].setGlobalID(anyConfig.getGlobalID());
                    this.exclusiveContainers.add(exclusiveContainerList[j]);
                }
            }
        } else if (anyConfig.getName().startsWith("$")) {
            throw new IllegalArgumentException("exept choice, $ui-name$ xml ui config is not allowed in list panel.");
        }
        this.init(anyConfig.getName());
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addBT.setEnabled(enabled);
        if (enabled && this.displayTable.getSelectedRowCount() > 0) {
            this.removeBT.setEnabled(enabled);
        } else {
            this.removeBT.setEnabled(false);
        }
        if (enabled) {
            this.modifyBT.setText(MessageUtil.getMessage(this.getEngine(), "message:xmlui.modify", MODIFY));
        } else {
            this.modifyBT.setText(MessageUtil.getMessage(this.getEngine(), "message:xmlui.browse", "Browse"));
        }
    }

    public Object getValue() {
        this.clearMessage();
        if (!this.isEnabled()) {
            return null;
        }
        Object[] vals = this.getValues();
        if (vals.length < this.minOccurs) {
            this.addMessage(MessageUtil.getMessage(this.getEngine(), "At least {0} @XPATH@ must be set.", new String[]{String.valueOf(this.minOccurs)}));
            return null;
        }
        Vector<Object> treeList = new Vector<Object>();
        for (int i = 0; i < vals.length; ++i) {
            treeList.add(vals[i]);
        }
        return treeList;
    }

    public void clear() {
        if (this.tableModel != null) {
            this.tableModel.clear();
        }
    }

    public void resetValue() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object val) {
        this.initializing = true;
        try {
            this.clear();
            if (val instanceof Vector) {
                Vector valueList = (Vector)val;
                Enumeration enum1 = valueList.elements();
                while (enum1.hasMoreElements() && this.tableModel.getRowCount() < this.maxOccurs) {
                    Element itemTree = (Element)enum1.nextElement();
                    this.addItem(itemTree);
                }
                if (this.tableModel.getRowCount() == this.maxOccurs) {
                    this.addBT.setEnabled(false);
                }
            }
        }
        finally {
            this.initializing = false;
        }
    }

    public void setValueFinish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueExclusive(Object val) {
        this.initializing = true;
        try {
            if (val instanceof Vector) {
                Vector valueList = (Vector)val;
                Enumeration enum1 = valueList.elements();
                while (enum1.hasMoreElements() && valueList.size() < this.maxOccurs) {
                    Element itemTree = (Element)enum1.nextElement();
                    this.addItem(itemTree);
                }
            }
        }
        finally {
            this.initializing = false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addBT) {
            this.add();
        } else if (e.getSource() == this.modifyBT) {
            this.modify();
        } else if (e.getSource() == this.removeBT) {
            if (this.removeDisable) {
                this.removeNothing();
            } else {
                this.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(XMLUIContainer config) {
        this.getSession().addAttribute("xmlui.add", Boolean.TRUE);
        try {
            XMLUIPanel pane = XMLUIPanelFactory.createXMLUIPanel(config, true, this.getSession());
            pane.setTitle(this.configContainer.getDisplayName());
            XMLUIDialog dlg = new XMLUIDialog(pane);
            dlg.setCustomizeErrorDlg();
            dlg.showDialog();
            if (!dlg.getOk()) {
                return;
            }
            Element oneChildXML = (Element)dlg.getValue();
            this.addItem(oneChildXML);
        }
        finally {
            this.getSession().addAttribute("xmlui.add", Boolean.FALSE);
        }
        this.setChanged(true);
    }

    public void add() {
        if (this.exclusiveList != null && this.exclusiveList.size() > 0) {
            PanelChooser pane = new PanelChooser(this.exclusiveList);
            pane.setTitle("Type Selection Dialog");
            XMLUIDialog dlg = new XMLUIDialog(pane);
            dlg.setCustomizeErrorDlg();
            dlg.showDialog();
            if (!dlg.getOk()) {
                return;
            }
            pane.createConfig();
            Integer selectionIndex = (Integer)pane.getConfigObject();
            this.add((XMLUIContainer)this.exclusiveContainers.get(selectionIndex));
        } else {
            this.add(this.configContainer);
        }
    }

    public void modify(XMLUIContainer config, Element xmlTree, int index) {
        XMLUIPanel pane = XMLUIPanelFactory.createXMLUIPanel(config, true, this.getSession());
        pane.setTitle(config.getDisplayName());
        if (!this.isEnabled()) {
            pane.setEnabled(this.isEnabled());
        }
        pane.setName(config.getName());
        pane.setDisplayName(config.getDisplayName());
        pane.setValue(xmlTree);
        XMLUIDialog dlg = new XMLUIDialog(pane);
        dlg.showDialog();
        dlg.setCustomizeErrorDlg();
        if (!dlg.getOk()) {
            return;
        }
        xmlTree = (Element)dlg.getValue();
        this.modifyValueAt(index, xmlTree);
        if (!this.initializing) {
            this.session.fireXMLUIEvent(this, xmlTree, OperationType.UPDATE);
        }
    }

    public void modify() {
        if (this.exclusiveList != null && this.exclusiveList.size() > 0) {
            Object object = this.getSelectedValue();
            if (object == null) {
                return;
            }
            int index = this.getSelectedIndex();
            Element oneChildXML = (Element)object;
            if (XMLUtil.getName(oneChildXML) == null) {
                return;
            }
            int typeIndex = this.exclusiveList.indexOf(XMLUtil.getName(oneChildXML));
            if (typeIndex == -1) {
                typeIndex = 0;
            }
            XMLUIContainer selectedConfig = (XMLUIContainer)this.exclusiveContainers.get(typeIndex);
            this.modify(selectedConfig, oneChildXML, index);
        } else {
            Object object = this.getSelectedValue();
            if (object == null) {
                return;
            }
            int index = this.getSelectedIndex();
            Element oneChildXML = (Element)object;
            this.modify(this.configContainer, oneChildXML, index);
        }
        this.setChanged(true);
    }

    public void removeNothing() {
    }

    public void setListDisabled() {
        this.addBT.setEnabled(false);
        this.modifyBT.setEnabled(false);
        this.removeBT.setEnabled(false);
    }

    public void setListEnabled() {
        this.addBT.setEnabled(true);
        this.modifyBT.setEnabled(true);
        this.removeBT.setEnabled(true);
    }

    public void setDuplicationEnabled(boolean isDuplicationEnabled) {
        this.isDuplicationEnabled = isDuplicationEnabled;
    }

    public void addActionListenerToAddCommand(ActionListener listener) {
        this.addBT.addActionListener(listener);
    }

    public void addActionListenerToModifyCommand(ActionListener listener) {
        this.modifyBT.addActionListener(listener);
    }

    public void addActionListenerToRemoveCommand(ActionListener listener) {
        this.removeBT.addActionListener(listener);
    }

    public void removeModifyButton() {
        this.remove(this.modifyBT);
    }

    public void setModificationEnabled(boolean isModificationEnabled) {
        this.modifyBT.setVisible(isModificationEnabled);
        this.modifyBT.setEnabled(isModificationEnabled);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.removeBT.setMaximumSize(new Dimension(79, 29));
        this.removeBT.setText(MessageUtil.getMessage(this.getEngine(), "message:xmlui.remove", "Remove"));
        this.addBT.setText(MessageUtil.getMessage(this.getEngine(), "message:xmlui.add", ADD));
        this.modifyBT.setText(MessageUtil.getMessage(this.getEngine(), "message:xmlui.modify", MODIFY));
        String columnParser = this.configContainer.getMultiColumnParser();
        if (columnParser != null && columnParser.trim().length() > 0) {
            try {
                IColumnParser parser = (IColumnParser)Class.forName(columnParser).newInstance();
                this.tableModel = new XMLTreeTableModel(this.configContainer, parser);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.tableModel == null) {
            this.tableModel = new XMLTreeTableModel(this.configContainer);
        }
        this.displayTable.setModel(this.tableModel);
        this.displayTable.getSelectionModel().addListSelectionListener(this);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 131));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        int bti = 1;
        if (this.configContainer.getListmode().indexOf("a") >= 0) {
            this.add((Component)this.addBT, new GridBagConstraints(1, bti++, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (this.configContainer.getListmode().indexOf("r") >= 0) {
            this.add((Component)this.removeBT, new GridBagConstraints(1, bti++, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (this.configContainer.getListmode().indexOf("m") >= 0) {
            this.add((Component)this.modifyBT, new GridBagConstraints(1, bti++, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.jScrollPane1.getViewport().add((Component)this.displayTable, null);
        this.modifyBT.setEnabled(false);
        this.removeBT.setEnabled(false);
    }

    public void modifyPreferredSize(Dimension dim) {
        this.jScrollPane1.setPreferredSize(dim);
    }

    public void setBrowseMode() {
        this.addBT.setEnabled(false);
        this.removeBT.setEnabled(false);
        this.modifyBT.setText(MessageUtil.getMessage(this.getEngine(), "message:xmlui.browse", "Browse"));
        this.mode = 1;
    }

    public void remove() {
        int[] rows = this.displayTable.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            Element xmlTree = this.tableModel.get(rows[i]);
            this.removeElement(rows[i]);
            if (this.initializing) continue;
            this.session.fireXMLUIEvent(this, xmlTree, OperationType.REMOVE);
        }
        this.setChanged(true);
    }

    public void removeElement(int i) {
        this.tableModel.removeRow(i);
        if (this.tableModel.getSize() == 0) {
            this.removeBT.setEnabled(false);
            this.modifyBT.setEnabled(false);
        }
        if (this.tableModel.getRowCount() < this.maxOccurs && !this.addBT.isEnabled()) {
            this.addBT.setEnabled(true);
        }
        this.setChanged(true);
    }

    public boolean addItem(Object object) {
        if (!this.isDuplicationEnabled && this.existInList(object)) {
            return false;
        }
        this.tableModel.addXMLTree((Element)object);
        if (!this.initializing) {
            this.session.fireXMLUIEvent(this, (Element)object, OperationType.INSERT);
            ChangeHistory changeHistory = (ChangeHistory)this.session.getAttribute("jeus.tool.xmlui.history");
        }
        if (this.tableModel.getRowCount() >= this.maxOccurs) {
            this.addBT.setEnabled(false);
        }
        return true;
    }

    public Object[] getSelectedValues() {
        ArrayList<Element> values = new ArrayList<Element>();
        int[] rows = this.displayTable.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            values.add(this.tableModel.get(rows[i]));
        }
        return values.toArray();
    }

    public Object getSelectedValue() {
        int row = this.displayTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.tableModel.get(row);
    }

    public Object getValueAt(int index) {
        return this.tableModel.get(index);
    }

    public boolean existInList(Object object) {
        return this.tableModel.contains((Element)object);
    }

    public int getItemCount() {
        return this.tableModel.getSize();
    }

    public Object[] getValues() {
        return this.tableModel.toArray();
    }

    public void modifyValueAt(int index, Object object) {
        this.tableModel.addXMLTree((Element)object, index);
    }

    public int getSelectedIndex() {
        return this.displayTable.getSelectedRow();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.modifyBT.setEnabled(true);
        if (this.isEnabled()) {
            this.removeBT.setEnabled(true);
        }
    }

    public static class XMLTreeTableModel
    extends DefaultTableModel {
        private ArrayList trees = new ArrayList();
        private IColumnParser columnParser;
        private XMLUIContainer cc;

        public XMLTreeTableModel(XMLUIContainer cc) {
            this(cc, new DefaultColumnParser());
        }

        public XMLTreeTableModel(XMLUIContainer cc, IColumnParser columnParser) {
            this.cc = cc;
            this.columnParser = columnParser;
            String[] columns = columnParser.getColumns(cc);
            for (int i = 0; i < columns.length; ++i) {
                this.addColumn(columns[i]);
            }
        }

        public void addXMLTree(Element xmlTree, int index) {
            this.trees.remove(index);
            this.trees.add(index, xmlTree);
            if (index >= this.getRowCount()) {
                this.addRow(this.columnParser.getRow(this.cc, xmlTree));
            } else {
                String[] data = this.columnParser.getRow(this.cc, xmlTree);
                for (int i = 0; i < data.length; ++i) {
                    this.setValueAt(data[i], index, i);
                }
            }
        }

        public void addXMLTree(Element xmlTree) {
            this.trees.add(xmlTree);
            this.addRow(this.columnParser.getRow(this.cc, xmlTree));
        }

        public boolean contains(Element xmlTree) {
            return this.trees.contains(xmlTree);
        }

        public Object[] toArray() {
            return this.trees.toArray();
        }

        public void clear() {
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                this.removeRow(i);
            }
            this.trees.clear();
        }

        public int getSize() {
            return this.trees.size();
        }

        public void removeRow(int row) {
            this.trees.remove(row);
            super.removeRow(row);
        }

        public Element get(int index) {
            if (this.trees.size() > index) {
                return (Element)this.trees.get(index);
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

