/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class AdaptorRegistry {
    private Map registrations = new HashMap();
    private Map cache = new HashMap();

    public synchronized void register(Class registrationClass, Object adaptor) {
        if (this.registrations.containsKey(registrationClass)) {
            throw new IllegalArgumentException(registrationClass.getName());
        }
        this.registrations.put(registrationClass, adaptor);
        this.cache.clear();
    }

    public synchronized Object getAdaptor(Class subjectClass) {
        Object result = this.cache.get(subjectClass);
        if (result != null) {
            return result;
        }
        result = this.searchForAdaptor(subjectClass);
        this.cache.put(subjectClass, result);
        return result;
    }

    private Object searchForAdaptor(Class subjectClass) {
        int i;
        int length;
        Class<?>[] interfaces;
        LinkedList queue = null;
        Object result = null;
        Class searchClass = subjectClass;
        while (searchClass != Object.class && searchClass != null) {
            result = this.registrations.get(searchClass);
            if (result != null) {
                return result;
            }
            interfaces = searchClass.getInterfaces();
            length = interfaces.length;
            if (queue == null && length > 0) {
                queue = new LinkedList();
            }
            for (i = 0; i < length; ++i) {
                queue.addLast(interfaces[i]);
            }
            searchClass = this.getSuperclass(searchClass);
        }
        if (queue != null) {
            while (!queue.isEmpty()) {
                searchClass = (Class)queue.removeFirst();
                result = this.registrations.get(searchClass);
                if (result != null) {
                    return result;
                }
                interfaces = searchClass.getInterfaces();
                length = interfaces.length;
                for (i = 0; i < length; ++i) {
                    queue.addLast(interfaces[i]);
                }
            }
        }
        if ((result = this.registrations.get(Object.class)) != null) {
            return result;
        }
        throw new IllegalArgumentException(subjectClass.getName());
    }

    private Class getSuperclass(Class searchClass) {
        Class<?> componentType;
        if (searchClass.isArray() && !(componentType = searchClass.getComponentType()).isPrimitive() && componentType != Object.class) {
            return Object[].class;
        }
        return searchClass.getSuperclass();
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AdaptorRegistry[");
        Iterator i = this.registrations.entrySet().iterator();
        boolean showSep = false;
        while (i.hasNext()) {
            if (showSep) {
                buffer.append(' ');
            }
            Map.Entry entry = i.next();
            Class registeredClass = (Class)entry.getKey();
            buffer.append(registeredClass.getName());
            buffer.append("=");
            buffer.append(entry.getValue());
            showSep = true;
        }
        buffer.append("]");
        return buffer.toString();
    }
}

