/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import jeus.tool.xmlui.component.BaseValidator;
import jeus.tool.xmlui.component.ValidationException;

public class StringValidator
extends BaseValidator {
    private int _minimumLength;
    private int _maximumLength;
    private int _fixedLength;
    private String _minimumLengthMessage;
    private String _maximumLengthMessage;
    private String _fixedLengthMessage;
    private String _patternMatchingMessage;
    private String _pattern;

    public StringValidator() {
    }

    private StringValidator(boolean required) {
        super(required);
    }

    public void validate(String name, String input) throws ValidationException {
        if (this.checkRequired(name, input)) {
            return;
        }
        if (this._fixedLength > 0 && input.length() != this._fixedLength) {
            throw new ValidationException(this.buildFixedLengthMessage(name));
        }
        if (this._maximumLength > 0 && input.length() > this._maximumLength) {
            throw new ValidationException(this.buildMaximumLengthMessage(name));
        }
        if (this._minimumLength > 0 && input.length() < this._minimumLength) {
            throw new ValidationException(this.buildMinimumLengthMessage(name));
        }
        if (this._pattern != null && !input.matches(this._pattern)) {
            throw new ValidationException(this.buildMinimumLengthMessage(name));
        }
    }

    public int getMinimumLength() {
        return this._minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this._minimumLength = minimumLength;
    }

    public String getMinimumLengthMessage() {
        return this._minimumLengthMessage;
    }

    public void setMinimumLengthMessage(String string) {
        this._minimumLengthMessage = string;
    }

    protected String buildMinimumLengthMessage(String name) {
        String pattern = "You must enter at least {0} characters for @XPATH@.";
        return this.formatString(pattern, Integer.toString(this._minimumLength));
    }

    public int getFixedLength() {
        return this._fixedLength;
    }

    public void setFixedLength(int _fixedLength) {
        this._fixedLength = _fixedLength;
    }

    public void setFixedLengthMessage(String _fixedLengthMessage) {
        this._fixedLengthMessage = _fixedLengthMessage;
    }

    protected String buildFixedLengthMessage(String name) {
        String pattern = "You must enter only {0} characters for @XPATH@.";
        return this.formatString(pattern, Integer.toString(this._fixedLength));
    }

    public int getMaximumLength() {
        return this._maximumLength;
    }

    public void setMaximumLength(int _maximumLength) {
        this._maximumLength = _maximumLength;
    }

    public void setMaximumLengthMessage(String _maximumLengthMessage) {
        this._maximumLengthMessage = _maximumLengthMessage;
    }

    protected String buildMaximumLengthMessage(String name) {
        String pattern = "You must enter maximum {0} characters for @XPATH@.";
        return this.formatString(pattern, Integer.toString(this._maximumLength));
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String _pattern) {
        this._pattern = _pattern;
    }

    public void setPatternMatchingMessage(String patternMatchingMessage) {
        this._patternMatchingMessage = patternMatchingMessage;
    }

    protected String buildPatternMatchingMessage(String name) {
        String pattern = "You must enter string matched by {0} for @XPATH@.";
        return this.formatString(pattern, this._pattern);
    }
}

